/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.jms.failover;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.client.AMQAnyDestination;
import org.wso2.andes.client.AMQBrokerDetails;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.jms.BrokerDetails;
import org.wso2.andes.jms.Connection;
import org.wso2.andes.jms.ConnectionURL;
import org.wso2.andes.jms.failover.FailoverMethod;

public class FailoverExchangeMethod
implements FailoverMethod,
MessageListener {
    private static final Logger _logger = LoggerFactory.getLogger(FailoverExchangeMethod.class);
    private Connection _conn;
    private Object _brokerListLock = new Object();
    private Session _ssn;
    private BrokerDetails _originalBrokerDetail;
    private int _currentBrokerIndex = 0;
    private BrokerDetails _currentBrokerDetail;
    private ConnectionURL _connectionDetails;
    private int _failedAttemps = 0;

    public FailoverExchangeMethod(ConnectionURL connectionDetails, Connection conn) {
        this._connectionDetails = connectionDetails;
        this._originalBrokerDetail = this._connectionDetails.getBrokerDetails(0);
        this._conn = conn;
    }

    private void subscribeForUpdates() throws JMSException {
        if (this._ssn == null) {
            this._ssn = this._conn.createSession(false, 1);
            MessageConsumer cons = this._ssn.createConsumer((Destination)new AMQAnyDestination(new AMQShortString("amq.failover"), new AMQShortString("amq.failover"), new AMQShortString(""), true, true, null, false, new AMQShortString[0]));
            cons.setMessageListener((MessageListener)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message m) {
        _logger.info("Failover exchange notified cluster membership change");
        String currentBrokerIP = "";
        try {
            currentBrokerIP = InetAddress.getByName(this._currentBrokerDetail.getHost()).getHostAddress();
        }
        catch (Exception e) {
            _logger.warn("Unable to resolve current broker host name", (Throwable)e);
        }
        ArrayList<BrokerDetails> brokerList = new ArrayList<BrokerDetails>();
        try {
            List list = (List)m.getObjectProperty("amq.failover");
            block7: for (String brokerEntry : list) {
                String[] urls;
                for (String url : urls = brokerEntry.substring(5).split(",")) {
                    String[] tokens = url.split(":");
                    if (!tokens[0].equalsIgnoreCase(this._originalBrokerDetail.getTransport())) continue;
                    AMQBrokerDetails broker = new AMQBrokerDetails();
                    broker.setTransport(tokens[0]);
                    broker.setHost(tokens[1]);
                    broker.setPort(Integer.parseInt(tokens[2]));
                    broker.setProperties(this._originalBrokerDetail.getProperties());
                    broker.setSSLConfiguration(this._originalBrokerDetail.getSSLConfiguration());
                    brokerList.add(broker);
                    if (!currentBrokerIP.equals(broker.getHost()) || this._currentBrokerDetail.getPort() != broker.getPort()) continue block7;
                    this._currentBrokerIndex = brokerList.indexOf(broker);
                    continue block7;
                }
            }
        }
        catch (JMSException e) {
            _logger.error("Error parsing the message sent by failover exchange", (Throwable)e);
        }
        Object object = this._brokerListLock;
        synchronized (object) {
            this._connectionDetails.setBrokerDetails(brokerList);
        }
        _logger.info("============================================================");
        _logger.info("Updated cluster membership details " + this._connectionDetails);
        _logger.info("============================================================");
    }

    public void attainedConnection() {
        try {
            this._failedAttemps = 0;
            _logger.info("============================================================");
            _logger.info("Attained connection ");
            _logger.info("============================================================");
            this.subscribeForUpdates();
        }
        catch (JMSException e) {
            throw new RuntimeException("Unable to subscribe for cluster membership updates", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrokerDetails getCurrentBrokerDetails() {
        Object object = this._brokerListLock;
        synchronized (object) {
            this._currentBrokerDetail = this._connectionDetails.getBrokerDetails(this._currentBrokerIndex);
            return this._currentBrokerDetail;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BrokerDetails getNextBrokerDetails() {
        BrokerDetails broker = null;
        Object object = this._brokerListLock;
        synchronized (object) {
            this._currentBrokerIndex = this._currentBrokerIndex == this._connectionDetails.getBrokerCount() - 1 ? 0 : ++this._currentBrokerIndex;
            broker = this._connectionDetails.getBrokerDetails(this._currentBrokerIndex);
            if (this._currentBrokerDetail != null && broker.getHost().equals(this._currentBrokerDetail.getHost()) && broker.getPort() == this._currentBrokerDetail.getPort()) {
                if (this._connectionDetails.getBrokerCount() > 1) {
                    return this.getNextBrokerDetails();
                }
                ++this._failedAttemps;
                return null;
            }
        }
        String delayStr = broker.getProperty("connectdelay");
        if (delayStr != null) {
            Long delay = Long.parseLong(delayStr);
            _logger.info("Delay between connect retries:" + delay);
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException ie) {
                return null;
            }
        } else {
            _logger.info("No delay between connect retries, use tcp://host:port?connectdelay='value' to enable.");
        }
        ++this._failedAttemps;
        this._currentBrokerDetail = broker;
        return broker;
    }

    public boolean failoverAllowed() {
        boolean b = this._connectionDetails.getBrokerCount() > 0 && this._failedAttemps <= this._connectionDetails.getBrokerCount();
        _logger.info("============================================================");
        _logger.info(this.toString());
        _logger.info("FailoverAllowed " + b);
        _logger.info("============================================================");
        return b;
    }

    public void reset() {
        this._failedAttemps = 0;
    }

    public void setBroker(BrokerDetails broker) {
    }

    public void setRetries(int maxRetries) {
    }

    public String methodName() {
        return "Failover Exchange";
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("FailoverExchange:\n");
        sb.append("\n Current Broker Index:");
        sb.append(this._currentBrokerIndex);
        sb.append("\n Failed Attempts:");
        sb.append(this._failedAttemps);
        sb.append("\n Orignal broker details:");
        sb.append(this._originalBrokerDetail).append("\n");
        sb.append("\n -------- Broker List -----------\n");
        for (int i = 0; i < this._connectionDetails.getBrokerCount(); ++i) {
            if (i == this._currentBrokerIndex) {
                sb.append(">");
            }
            sb.append(this._connectionDetails.getBrokerDetails(i));
            sb.append("\n");
        }
        sb.append("--------------------------------\n");
        return sb.toString();
    }
}

