/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util;

import java.util.Random;

class UIDGeneratorImpl {
    private static final long startTimeXorOperand;
    private static final long threadIdXorOperand;
    private static final long seqXorOperand;
    private final String suffix;
    private long seq;

    UIDGeneratorImpl() {
        long xoredThreadId = Thread.currentThread().getId() ^ threadIdXorOperand;
        long xoredStartTime = System.currentTimeMillis() ^ startTimeXorOperand;
        StringBuilder buffer = new StringBuilder();
        this.writeReverseLongHex(xoredStartTime, buffer);
        this.writeReverseLongHex(xoredThreadId, buffer);
        this.suffix = buffer.toString();
    }

    private void writeReverseLongHex(long value, StringBuilder buffer) {
        for (int i = 0; i < 16; ++i) {
            int n = (int)(value >> 4 * i) & 0xF;
            buffer.append((char)(n < 10 ? 48 + n : 97 + n - 10));
        }
    }

    void generateHex(StringBuilder buffer) {
        this.writeReverseLongHex(this.seq++ ^ seqXorOperand, buffer);
        buffer.append(this.suffix);
    }

    static {
        Random rand = new Random();
        threadIdXorOperand = rand.nextLong();
        startTimeXorOperand = rand.nextLong();
        seqXorOperand = rand.nextLong();
    }
}

