/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt;

import java.io.IOException;
import java.io.InputStream;
import javax.activation.DataHandler;
import org.apache.axis2.AxisFault;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.CarbonConstants;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.context.RegistryType;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.mgt.UserRealmProxy;
import org.wso2.carbon.user.mgt.common.ClaimValue;
import org.wso2.carbon.user.mgt.common.FlaggedName;
import org.wso2.carbon.user.mgt.common.UIPermissionNode;
import org.wso2.carbon.user.mgt.common.UserAdminException;
import org.wso2.carbon.user.mgt.common.UserRealmInfo;

public class UserAdmin {
    private static Log log = LogFactory.getLog(UserAdmin.class);
    private static Log audit = CarbonConstants.AUDIT_LOG;
    private static String AUDIT_MESSAGE = "Initiator : %s | Action : %s | Target : %s | Data : { %s } | Result : %s ";

    public String[] listUsers(String filter, int limit) throws UserAdminException {
        String[] users = this.getUserAdminProxy().listUsers(filter, limit);
        return users;
    }

    public FlaggedName[] listAllUsers(String filter, int limit) throws UserAdminException {
        FlaggedName[] names = this.getUserAdminProxy().listAllUsers(filter, limit);
        return names;
    }

    public FlaggedName[] getAllRolesNames(String filter, int limit) throws UserAdminException {
        return this.getUserAdminProxy().getAllRolesNames(filter, limit);
    }

    public FlaggedName[] getAllSharedRoleNames(String filter, int limit) throws UserAdminException {
        return this.getUserAdminProxy().getAllRolesNames(filter, limit);
    }

    public UserRealmInfo getUserRealmInfo() throws UserAdminException {
        return this.getUserAdminProxy().getUserRealmInfo();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addUser(String userName, String password, String[] roles, ClaimValue[] claims, String profileName) throws UserAdminException {
        StringBuilder builder;
        String result;
        block7: {
            result = null;
            try {
                this.getUserAdminProxy().addUser(userName, password, roles, claims, profileName);
                result = "Success";
                builder = new StringBuilder();
                if (roles == null) break block7;
            }
            catch (UserAdminException e) {
                try {
                    result = "Failed";
                    throw e;
                }
                catch (Throwable throwable) {
                    StringBuilder builder2 = new StringBuilder();
                    if (roles != null) {
                        for (int i = 0; i < roles.length; ++i) {
                            builder2.append(roles[i] + ",");
                        }
                    }
                    audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Add User", userName, "Roles :" + builder2.toString(), result));
                    throw throwable;
                }
            }
            for (int i = 0; i < roles.length; ++i) {
                builder.append(roles[i] + ",");
            }
        }
        audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Add User", userName, "Roles :" + builder.toString(), result));
    }

    public void changePassword(String userName, String newPassword) throws UserAdminException {
        String result = null;
        try {
            this.getUserAdminProxy().changePassword(userName, newPassword);
            result = "Success";
        }
        catch (UserAdminException e) {
            try {
                result = "Failed";
                throw e;
            }
            catch (Throwable throwable) {
                audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Change Password by Administrator", userName, "", result));
                throw throwable;
            }
        }
        audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Change Password by Administrator", userName, "", result));
    }

    public void deleteUser(String userName) throws UserAdminException {
        String result = null;
        try {
            this.getUserAdminProxy().deleteUser(userName, CarbonContext.getCurrentContext().getRegistry(RegistryType.USER_CONFIGURATION));
            result = "Success";
        }
        catch (UserAdminException e) {
            try {
                result = "Failed";
                throw e;
            }
            catch (Throwable throwable) {
                audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Delete User", userName, "", result));
                throw throwable;
            }
        }
        audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Delete User", userName, "", result));
    }

    public void addRole(String roleName, String[] userList, String[] permissions, boolean isSharedRole) throws UserAdminException {
        StringBuilder users;
        String result;
        block12: {
            result = null;
            try {
                UserRealm realm = (UserRealm)CarbonContext.getCurrentContext().getUserRealm();
                if (!this.isAllowedRoleName(roleName, realm)) {
                    throw new UserAdminException("Role name is reserved by the system");
                }
                this.getUserAdminProxy().addRole(roleName, userList, permissions, isSharedRole);
                result = "Success";
                users = new StringBuilder();
                if (userList == null) break block12;
            }
            catch (UserAdminException e) {
                try {
                    result = "Failed";
                    throw e;
                }
                catch (Throwable throwable) {
                    StringBuilder users2 = new StringBuilder();
                    if (userList != null) {
                        for (int i = 0; i < userList.length; ++i) {
                            users2.append(userList[i] + ",");
                        }
                    }
                    StringBuilder perms = new StringBuilder();
                    if (permissions != null) {
                        for (int i = 0; i < permissions.length; ++i) {
                            perms.append(permissions[i] + ",");
                        }
                    }
                    audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Add Role", roleName, "Users : " + users2.toString() + " Permissions : " + permissions.toString(), result));
                    throw throwable;
                }
            }
            for (int i = 0; i < userList.length; ++i) {
                users.append(userList[i] + ",");
            }
        }
        StringBuilder perms = new StringBuilder();
        if (permissions != null) {
            for (int i = 0; i < permissions.length; ++i) {
                perms.append(permissions[i] + ",");
            }
        }
        audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Add Role", roleName, "Users : " + users.toString() + " Permissions : " + permissions.toString(), result));
    }

    public void addInternalRole(String roleName, String[] userList, String[] permissions) throws UserAdminException {
        StringBuilder users;
        String result;
        block12: {
            result = null;
            try {
                UserRealm realm = (UserRealm)CarbonContext.getCurrentContext().getUserRealm();
                if (!this.isAllowedRoleName(roleName, realm)) {
                    throw new UserAdminException("Role name is reserved by the system");
                }
                this.getUserAdminProxy().addInternalRole(roleName, userList, permissions);
                result = "Success";
                users = new StringBuilder();
                if (userList == null) break block12;
            }
            catch (UserAdminException e) {
                try {
                    result = "Failed";
                    throw e;
                }
                catch (Throwable throwable) {
                    StringBuilder users2 = new StringBuilder();
                    if (userList != null) {
                        for (int i = 0; i < userList.length; ++i) {
                            users2.append(userList[i] + ",");
                        }
                    }
                    StringBuilder perms = new StringBuilder();
                    if (permissions != null) {
                        for (int i = 0; i < permissions.length; ++i) {
                            perms.append(permissions[i] + ",");
                        }
                    }
                    audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Add Internal Role", roleName, "Users : " + users2.toString() + " Permissions : " + permissions.toString(), result));
                    throw throwable;
                }
            }
            for (int i = 0; i < userList.length; ++i) {
                users.append(userList[i] + ",");
            }
        }
        StringBuilder perms = new StringBuilder();
        if (permissions != null) {
            for (int i = 0; i < permissions.length; ++i) {
                perms.append(permissions[i] + ",");
            }
        }
        audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Add Internal Role", roleName, "Users : " + users.toString() + " Permissions : " + permissions.toString(), result));
    }

    private boolean isAllowedRoleName(String roleName, UserRealm realm) throws UserAdminException {
        int index = roleName.indexOf("/");
        if (index > 0) {
            roleName = roleName.substring(index + 1);
        }
        try {
            return !realm.getRealmConfiguration().isReservedRoleName(roleName);
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void deleteRole(String roleName) throws UserAdminException {
        String result = null;
        try {
            this.getUserAdminProxy().deleteRole(roleName);
            result = "Success";
        }
        catch (UserAdminException e) {
            try {
                result = "Failed";
                throw e;
            }
            catch (Throwable throwable) {
                audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Delete Role", roleName, "", result));
                throw throwable;
            }
        }
        audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Delete Role", roleName, "", result));
    }

    public void updateRoleName(String roleName, String newRoleName) throws UserAdminException {
        String result = null;
        try {
            this.getUserAdminProxy().updateRoleName(roleName, newRoleName);
            result = "Success";
        }
        catch (UserAdminException e) {
            try {
                result = "Failed";
                throw e;
            }
            catch (Throwable throwable) {
                audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Update Role Name", roleName, "Old : " + roleName + " New : " + newRoleName, result));
                throw throwable;
            }
        }
        audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Update Role Name", roleName, "Old : " + roleName + " New : " + newRoleName, result));
    }

    public boolean hasMultipleUserStores() throws UserAdminException {
        return this.getUserAdminProxy().hasMultipleUserStores();
    }

    public FlaggedName[] getUsersOfRole(String roleName, String filter, int limit) throws UserAdminException {
        return this.getUserAdminProxy().getUsersOfRole(roleName, filter, limit);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateUsersOfRole(String roleName, FlaggedName[] userList) throws UserAdminException {
        StringBuilder users;
        String result;
        block7: {
            result = null;
            try {
                this.getUserAdminProxy().updateUsersOfRole(roleName, userList);
                result = "Success";
                users = new StringBuilder();
                if (userList == null) break block7;
            }
            catch (UserAdminException e) {
                try {
                    result = "Failed";
                    throw e;
                }
                catch (Throwable throwable) {
                    StringBuilder users2 = new StringBuilder();
                    if (userList != null) {
                        for (int i = 0; i < userList.length; ++i) {
                            if (userList[i] == null) continue;
                            users2.append(userList[i].getItemName() + ",");
                        }
                    }
                    audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Update Users of Role", roleName, "Users : " + users2.toString(), result));
                    throw throwable;
                }
            }
            for (int i = 0; i < userList.length; ++i) {
                if (userList[i] == null) continue;
                users.append(userList[i].getItemName() + ",");
            }
        }
        audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Update Users of Role", roleName, "Users : " + users.toString(), result));
    }

    public FlaggedName[] getRolesOfUser(String userName, String filter, int limit) throws UserAdminException {
        return this.getUserAdminProxy().getRolesOfUser(userName, filter, limit);
    }

    public FlaggedName[] getRolesOfCurrentUser() throws UserAdminException {
        return this.getRolesOfUser(CarbonContext.getCurrentContext().getUsername(), "*", -1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void updateRolesOfUser(String userName, String[] newUserList) throws UserAdminException {
        StringBuilder roles;
        String result;
        block7: {
            result = null;
            try {
                this.getUserAdminProxy().updateRolesOfUser(userName, newUserList);
                result = "Success";
                roles = new StringBuilder();
                if (newUserList == null) break block7;
            }
            catch (UserAdminException e) {
                try {
                    result = "Failed";
                    throw e;
                }
                catch (Throwable throwable) {
                    StringBuilder roles2 = new StringBuilder();
                    if (newUserList != null) {
                        for (int i = 0; i < newUserList.length; ++i) {
                            if (newUserList[i] == null) continue;
                            roles2.append(newUserList[i] + ",");
                        }
                    }
                    audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Update Users of Role", userName, "Roles : " + roles2.toString(), result));
                    throw throwable;
                }
            }
            for (int i = 0; i < newUserList.length; ++i) {
                if (newUserList[i] == null) continue;
                roles.append(newUserList[i] + ",");
            }
        }
        audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Update Users of Role", userName, "Roles : " + roles.toString(), result));
    }

    public UIPermissionNode getAllUIPermissions() throws UserAdminException {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        return this.getUserAdminProxy().getAllUIPermissions(tenantId);
    }

    public UIPermissionNode getRolePermissions(String roleName) throws UserAdminException {
        int tenantId = CarbonContext.getCurrentContext().getTenantId();
        return this.getUserAdminProxy().getRolePermissions(roleName, tenantId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setRoleUIPermission(String roleName, String[] rawResources) throws UserAdminException {
        StringBuilder permissions;
        String result;
        block7: {
            result = null;
            try {
                this.getUserAdminProxy().setRoleUIPermission(roleName, rawResources);
                result = "Success";
                permissions = new StringBuilder();
                if (rawResources == null) break block7;
            }
            catch (UserAdminException e) {
                try {
                    result = "Failed";
                    throw e;
                }
                catch (Throwable throwable) {
                    StringBuilder permissions2 = new StringBuilder();
                    if (rawResources != null) {
                        for (int i = 0; i < rawResources.length; ++i) {
                            if (rawResources[i] == null) continue;
                            permissions2.append(rawResources[i] + ",");
                        }
                    }
                    audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Set Role UI Permissions", roleName, "Permissions : " + permissions2.toString(), result));
                    throw throwable;
                }
            }
            for (int i = 0; i < rawResources.length; ++i) {
                if (rawResources[i] == null) continue;
                permissions.append(rawResources[i] + ",");
            }
        }
        audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Set Role UI Permissions", roleName, "Permissions : " + permissions.toString(), result));
    }

    public void bulkImportUsers(String fileName, DataHandler handler, String defaultPassword) throws UserAdminException {
        if (fileName == null || handler == null || defaultPassword == null) {
            throw new UserAdminException("Required data not provided");
        }
        try {
            InputStream inStream = handler.getInputStream();
            this.getUserAdminProxy().bulkImportUsers(fileName, inStream, defaultPassword);
        }
        catch (IOException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void changePasswordByUser(String oldPassword, String newPassword) throws UserAdminException, AxisFault {
        String result = null;
        try {
            this.getUserAdminProxy().changePasswordByUser(oldPassword, newPassword);
            result = "Success";
        }
        catch (UserAdminException e) {
            try {
                result = "Failed";
                throw e;
            }
            catch (Throwable throwable) {
                audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Change Password by User", this.getUser(), "", result));
                throw throwable;
            }
        }
        audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Change Password by User", this.getUser(), "", result));
    }

    public void addRemoveUsersOfRole(String roleName, String[] newUsers, String[] deletedUsers) throws UserAdminException {
        StringBuilder newUsersList;
        String result;
        block11: {
            result = null;
            try {
                this.getUserAdminProxy().updateUsersOfRole(roleName, newUsers, deletedUsers);
                result = "Success";
                newUsersList = new StringBuilder();
                if (newUsers == null) break block11;
            }
            catch (UserAdminException e) {
                try {
                    result = "Failed";
                    throw e;
                }
                catch (Throwable throwable) {
                    StringBuilder newUsersList2 = new StringBuilder();
                    if (newUsers != null) {
                        for (int i = 0; i < newUsers.length; ++i) {
                            newUsersList2.append(newUsers[i] + ",");
                        }
                    }
                    StringBuilder deletedUsersList = new StringBuilder();
                    if (deletedUsers != null) {
                        for (int i = 0; i < deletedUsers.length; ++i) {
                            deletedUsersList.append(deletedUsers[i] + ",");
                        }
                    }
                    audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Add/Remove Users from Role", roleName, "New Users : " + newUsersList2.toString() + " Deleted Users : " + deletedUsersList.toString(), result));
                    throw throwable;
                }
            }
            for (int i = 0; i < newUsers.length; ++i) {
                newUsersList.append(newUsers[i] + ",");
            }
        }
        StringBuilder deletedUsersList = new StringBuilder();
        if (deletedUsers != null) {
            for (int i = 0; i < deletedUsers.length; ++i) {
                deletedUsersList.append(deletedUsers[i] + ",");
            }
        }
        audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Add/Remove Users from Role", roleName, "New Users : " + newUsersList.toString() + " Deleted Users : " + deletedUsersList.toString(), result));
    }

    public void addRemoveRolesOfUser(String userName, String[] newRoles, String[] deletedRoles) throws UserAdminException {
        StringBuilder newRolesList;
        String result;
        block11: {
            result = null;
            try {
                this.getUserAdminProxy().updateRolesOfUser(userName, newRoles, deletedRoles);
                result = "Success";
                newRolesList = new StringBuilder();
                if (newRoles == null) break block11;
            }
            catch (UserAdminException e) {
                try {
                    result = "Failed";
                    throw e;
                }
                catch (Throwable throwable) {
                    StringBuilder newRolesList2 = new StringBuilder();
                    if (newRoles != null) {
                        for (int i = 0; i < newRoles.length; ++i) {
                            newRolesList2.append(newRoles[i] + ",");
                        }
                    }
                    StringBuilder deletedUsersList = new StringBuilder();
                    if (deletedRoles != null) {
                        for (int i = 0; i < deletedRoles.length; ++i) {
                            deletedUsersList.append(deletedRoles[i] + ",");
                        }
                    }
                    audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Add/Remove Roles from User", userName, "New Roles : " + newRolesList2.toString() + " Deleted Roles : " + deletedUsersList.toString(), result));
                    throw throwable;
                }
            }
            for (int i = 0; i < newRoles.length; ++i) {
                newRolesList.append(newRoles[i] + ",");
            }
        }
        StringBuilder deletedUsersList = new StringBuilder();
        if (deletedRoles != null) {
            for (int i = 0; i < deletedRoles.length; ++i) {
                deletedUsersList.append(deletedRoles[i] + ",");
            }
        }
        audit.info((Object)String.format(AUDIT_MESSAGE, this.getUser(), "Add/Remove Roles from User", userName, "New Roles : " + newRolesList.toString() + " Deleted Roles : " + deletedUsersList.toString(), result));
    }

    public FlaggedName[] listUserByClaim(ClaimValue claimValue, String filter, int maxLimit) throws UserAdminException {
        return this.getUserAdminProxy().listUsers(claimValue, filter, maxLimit);
    }

    private UserRealmProxy getUserAdminProxy() {
        UserRealm realm = (UserRealm)CarbonContext.getCurrentContext().getUserRealm();
        return new UserRealmProxy(realm);
    }

    private String getUser() {
        return CarbonContext.getCurrentContext().getUsername() + "@" + CarbonContext.getCurrentContext().getTenantDomain();
    }

    public boolean isSharedRolesEnabled() throws UserAdminException {
        return this.getUserAdminProxy().isSharedRolesEnabled();
    }
}

