/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.statistics.publisher.wso2.cep;

import java.util.ArrayList;
import org.apache.stratos.common.statistics.publisher.InFlightRequestPublisher;
import org.apache.stratos.common.statistics.publisher.wso2.cep.WSO2CEPStatisticsPublisher;
import org.wso2.carbon.databridge.commons.Attribute;
import org.wso2.carbon.databridge.commons.AttributeType;
import org.wso2.carbon.databridge.commons.StreamDefinition;

public class WSO2CEPInFlightRequestPublisher
extends WSO2CEPStatisticsPublisher
implements InFlightRequestPublisher {
    private static final String DATA_STREAM_NAME = "in_flight_requests";
    private static final String VERSION = "1.0.0";

    public WSO2CEPInFlightRequestPublisher() {
        super(WSO2CEPInFlightRequestPublisher.createStreamDefinition());
    }

    private static StreamDefinition createStreamDefinition() {
        try {
            StreamDefinition streamDefinition = new StreamDefinition(DATA_STREAM_NAME, VERSION);
            streamDefinition.setNickName("lb stats");
            streamDefinition.setDescription("lb stats");
            ArrayList<Attribute> payloadData = new ArrayList<Attribute>();
            payloadData.add(new Attribute("cluster_id", AttributeType.STRING));
            payloadData.add(new Attribute("cluster_instance_id", AttributeType.STRING));
            payloadData.add(new Attribute("network_partition_id", AttributeType.STRING));
            payloadData.add(new Attribute("in_flight_request_count", AttributeType.DOUBLE));
            streamDefinition.setPayloadData(payloadData);
            return streamDefinition;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create stream definition", e);
        }
    }

    @Override
    public void publish(String clusterId, String clusterInstanceId, String networkPartitionId, int inFlightRequestCount) {
        ArrayList<Object> payload = new ArrayList<Object>();
        payload.add(clusterId);
        payload.add(clusterInstanceId);
        payload.add(networkPartitionId);
        payload.add(Double.valueOf(inFlightRequestCount));
        super.publish(payload.toArray());
    }
}

