/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.concurrent.locks;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.concurrent.locks.LockMetadata;
import org.apache.stratos.common.concurrent.locks.LockType;
import org.apache.stratos.common.concurrent.locks.ReadWriteLock;
import org.apache.stratos.common.exception.LockNotReleasedException;

class ReadWriteLockMonitor
implements Runnable {
    private static final Log log = LogFactory.getLog(ReadWriteLockMonitor.class);
    private long lockTimeout = Long.getLong("read.write.lock.timeout", 30000L);
    private ReadWriteLock readWriteLock;

    ReadWriteLockMonitor(ReadWriteLock readWriteLock) {
        this.readWriteLock = readWriteLock;
    }

    @Override
    public void run() {
        try {
            if (this.readWriteLock.getThreadToLockSetMap() != null) {
                for (Map.Entry<Long, Map<LockType, LockMetadata>> entry : this.readWriteLock.getThreadToLockSetMap().entrySet()) {
                    Map<LockType, LockMetadata> lockTypeLongMap = entry.getValue();
                    LockMetadata lockMetadata = lockTypeLongMap.get((Object)LockType.Read);
                    if (lockMetadata != null) {
                        this.checkTimeout(lockMetadata);
                    }
                    if ((lockMetadata = lockTypeLongMap.get((Object)LockType.Write)) == null) continue;
                    this.checkTimeout(lockMetadata);
                }
            }
        }
        catch (Exception e) {
            String message = "Read write lock monitor failed";
            log.error((Object)message, (Throwable)e);
        }
    }

    private void checkTimeout(LockMetadata lockMetadata) {
        if (System.currentTimeMillis() - lockMetadata.getCreatedTime() > this.lockTimeout) {
            String message = String.format("System error, lock has not released for %d seconds: [lock-name] %s [lock-type] %s [thread-id] %d [thread-name] %s [stack-trace] \n%s", new Object[]{this.lockTimeout / 1000L, lockMetadata.getLockName(), lockMetadata.getLockType(), lockMetadata.getThreadId(), lockMetadata.getThreadName(), this.stackTraceToString(lockMetadata.getStackTrace())});
            LockNotReleasedException exception = new LockNotReleasedException();
            log.error((Object)message, (Throwable)exception);
        }
    }

    private String stackTraceToString(StackTraceElement[] stackTraceElements) {
        StringBuffer sb = new StringBuffer();
        if (stackTraceElements != null) {
            for (StackTraceElement element : stackTraceElements) {
                if (element == null) continue;
                sb.append(element.toString()).append("\n");
            }
        }
        return sb.toString();
    }
}

