/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.lucene;

import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.compass.core.Property;
import org.compass.core.Resource;
import org.compass.core.converter.mapping.ResourcePropertyConverter;
import org.compass.core.engine.SearchEngineException;
import org.compass.core.lucene.LuceneProperty;
import org.compass.core.lucene.engine.LuceneSearchEngineFactory;
import org.compass.core.lucene.util.LuceneUtils;
import org.compass.core.mapping.ResourceMapping;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.spi.AliasedObject;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.ResourceKey;
import org.compass.core.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LuceneResource
implements AliasedObject,
InternalResource,
Map<String, Property[]> {
    private static final long serialVersionUID = 3904681565727306034L;
    private Document document;
    private ArrayList<Property> properties = new ArrayList();
    private String aliasProperty;
    private int docNum;
    private transient LuceneSearchEngineFactory searchEngineFactory;
    private transient ResourceMapping resourceMapping;
    private transient ResourceKey resourceKey;

    public LuceneResource(String alias, LuceneSearchEngineFactory searchEngineFactory) {
        this(alias, new Document(), -1, searchEngineFactory);
    }

    public LuceneResource(Document document, int docNum, LuceneSearchEngineFactory searchEngineFactory) {
        this(null, document, docNum, searchEngineFactory);
    }

    public LuceneResource(String alias, Document document, int docNum, LuceneSearchEngineFactory searchEngineFactory) {
        this.document = document;
        this.searchEngineFactory = searchEngineFactory;
        this.aliasProperty = searchEngineFactory.getAliasProperty();
        this.docNum = docNum;
        if (alias != null) {
            this.removeProperties(this.aliasProperty);
            Field aliasField = new Field(this.aliasProperty, alias, Field.Store.YES, Field.Index.UN_TOKENIZED);
            aliasField.setOmitNorms(true);
            document.add(aliasField);
        }
        this.verifyResourceMapping();
        List fields = document.getFields();
        for (Field field : fields) {
            LuceneProperty lProperty = new LuceneProperty(field);
            lProperty.setPropertyMapping(this.resourceMapping.getResourcePropertyMapping(field.name()));
            this.properties.add(lProperty);
        }
    }

    @Override
    public void copy(Resource resource) {
        LuceneResource luceneResource = (LuceneResource)resource;
        this.document = luceneResource.document;
        this.docNum = luceneResource.docNum;
        this.properties = luceneResource.properties;
        this.aliasProperty = luceneResource.aliasProperty;
        this.searchEngineFactory = luceneResource.searchEngineFactory;
        this.resourceMapping = luceneResource.resourceMapping;
    }

    public Document getDocument() {
        return this.document;
    }

    @Override
    public ResourceKey resourceKey() {
        if (this.resourceKey == null) {
            this.resourceKey = new ResourceKey(this.resourceMapping, this);
        }
        return this.resourceKey;
    }

    @Override
    public String getSubIndex() {
        return this.resourceKey().getSubIndex();
    }

    @Override
    public String getValue(String name) {
        return this.document.get(name);
    }

    @Override
    public Object getObject(String name) {
        Property prop = this.getProperty(name);
        if (prop == null) {
            return null;
        }
        return prop.getObjectValue();
    }

    @Override
    public Object[] getObjects(String name) {
        Property[] props = this.getProperties(name);
        Object[] ret = new Object[props.length];
        for (int i = 0; i < props.length; ++i) {
            ret[i] = props[i].getObjectValue();
        }
        return ret;
    }

    @Override
    public String[] getValues(String name) {
        return this.document.getValues(name);
    }

    @Override
    public String getAlias() {
        return this.getValue(this.aliasProperty);
    }

    @Override
    public String getUID() {
        return this.resourceKey().buildUID();
    }

    @Override
    public String getId() {
        String[] ids = this.getIds();
        return ids[0];
    }

    @Override
    public String[] getIds() {
        Property[] idProperties = this.getIdProperties();
        String[] ids = new String[idProperties.length];
        for (int i = 0; i < idProperties.length; ++i) {
            if (idProperties[i] == null) continue;
            ids[i] = idProperties[i].getStringValue();
        }
        return ids;
    }

    @Override
    public Property getIdProperty() {
        Property[] idProperties = this.getIdProperties();
        return idProperties[0];
    }

    @Override
    public Property[] getIdProperties() {
        return this.resourceKey().getIds();
    }

    @Override
    public Resource addProperty(String name, Object value) throws SearchEngineException {
        String alias = this.getAlias();
        ResourcePropertyMapping propertyMapping = this.resourceMapping.getResourcePropertyMapping(name);
        if (propertyMapping == null) {
            throw new SearchEngineException("No resource property mapping is defined for alias [" + alias + "] and resource property [" + name + "]");
        }
        ResourcePropertyConverter converter = (ResourcePropertyConverter)propertyMapping.getConverter();
        if (converter == null) {
            converter = (ResourcePropertyConverter)this.searchEngineFactory.getMapping().getConverterLookup().lookupConverter(value.getClass());
        }
        String strValue = converter.toString(value, propertyMapping);
        Property property = this.searchEngineFactory.getResourceFactory().createProperty(strValue, propertyMapping);
        property.setBoost(propertyMapping.getBoost());
        return this.addProperty(property);
    }

    @Override
    public Resource addProperty(String name, Reader value) throws SearchEngineException {
        String alias = this.getAlias();
        ResourcePropertyMapping propertyMapping = this.resourceMapping.getResourcePropertyMapping(name);
        if (propertyMapping == null) {
            throw new SearchEngineException("No resource property mapping is defined for alias [" + alias + "] and resource property [" + name + "]");
        }
        Field.TermVector fieldTermVector = LuceneUtils.getFieldTermVector(propertyMapping.getTermVector());
        Field field = new Field(name, value, fieldTermVector);
        LuceneProperty property = new LuceneProperty(field);
        property.setBoost(propertyMapping.getBoost());
        property.setPropertyMapping(propertyMapping);
        return this.addProperty(property);
    }

    @Override
    public Resource addProperty(Property property) {
        LuceneProperty lProperty = (LuceneProperty)property;
        lProperty.setPropertyMapping(this.resourceMapping.getResourcePropertyMapping(property.getName()));
        this.properties.add(property);
        this.document.add(lProperty.getField());
        return this;
    }

    @Override
    public Resource setProperty(String name, Object value) throws SearchEngineException {
        this.removeProperties(name);
        return this.addProperty(name, value);
    }

    @Override
    public Resource setProperty(String name, Reader value) throws SearchEngineException {
        this.removeProperties(name);
        return this.addProperty(name, value);
    }

    @Override
    public Resource setProperty(Property property) {
        this.removeProperties(property.getName());
        return this.addProperty(property);
    }

    @Override
    public Resource removeProperty(String name) {
        this.document.removeField(name);
        Iterator<Property> it = this.properties.iterator();
        while (it.hasNext()) {
            Property property = it.next();
            if (!property.getName().equals(name)) continue;
            it.remove();
            return this;
        }
        return this;
    }

    @Override
    public Resource removeProperties(String name) {
        this.document.removeFields(name);
        Iterator<Property> it = this.properties.iterator();
        while (it.hasNext()) {
            Property property = it.next();
            if (!property.getName().equals(name)) continue;
            it.remove();
        }
        return this;
    }

    @Override
    public Property getProperty(String name) {
        for (Property property : this.properties) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    @Override
    public Property[] getProperties(String name) {
        ArrayList<Property> result = new ArrayList<Property>();
        for (int i = 0; i < this.properties.size(); ++i) {
            Property property = this.properties.get(i);
            if (!property.getName().equals(name)) continue;
            result.add(property);
        }
        if (result.size() == 0) {
            return new Property[0];
        }
        return result.toArray(new Property[result.size()]);
    }

    @Override
    public Property[] getProperties() {
        return this.properties.toArray(new Property[this.properties.size()]);
    }

    @Override
    public float getBoost() {
        return this.document.getBoost();
    }

    @Override
    public Resource setBoost(float boost) {
        this.document.setBoost(boost);
        return this;
    }

    public void setDocNum(int docNum) {
        this.docNum = docNum;
    }

    public int getDocNum() {
        return this.docNum;
    }

    @Override
    public void addUID() {
        this.removeProperties(this.resourceMapping.getUIDPath());
        Property uidProp = this.searchEngineFactory.getResourceFactory().createProperty(this.resourceMapping.getUIDPath(), this.resourceKey().buildUID(), Property.Store.YES, Property.Index.UN_TOKENIZED);
        uidProp.setOmitNorms(true);
        this.addProperty(uidProp);
    }

    private void verifyResourceMapping() throws SearchEngineException {
        String alias = this.getAlias();
        if (this.resourceMapping == null) {
            if (alias == null) {
                throw new SearchEngineException("Can't add a resource property based on resource mapping without an alias associated with the resource first");
            }
            if (!this.searchEngineFactory.getMapping().hasRootMappingByAlias(alias)) {
                throw new SearchEngineException("No mapping is defined for alias [" + alias + "]");
            }
            this.resourceMapping = this.searchEngineFactory.getMapping().getRootMappingByAlias(alias);
        }
    }

    public String toString() {
        return "{" + this.getAlias() + "} " + StringUtils.arrayToCommaDelimitedString(this.getProperties());
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Map operations are supported for read operations only");
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException("Map operations are supported for read operations only");
    }

    @Override
    public void putAll(Map<? extends String, ? extends Property[]> t) {
        for (Map.Entry<? extends String, ? extends Property[]> entry : t.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Property[] remove(Object key) {
        this.removeProperties(key.toString());
        return null;
    }

    @Override
    public Property[] put(String key, Property[] value) {
        this.removeProperties(key);
        for (Property aValue : value) {
            this.addProperty(aValue);
        }
        return null;
    }

    @Override
    public Set<Map.Entry<String, Property[]>> entrySet() {
        Set<String> keySey = this.keySet();
        HashSet<1> entrySet = new HashSet<1>();
        Iterator<String> it = keySey.iterator();
        while (it.hasNext()) {
            final String name = it.next().toString();
            final Property[] props = this.getProperties(name);
            entrySet.add(new Map.Entry<String, Property[]>(){

                @Override
                public String getKey() {
                    return name;
                }

                @Override
                public Property[] getValue() {
                    return props;
                }

                @Override
                public Property[] setValue(Property[] value) {
                    LuceneResource.this.put(name, value);
                    return null;
                }
            });
        }
        return Collections.unmodifiableSet(entrySet);
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keySet = new HashSet<String>();
        for (Property property : this.properties) {
            keySet.add(property.getName());
        }
        return Collections.unmodifiableSet(keySet);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.getProperty(key.toString()) != null;
    }

    @Override
    public int size() {
        return this.properties.size();
    }

    @Override
    public boolean isEmpty() {
        return this.properties.isEmpty();
    }

    @Override
    public Collection<Property[]> values() {
        Set<String> keySet = this.keySet();
        ArrayList<Property[]> values = new ArrayList<Property[]>();
        for (String name : keySet) {
            values.add(this.getProperties(name));
        }
        return Collections.unmodifiableList(values);
    }

    @Override
    public Property[] get(Object key) {
        return this.getProperties(key.toString());
    }
}

