/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.impl;

import org.compass.core.CompassAnalyzerHelper;
import org.compass.core.CompassException;
import org.compass.core.CompassHits;
import org.compass.core.CompassQuery;
import org.compass.core.CompassQueryBuilder;
import org.compass.core.CompassQueryFilterBuilder;
import org.compass.core.CompassSession;
import org.compass.core.CompassTermFreqsBuilder;
import org.compass.core.CompassTransaction;
import org.compass.core.Resource;
import org.compass.core.ResourceFactory;
import org.compass.core.cache.first.FirstLevelCache;
import org.compass.core.cache.first.NullFirstLevelCache;
import org.compass.core.cascade.CascadingManager;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.RuntimeCompassSettings;
import org.compass.core.engine.SearchEngine;
import org.compass.core.engine.SearchEngineAnalyzerHelper;
import org.compass.core.engine.SearchEngineQueryBuilder;
import org.compass.core.engine.SearchEngineQueryFilterBuilder;
import org.compass.core.events.FilterOperation;
import org.compass.core.impl.DefaultCompassAnalyzerHelper;
import org.compass.core.impl.DefaultCompassQueryBuilder;
import org.compass.core.impl.DefaultCompassQueryFilterBuilder;
import org.compass.core.impl.DefaultCompassTermFreqsBuilder;
import org.compass.core.mapping.CascadeMapping;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.marshall.DefaultMarshallingStrategy;
import org.compass.core.marshall.MarshallingContext;
import org.compass.core.marshall.MarshallingException;
import org.compass.core.marshall.MarshallingStrategy;
import org.compass.core.metadata.CompassMetaData;
import org.compass.core.spi.InternalCompass;
import org.compass.core.spi.InternalCompassSession;
import org.compass.core.spi.InternalResource;
import org.compass.core.spi.ResourceKey;
import org.compass.core.transaction.LocalTransactionFactory;
import org.compass.core.transaction.TransactionFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCompassSession
implements InternalCompassSession {
    private InternalCompass compass;
    private CompassMapping mapping;
    private CompassMetaData compassMetaData;
    private SearchEngine searchEngine;
    private TransactionFactory transactionFactory;
    private LocalTransactionFactory localTransactionFactory;
    private MarshallingStrategy marshallingStrategy;
    private FirstLevelCache firstLevelCache;
    private boolean closed = false;
    private RuntimeCompassSettings runtimeSettings;
    private CascadingManager cascadingManager;

    public DefaultCompassSession(RuntimeCompassSettings runtimeSettings, InternalCompass compass, SearchEngine searchEngine, FirstLevelCache firstLevelCache) {
        this.compass = compass;
        this.mapping = compass.getMapping();
        this.compassMetaData = compass.getMetaData();
        this.transactionFactory = compass.getTransactionFactory();
        this.localTransactionFactory = compass.getLocalTransactionFactory();
        this.runtimeSettings = runtimeSettings;
        this.searchEngine = searchEngine;
        this.firstLevelCache = firstLevelCache;
        this.marshallingStrategy = new DefaultMarshallingStrategy(this.mapping, searchEngine, compass.getConverterLookup(), this);
        this.cascadingManager = new CascadingManager(this);
        this.transactionFactory.tryJoinExistingTransaction(this);
    }

    @Override
    public ResourceFactory resourceFactory() {
        return this.compass.getResourceFactory();
    }

    @Override
    public CompassSettings getSettings() {
        return this.runtimeSettings;
    }

    @Override
    public CompassQueryBuilder queryBuilder() throws CompassException {
        this.checkClosed();
        SearchEngineQueryBuilder searchEngineQueryBuilder = this.searchEngine.queryBuilder();
        return new DefaultCompassQueryBuilder(searchEngineQueryBuilder, this);
    }

    @Override
    public CompassQueryFilterBuilder queryFilterBuilder() throws CompassException {
        this.checkClosed();
        SearchEngineQueryFilterBuilder searchEngineQueryFilterBuilder = this.searchEngine.queryFilterBuilder();
        return new DefaultCompassQueryFilterBuilder(searchEngineQueryFilterBuilder, this);
    }

    @Override
    public CompassTermFreqsBuilder termFreqsBuilder(String ... names) throws CompassException {
        this.checkClosed();
        return new DefaultCompassTermFreqsBuilder(this, names);
    }

    @Override
    public CompassAnalyzerHelper analyzerHelper() throws CompassException {
        this.checkClosed();
        SearchEngineAnalyzerHelper analyzerHelper = this.searchEngine.analyzerHelper();
        return new DefaultCompassAnalyzerHelper(analyzerHelper, this);
    }

    @Override
    public CompassTransaction beginTransaction() throws CompassException {
        this.checkClosed();
        return this.transactionFactory.beginTransaction(this, null);
    }

    @Override
    public CompassTransaction beginTransaction(CompassTransaction.TransactionIsolation transactionIsolation) throws CompassException {
        this.checkClosed();
        if (transactionIsolation == CompassTransaction.TransactionIsolation.BATCH_INSERT) {
            this.firstLevelCache = new NullFirstLevelCache();
        }
        return this.transactionFactory.beginTransaction(this, transactionIsolation);
    }

    @Override
    public CompassTransaction beginLocalTransaction() throws CompassException {
        this.checkClosed();
        return this.localTransactionFactory.beginTransaction(this, null);
    }

    @Override
    public void flush() throws CompassException {
        this.checkClosed();
        this.searchEngine.flush();
    }

    @Override
    public Resource getResource(Class clazz, Object ... ids) throws CompassException {
        return this.getResource(clazz, (Object)ids);
    }

    @Override
    public Resource getResource(Class clazz, Object id) throws CompassException {
        this.checkClosed();
        Resource idResource = this.marshallingStrategy.marshallIds(clazz, id);
        return this.getResourceByIdResource(idResource);
    }

    @Override
    public Resource getResource(String alias, Object ... ids) throws CompassException {
        return this.getResource(alias, (Object)ids);
    }

    @Override
    public Resource getResource(String alias, Object id) throws CompassException {
        this.checkClosed();
        Resource idResource = this.marshallingStrategy.marshallIds(alias, id);
        return this.getResourceByIdResource(idResource);
    }

    @Override
    public Resource getResourceByIdResource(Resource idResource) {
        this.checkClosed();
        ResourceKey key = ((InternalResource)idResource).resourceKey();
        Resource cachedValue = this.firstLevelCache.getResource(key);
        if (cachedValue != null) {
            return cachedValue;
        }
        Resource value = this.searchEngine.get(idResource);
        this.firstLevelCache.setResource(key, value);
        return value;
    }

    @Override
    public <T> T get(Class<T> clazz, Object ... ids) throws CompassException {
        return this.get(clazz, (Object)ids);
    }

    @Override
    public <T> T get(Class<T> clazz, Object id) throws CompassException {
        this.checkClosed();
        Resource resource = this.getResource((Class)clazz, id);
        if (resource == null) {
            return null;
        }
        return (T)this.getByResource(resource);
    }

    @Override
    public Object get(String alias, Object ... ids) throws CompassException {
        return this.get(alias, (Object)ids);
    }

    @Override
    public Object get(String alias, Object id) throws CompassException {
        this.checkClosed();
        Resource resource = this.getResource(alias, id);
        if (resource == null) {
            return null;
        }
        return this.getByResource(resource);
    }

    @Override
    public Object get(String alias, Object id, MarshallingContext context) throws CompassException {
        this.checkClosed();
        Resource resource = this.getResource(alias, id);
        if (resource == null) {
            return null;
        }
        return this.getByResource(resource, context);
    }

    @Override
    public Object getByResource(Resource resource) {
        this.checkClosed();
        return this.getByResource(resource, null);
    }

    public Object getByResource(Resource resource, MarshallingContext context) {
        this.checkClosed();
        ResourceKey key = ((InternalResource)resource).resourceKey();
        Object cachedValue = this.firstLevelCache.get(key);
        if (cachedValue != null) {
            return cachedValue;
        }
        Object value = context == null ? this.marshallingStrategy.unmarshall(resource) : this.marshallingStrategy.unmarshall(resource, context);
        this.firstLevelCache.set(key, value);
        return value;
    }

    @Override
    public Resource loadResource(Class clazz, Object ... ids) throws CompassException {
        return this.loadResource(clazz, (Object)ids);
    }

    @Override
    public Resource loadResource(Class clazz, Object id) throws CompassException {
        this.checkClosed();
        Resource idResource = this.marshallingStrategy.marshallIds(clazz, id);
        return this.loadResourceByIdResource(idResource);
    }

    @Override
    public Resource loadResource(String alias, Object ... ids) throws CompassException {
        return this.loadResource(alias, (Object)ids);
    }

    @Override
    public Resource loadResource(String alias, Object id) throws CompassException {
        this.checkClosed();
        Resource idResource = this.marshallingStrategy.marshallIds(alias, id);
        return this.loadResourceByIdResource(idResource);
    }

    public Resource loadResourceByIdResource(Resource idResource) {
        this.checkClosed();
        ResourceKey key = ((InternalResource)idResource).resourceKey();
        Resource cachedValue = this.firstLevelCache.getResource(key);
        if (cachedValue != null) {
            return cachedValue;
        }
        Resource value = this.searchEngine.load(idResource);
        this.firstLevelCache.setResource(key, value);
        return value;
    }

    @Override
    public <T> T load(Class<T> clazz, Object ... ids) throws CompassException {
        return this.load(clazz, (Object)ids);
    }

    @Override
    public <T> T load(Class<T> clazz, Object id) throws CompassException {
        this.checkClosed();
        Resource resource = this.loadResource((Class)clazz, id);
        return (T)this.getByResource(resource);
    }

    @Override
    public Object load(String alias, Object ... ids) throws CompassException {
        return this.load(alias, (Object)ids);
    }

    @Override
    public Object load(String alias, Object id) throws CompassException {
        this.checkClosed();
        Resource resource = this.loadResource(alias, id);
        return this.getByResource(resource);
    }

    @Override
    public CompassHits find(String query) throws CompassException {
        this.checkClosed();
        return this.queryBuilder().queryString(query).toQuery().hits();
    }

    @Override
    public void create(String alias, Object object) throws CompassException {
        this.checkClosed();
        if (this.compass.getEventManager().onPreCreate(alias, object) == FilterOperation.YES) {
            return;
        }
        Resource resource = this.marshallingStrategy.marshall(alias, object);
        if (resource != null) {
            if (this.compass.getEventManager().onPreCreate(resource) == FilterOperation.YES) {
                return;
            }
            this.searchEngine.create(resource);
            ResourceKey key = ((InternalResource)resource).resourceKey();
            this.firstLevelCache.set(key, object);
        }
        boolean performedCascading = this.cascadingManager.cascade(alias, object, CascadeMapping.Cascade.CREATE);
        if (resource == null && !performedCascading) {
            throw new MarshallingException("Alias [" + alias + "] has no root mappings and no cascading defined, no operation was perfomed");
        }
        if (resource != null) {
            this.compass.getEventManager().onPostCreate(resource);
        }
        this.compass.getEventManager().onPostCreate(alias, object);
    }

    @Override
    public void create(Object object) throws CompassException {
        boolean performedCascading;
        this.checkClosed();
        if (this.compass.getEventManager().onPreCreate(null, object) == FilterOperation.YES) {
            return;
        }
        Resource resource = this.marshallingStrategy.marshall(object);
        if (resource != null) {
            if (this.compass.getEventManager().onPreCreate(resource) == FilterOperation.YES) {
                return;
            }
            this.searchEngine.create(resource);
            ResourceKey key = ((InternalResource)resource).resourceKey();
            this.firstLevelCache.set(key, object);
            performedCascading = this.cascadingManager.cascade(key.getAlias(), object, CascadeMapping.Cascade.CREATE);
        } else {
            performedCascading = this.cascadingManager.cascade(object, CascadeMapping.Cascade.CREATE);
        }
        if (resource == null && !performedCascading) {
            throw new MarshallingException("Object [" + object.getClass().getName() + "] has no root mappings and no cascading defined, no operation was perfomed");
        }
        if (resource != null) {
            this.compass.getEventManager().onPostCreate(resource);
            this.compass.getEventManager().onPostCreate(resource.getAlias(), object);
        } else {
            this.compass.getEventManager().onPostCreate(null, object);
        }
    }

    @Override
    public void save(String alias, Object object) throws CompassException {
        this.checkClosed();
        if (this.compass.getEventManager().onPreSave(alias, object) == FilterOperation.YES) {
            return;
        }
        Resource resource = this.marshallingStrategy.marshall(alias, object);
        if (resource != null) {
            if (this.compass.getEventManager().onPreSave(resource) == FilterOperation.YES) {
                return;
            }
            this.searchEngine.save(resource);
            ResourceKey key = ((InternalResource)resource).resourceKey();
            this.firstLevelCache.set(key, object);
        }
        boolean performedCascading = this.cascadingManager.cascade(alias, object, CascadeMapping.Cascade.SAVE);
        if (resource == null && !performedCascading) {
            throw new MarshallingException("Alias [" + alias + "] has no root mappings and no cascading defined, no operation was perfomed");
        }
        if (resource != null) {
            this.compass.getEventManager().onPostSave(resource);
        }
        this.compass.getEventManager().onPostSave(alias, object);
    }

    @Override
    public void save(Object object) throws CompassException {
        boolean performedCascading;
        this.checkClosed();
        if (this.compass.getEventManager().onPreSave(null, object) == FilterOperation.YES) {
            return;
        }
        Resource resource = this.marshallingStrategy.marshall(object);
        if (resource != null) {
            if (this.compass.getEventManager().onPreSave(resource) == FilterOperation.YES) {
                return;
            }
            this.searchEngine.save(resource);
            ResourceKey key = ((InternalResource)resource).resourceKey();
            this.firstLevelCache.set(key, object);
            performedCascading = this.cascadingManager.cascade(key.getAlias(), object, CascadeMapping.Cascade.SAVE);
        } else {
            performedCascading = this.cascadingManager.cascade(object, CascadeMapping.Cascade.SAVE);
        }
        if (resource == null && !performedCascading) {
            throw new MarshallingException("Object [" + object.getClass().getName() + "] has no root mappings and no cascading defined, no operation was perfomed");
        }
        if (resource != null) {
            this.compass.getEventManager().onPostSave(resource);
            this.compass.getEventManager().onPostSave(resource.getAlias(), object);
        } else {
            this.compass.getEventManager().onPostSave(null, object);
        }
    }

    @Override
    public void delete(String alias, Object ... ids) throws CompassException {
        this.delete(alias, (Object)ids);
    }

    @Override
    public void delete(String alias, Object obj) throws CompassException {
        this.checkClosed();
        if (this.compass.getEventManager().onPreDelete(alias, obj) == FilterOperation.YES) {
            return;
        }
        Resource idResource = this.marshallingStrategy.marshallIds(alias, obj);
        if (idResource != null) {
            if (this.compass.getEventManager().onPreDelete(idResource) == FilterOperation.YES) {
                return;
            }
            this.delete(idResource);
        }
        boolean performedCascading = this.cascadingManager.cascade(alias, obj, CascadeMapping.Cascade.DELETE);
        if (idResource == null && !performedCascading) {
            throw new MarshallingException("Alias [" + alias + "] has no root mappings and no cascading defined, no operation was perfomed");
        }
        if (idResource != null) {
            this.compass.getEventManager().onPostDelete(idResource);
        }
        this.compass.getEventManager().onPostDelete(alias, obj);
    }

    @Override
    public void delete(Class clazz, Object ... ids) throws CompassException {
        this.delete(clazz, (Object)ids);
    }

    @Override
    public void delete(Class clazz, Object obj) throws CompassException {
        boolean performedCascading;
        this.checkClosed();
        if (this.compass.getEventManager().onPreDelete(clazz, obj) == FilterOperation.YES) {
            return;
        }
        Resource idResource = this.marshallingStrategy.marshallIds(clazz, obj);
        if (idResource != null) {
            if (this.compass.getEventManager().onPreDelete(idResource) == FilterOperation.YES) {
                return;
            }
            this.delete(idResource);
            performedCascading = this.cascadingManager.cascade(idResource.getAlias(), obj, CascadeMapping.Cascade.DELETE);
        } else {
            performedCascading = this.cascadingManager.cascade(clazz, obj, CascadeMapping.Cascade.DELETE);
        }
        if (idResource == null && !performedCascading) {
            throw new MarshallingException("Object [" + clazz + "] has no root mappings and no cascading defined, no operation was perfomed");
        }
        if (idResource != null) {
            this.compass.getEventManager().onPostDelete(idResource);
            this.compass.getEventManager().onPostDelete(idResource.getAlias(), obj);
        } else {
            this.compass.getEventManager().onPostDelete(clazz, obj);
        }
    }

    @Override
    public void delete(Object obj) throws CompassException {
        boolean performedCascading;
        this.checkClosed();
        if (this.compass.getEventManager().onPreDelete((String)null, obj) == FilterOperation.YES) {
            return;
        }
        Resource idResource = this.marshallingStrategy.marshallIds(obj);
        if (idResource != null) {
            if (this.compass.getEventManager().onPreDelete(idResource) == FilterOperation.YES) {
                return;
            }
            this.delete(idResource);
            performedCascading = this.cascadingManager.cascade(idResource.getAlias(), obj, CascadeMapping.Cascade.DELETE);
        } else {
            performedCascading = this.cascadingManager.cascade(obj, CascadeMapping.Cascade.DELETE);
        }
        if (idResource == null && !performedCascading) {
            throw new MarshallingException("Object [" + obj.getClass().getName() + "] has no root mappings and no cascading defined, no operation was perfomed");
        }
        if (idResource != null) {
            this.compass.getEventManager().onPostDelete(idResource);
            this.compass.getEventManager().onPostDelete(idResource.getAlias(), obj);
        } else {
            this.compass.getEventManager().onPostDelete((String)null, obj);
        }
    }

    @Override
    public void delete(Resource resource) throws CompassException {
        this.checkClosed();
        this.firstLevelCache.evict(((InternalResource)resource).resourceKey());
        if (this.compass.getEventManager().onPreDelete(resource) == FilterOperation.YES) {
            return;
        }
        this.searchEngine.delete(resource);
        this.compass.getEventManager().onPostDelete(resource);
    }

    @Override
    public void delete(CompassQuery query) throws CompassException {
        this.checkClosed();
        CompassHits hits = query.hits();
        for (int i = 0; i < hits.length(); ++i) {
            this.delete(hits.resource(i));
        }
    }

    @Override
    public void evict(Object obj) {
        this.checkClosed();
        Resource idResource = this.marshallingStrategy.marshallIds(obj.getClass(), obj);
        ResourceKey key = ((InternalResource)idResource).resourceKey();
        this.firstLevelCache.evict(key);
    }

    @Override
    public void evict(String alias, Object id) {
        this.checkClosed();
        Resource idResource = this.marshallingStrategy.marshallIds(alias, id);
        ResourceKey key = ((InternalResource)idResource).resourceKey();
        this.firstLevelCache.evict(key);
    }

    @Override
    public void evict(Resource resource) {
        this.checkClosed();
        ResourceKey key = ((InternalResource)resource).resourceKey();
        this.firstLevelCache.evict(key);
    }

    @Override
    public void evictAll() {
        this.checkClosed();
        this.firstLevelCache.evictAll();
    }

    @Override
    public void close() throws CompassException {
        if (this.closed) {
            return;
        }
        CompassSession transactionBoundSession = this.transactionFactory.getTransactionBoundSession();
        if (transactionBoundSession == null || transactionBoundSession != this) {
            this.closed = true;
            this.firstLevelCache.evictAll();
            this.searchEngine.close();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public InternalCompass getCompass() {
        return this.compass;
    }

    @Override
    public SearchEngine getSearchEngine() {
        return this.searchEngine;
    }

    @Override
    public MarshallingStrategy getMarshallingStrategy() {
        return this.marshallingStrategy;
    }

    @Override
    public FirstLevelCache getFirstLevelCache() {
        return this.firstLevelCache;
    }

    @Override
    public CompassMapping getMapping() {
        return this.mapping;
    }

    @Override
    public CompassMetaData getMetaData() {
        return this.compassMetaData;
    }

    private void checkClosed() throws IllegalStateException {
        if (this.closed) {
            throw new IllegalStateException("CompassSession already closed");
        }
    }
}

