/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.jdbc.index;

import java.io.IOException;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import org.apache.lucene.store.jdbc.JdbcDirectory;
import org.apache.lucene.store.jdbc.JdbcFileEntrySettings;
import org.apache.lucene.store.jdbc.JdbcStoreException;
import org.apache.lucene.store.jdbc.datasource.DataSourceUtils;
import org.apache.lucene.store.jdbc.index.JdbcBufferedIndexInput;
import org.apache.lucene.store.jdbc.support.JdbcTable;

public class FetchPerTransactionJdbcIndexInput
extends JdbcBufferedIndexInput {
    private static final Object blobHolderLock = new Object();
    private static final ThreadLocal blobHolder = new ThreadLocal();
    private String name;
    private long totalLength = -1L;
    private long position = 1L;
    private JdbcDirectory jdbcDirectory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseBlobs(Connection connection) {
        Object object = blobHolderLock;
        synchronized (object) {
            Connection targetConnection = DataSourceUtils.getTargetConnection(connection);
            HashMap holdersPerConn = (HashMap)blobHolder.get();
            if (holdersPerConn == null) {
                return;
            }
            holdersPerConn.remove(targetConnection);
            holdersPerConn.remove(new Integer(System.identityHashCode(targetConnection)));
            if (holdersPerConn.isEmpty()) {
                blobHolder.set(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseBlobs(Connection connection, JdbcTable table, String name) {
        Object object = blobHolderLock;
        synchronized (object) {
            Connection targetConnection = DataSourceUtils.getTargetConnection(connection);
            HashMap holdersPerConn = (HashMap)blobHolder.get();
            if (holdersPerConn == null) {
                return;
            }
            HashMap holdersPerName = (HashMap)holdersPerConn.get(targetConnection);
            if (holdersPerName != null) {
                holdersPerName.remove(name);
            }
            if ((holdersPerName = (HashMap)holdersPerConn.get(new Integer(System.identityHashCode(targetConnection)))) != null) {
                holdersPerName.remove(table.getName() + name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Blob getBoundBlob(Connection connection, JdbcTable table, String name) {
        Object object = blobHolderLock;
        synchronized (object) {
            Connection targetConnection = DataSourceUtils.getTargetConnection(connection);
            HashMap holdersPerConn = (HashMap)blobHolder.get();
            if (holdersPerConn == null) {
                return null;
            }
            HashMap holdersPerName = (HashMap)holdersPerConn.get(targetConnection);
            if (holdersPerName == null && (holdersPerName = (HashMap)holdersPerConn.get(new Integer(System.identityHashCode(targetConnection)))) == null) {
                return null;
            }
            Blob blob = (Blob)holdersPerName.get(table.getName() + name);
            if (blob != null) {
                return blob;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void bindBlob(Connection connection, JdbcTable table, String name, Blob blob) {
        Object object = blobHolderLock;
        synchronized (object) {
            HashMap<String, Blob> holdersPerName;
            Connection targetConnection = DataSourceUtils.getTargetConnection(connection);
            HashMap<Object, HashMap<String, Blob>> holdersPerCon = (HashMap<Object, HashMap<String, Blob>>)blobHolder.get();
            if (holdersPerCon == null) {
                holdersPerCon = new HashMap<Object, HashMap<String, Blob>>();
                blobHolder.set(holdersPerCon);
            }
            if ((holdersPerName = (HashMap<String, Blob>)holdersPerCon.get(targetConnection)) == null && (holdersPerName = (HashMap)holdersPerCon.get(new Integer(System.identityHashCode(targetConnection)))) == null) {
                holdersPerName = new HashMap<String, Blob>();
                holdersPerCon.put(targetConnection, holdersPerName);
                holdersPerCon.put(new Integer(System.identityHashCode(targetConnection)), holdersPerName);
            }
            holdersPerName.put(table.getName() + name, blob);
        }
    }

    public void configure(String name, JdbcDirectory jdbcDirectory, JdbcFileEntrySettings settings) throws IOException {
        super.configure(name, jdbcDirectory, settings);
        this.jdbcDirectory = jdbcDirectory;
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refill() throws IOException {
        Connection conn = DataSourceUtils.getConnection(this.jdbcDirectory.getDataSource());
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            long start;
            long end;
            Blob blob = FetchPerTransactionJdbcIndexInput.getBoundBlob(conn, this.jdbcDirectory.getTable(), this.name);
            if (blob == null) {
                ps = conn.prepareStatement(this.jdbcDirectory.getTable().sqlSelectSizeValueByName());
                ps.setFetchSize(1);
                ps.setString(1, this.name);
                rs = ps.executeQuery();
                if (!rs.next()) {
                    throw new JdbcStoreException("No entry for [" + this.name + "] table " + this.jdbcDirectory.getTable());
                }
                FetchPerTransactionJdbcIndexInput fetchPerTransactionJdbcIndexInput = this;
                synchronized (fetchPerTransactionJdbcIndexInput) {
                    if (this.totalLength == -1L) {
                        this.totalLength = rs.getLong(3);
                    }
                }
                blob = rs.getBlob(2);
                FetchPerTransactionJdbcIndexInput.bindBlob(conn, this.jdbcDirectory.getTable(), this.name, blob);
            }
            if ((end = (start = this.bufferStart + (long)this.bufferPosition) + (long)this.bufferSize) > this.length()) {
                end = this.length();
            }
            this.bufferLength = (int)(end - start);
            if (this.bufferLength <= 0) {
                throw new IOException("read past EOF");
            }
            if (this.buffer == null) {
                this.buffer = new byte[this.bufferSize];
                this.seekInternal(this.bufferStart);
            }
            this.readInternal(blob, this.buffer, 0, this.bufferLength);
            this.bufferStart = start;
            this.bufferPosition = 0;
        }
        catch (Exception e) {
            try {
                throw new JdbcStoreException("Failed to read transactional blob [" + this.name + "]", e);
            }
            catch (Throwable throwable) {
                DataSourceUtils.closeResultSet(rs);
                DataSourceUtils.closeStatement(ps);
                DataSourceUtils.releaseConnection(conn);
                throw throwable;
            }
        }
        DataSourceUtils.closeResultSet(rs);
        DataSourceUtils.closeStatement(ps);
        DataSourceUtils.releaseConnection(conn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void readInternal(byte[] b, int offset, int length) throws IOException {
        Connection conn = DataSourceUtils.getConnection(this.jdbcDirectory.getDataSource());
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            Blob blob = FetchPerTransactionJdbcIndexInput.getBoundBlob(conn, this.jdbcDirectory.getTable(), this.name);
            if (blob == null) {
                ps = conn.prepareStatement(this.jdbcDirectory.getTable().sqlSelectSizeValueByName());
                ps.setFetchSize(1);
                ps.setString(1, this.name);
                rs = ps.executeQuery();
                if (!rs.next()) {
                    throw new JdbcStoreException("No entry for [" + this.name + "] table " + this.jdbcDirectory.getTable());
                }
                blob = rs.getBlob(2);
                FetchPerTransactionJdbcIndexInput.bindBlob(conn, this.jdbcDirectory.getTable(), this.name, blob);
                FetchPerTransactionJdbcIndexInput fetchPerTransactionJdbcIndexInput = this;
                synchronized (fetchPerTransactionJdbcIndexInput) {
                    if (this.totalLength == -1L) {
                        this.totalLength = rs.getLong(3);
                    }
                }
            }
            this.readInternal(blob, b, offset, length);
        }
        catch (Exception e) {
            try {
                throw new JdbcStoreException("Failed to read transactional blob [" + this.name + "]", e);
            }
            catch (Throwable throwable) {
                DataSourceUtils.closeResultSet(rs);
                DataSourceUtils.closeStatement(ps);
                DataSourceUtils.releaseConnection(conn);
                throw throwable;
            }
        }
        DataSourceUtils.closeResultSet(rs);
        DataSourceUtils.closeStatement(ps);
        DataSourceUtils.releaseConnection(conn);
    }

    private synchronized void readInternal(Blob blob, byte[] b, int offset, int length) throws Exception {
        byte[] bytesRead;
        long curPos = this.getFilePointer();
        if (curPos + 1L != this.position) {
            this.position = curPos + 1L;
        }
        if (this.position + (long)length > this.length() + 1L) {
            System.err.println("BAD");
        }
        if ((bytesRead = blob.getBytes(this.position, length)).length != length) {
            throw new IOException("read past EOF");
        }
        System.arraycopy(bytesRead, 0, b, offset, length);
        this.position += (long)bytesRead.length;
    }

    protected void seekInternal(long pos) throws IOException {
        this.position = pos + 1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Connection conn = DataSourceUtils.getConnection(this.jdbcDirectory.getDataSource());
        try {
            FetchPerTransactionJdbcIndexInput.releaseBlobs(conn, this.jdbcDirectory.getTable(), this.name);
        }
        finally {
            DataSourceUtils.releaseConnection(conn);
        }
    }

    public synchronized long length() {
        if (this.totalLength == -1L) {
            try {
                this.totalLength = this.jdbcDirectory.fileLength(this.name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return this.totalLength;
    }
}

