/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi;

import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.ObjectNamespace;
import java.io.IOException;

public final class DefaultObjectNamespace
implements ObjectNamespace {
    private String service;
    private Object objectId;

    public DefaultObjectNamespace() {
    }

    public DefaultObjectNamespace(String serviceName, Object objectId) {
        this.service = serviceName;
        this.objectId = objectId;
    }

    @Override
    public String getServiceName() {
        return this.service;
    }

    @Override
    public Object getObjectId() {
        return this.objectId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultObjectNamespace that = (DefaultObjectNamespace)o;
        if (this.objectId != null ? !this.objectId.equals(that.objectId) : that.objectId != null) {
            return false;
        }
        return !(this.service != null ? !this.service.equals(that.service) : that.service != null);
    }

    public int hashCode() {
        int result = this.service != null ? this.service.hashCode() : 0;
        result = 31 * result + (this.objectId != null ? this.objectId.hashCode() : 0);
        return result;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeUTF(this.service);
        out.writeObject(this.objectId);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.service = in.readUTF();
        this.objectId = in.readObject();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("DefaultObjectNamespace");
        sb.append("{service='").append(this.service).append('\'');
        sb.append(", objectId=").append(this.objectId);
        sb.append('}');
        return sb.toString();
    }
}

