/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.operation;

import com.hazelcast.map.MapDataSerializerHook;
import com.hazelcast.map.operation.KeyBasedMapOperation;
import com.hazelcast.map.record.DataRecord;
import com.hazelcast.map.record.ObjectRecord;
import com.hazelcast.map.record.Record;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.BackupOperation;

public final class PutBackupOperation
extends KeyBasedMapOperation
implements BackupOperation,
IdentifiedDataSerializable {
    private boolean unlockKey = false;

    public PutBackupOperation(String name, Data dataKey, Data dataValue, long ttl) {
        super(name, dataKey, dataValue, ttl);
    }

    public PutBackupOperation(String name, Data dataKey, Data dataValue, long ttl, boolean unlockKey) {
        super(name, dataKey, dataValue, ttl);
        this.unlockKey = unlockKey;
    }

    public PutBackupOperation() {
    }

    @Override
    public void run() {
        Record record = this.recordStore.getRecords().get(this.dataKey);
        if (record == null) {
            record = this.mapService.createRecord(this.name, this.dataKey, this.dataValue, this.ttl, false);
            this.recordStore.getRecords().put(this.dataKey, record);
        } else if (record instanceof DataRecord) {
            ((DataRecord)record).setValue(this.dataValue);
        } else if (record instanceof ObjectRecord) {
            ((ObjectRecord)record).setValue(this.mapService.toObject(this.dataValue));
        }
        if (this.unlockKey) {
            this.recordStore.forceUnlock(this.dataKey);
        }
    }

    @Override
    public Object getResponse() {
        return Boolean.TRUE;
    }

    public String toString() {
        return "PutBackupOperation{" + this.name + "}";
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 3;
    }
}

