/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.domain.mapping;

import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.EventSubscriber;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.domain.mapping.DomainMappingEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.domain.mapping.DomainMappingEventMessageListener;
import org.apache.stratos.messaging.message.receiver.domain.mapping.DomainMappingEventMessageQueue;
import org.apache.stratos.messaging.util.MessagingUtil;

public class DomainMappingEventReceiver {
    private static final Log log = LogFactory.getLog(DomainMappingEventReceiver.class);
    private DomainMappingEventMessageDelegator messageDelegator;
    private DomainMappingEventMessageListener messageListener;
    private EventSubscriber eventSubscriber;
    private ExecutorService executorService;

    public DomainMappingEventReceiver() {
        DomainMappingEventMessageQueue messageQueue = new DomainMappingEventMessageQueue();
        this.messageDelegator = new DomainMappingEventMessageDelegator(messageQueue);
        this.messageListener = new DomainMappingEventMessageListener(messageQueue);
    }

    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    public void execute() {
        block4: {
            try {
                this.eventSubscriber = new EventSubscriber(MessagingUtil.Topics.DOMAIN_MAPPING_TOPIC.getTopicName(), this.messageListener);
                this.executorService.execute(this.eventSubscriber);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Domain mapping event message receiver thread started");
                }
                this.executorService.execute(this.messageDelegator);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Domain mapping event message delegator thread started");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Domain mapping receiver failed", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.eventSubscriber.terminate();
        this.messageDelegator.terminate();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

