/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.application.signup;

import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.EventSubscriber;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.application.signup.ApplicationSignUpEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.application.signup.ApplicationSignUpEventMessageListener;
import org.apache.stratos.messaging.message.receiver.application.signup.ApplicationSignUpEventMessageQueue;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ApplicationSignUpEventReceiver {
    private static final Log log = LogFactory.getLog(ApplicationSignUpEventReceiver.class);
    private ApplicationSignUpEventMessageDelegator messageDelegator;
    private ApplicationSignUpEventMessageListener messageListener;
    private EventSubscriber eventSubscriber;
    private ExecutorService executorService;

    public ApplicationSignUpEventReceiver() {
        ApplicationSignUpEventMessageQueue messageQueue = new ApplicationSignUpEventMessageQueue();
        this.messageDelegator = new ApplicationSignUpEventMessageDelegator(messageQueue);
        this.messageListener = new ApplicationSignUpEventMessageListener(messageQueue);
    }

    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    public void execute() {
        block4: {
            try {
                this.eventSubscriber = new EventSubscriber(MessagingUtil.Topics.APPLICATION_SIGNUP_TOPIC.getTopicName(), this.messageListener);
                this.executorService.execute(this.eventSubscriber);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Application signup event message receiver thread started");
                }
                this.executorService.execute(this.messageDelegator);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Application signup event message delegator thread started");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"Application signup receiver failed", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.eventSubscriber.terminate();
        this.messageDelegator.terminate();
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

