/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.application;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.Message;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.processor.MessageProcessorChain;
import org.apache.stratos.messaging.message.processor.application.ApplicationsMessageProcessorChain;
import org.apache.stratos.messaging.message.receiver.application.ApplicationManager;
import org.apache.stratos.messaging.message.receiver.application.ApplicationsEventMessageQueue;

public class ApplicationsEventMessageDelegator
implements Runnable {
    private static final Log log = LogFactory.getLog(ApplicationsEventMessageDelegator.class);
    private ApplicationsEventMessageQueue messageQueue;
    private MessageProcessorChain processorChain;
    private boolean terminated;

    public ApplicationsEventMessageDelegator(ApplicationsEventMessageQueue messageQueue) {
        this.messageQueue = messageQueue;
        this.processorChain = new ApplicationsMessageProcessorChain();
    }

    public void addEventListener(EventListener eventListener) {
        this.processorChain.addEventListener(eventListener);
    }

    @Override
    public void run() {
        block9: {
            try {
                if (log.isInfoEnabled()) {
                    log.info((Object)"Application status event message delegator started");
                }
                while (!this.terminated) {
                    try {
                        Message message = (Message)this.messageQueue.take();
                        String type = message.getEventClassName();
                        if (type.startsWith("org.apache.stratos.messaging.event.application.signup")) continue;
                        String json = message.getText();
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Application status event message received from queue: %s", type));
                        }
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Delegating application status event message: %s", type));
                        }
                        this.processorChain.process(type, json, ApplicationManager.getApplications());
                    }
                    catch (InterruptedException ignore) {
                        log.info((Object)"Shutting down application event message delegator...");
                        this.terminate();
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to retrieve application status event message", (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"Application status event message delegator failed", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.terminated = true;
    }

    private EventMessage jsonToEventMessage(String json) {
        EventMessage event = new EventMessage();
        String[] MessageParts = json.split(":", 3);
        String eventType = MessageParts[0].trim();
        eventType = eventType.substring(eventType.indexOf("\"") + 1, eventType.lastIndexOf("\""));
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Extracted [event type] %s", eventType));
        }
        event.setEventName(eventType);
        String messageTag = MessageParts[1];
        messageTag = messageTag.substring(messageTag.indexOf("\"") + 1, messageTag.lastIndexOf("\""));
        if ("message".equals(messageTag)) {
            String message = MessageParts[2].trim();
            message = message.substring(0, message.lastIndexOf("}")).trim();
            if ((message = message.substring(0, message.lastIndexOf("}")).trim()).indexOf(123) == 0 && message.indexOf(125) == message.length() - 1) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("[Extracted message] %s ", message));
                }
                event.setMessage(message);
                return event;
            }
        }
        return null;
    }

    private class EventMessage {
        private String eventName;
        private String message;

        private EventMessage() {
        }

        private String getEventName() {
            return this.eventName;
        }

        private void setEventName(String eventName) {
            this.eventName = eventName;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

