/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.processor.application;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.domain.application.Applications;
import org.apache.stratos.messaging.domain.instance.ApplicationInstance;
import org.apache.stratos.messaging.event.application.ApplicationInstanceCreatedEvent;
import org.apache.stratos.messaging.message.processor.MessageProcessor;
import org.apache.stratos.messaging.message.processor.application.updater.ApplicationsUpdater;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ApplicationInstanceCreatedMessageProcessor
extends MessageProcessor {
    private static final Log log = LogFactory.getLog(ApplicationInstanceCreatedMessageProcessor.class);
    private MessageProcessor nextProcessor;

    @Override
    public void setNext(MessageProcessor nextProcessor) {
        this.nextProcessor = nextProcessor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(String type, String message, Object object) {
        Applications applications = (Applications)object;
        if (ApplicationInstanceCreatedEvent.class.getName().equals(type)) {
            if (!applications.isInitialized()) {
                return false;
            }
            ApplicationInstanceCreatedEvent event = (ApplicationInstanceCreatedEvent)MessagingUtil.jsonToObject(message, ApplicationInstanceCreatedEvent.class);
            if (event == null) {
                log.error((Object)"Unable to convert the JSON message to ApplicationInstanceCreatedEvent");
                return false;
            }
            ApplicationsUpdater.acquireWriteLockForApplications();
            try {
                boolean bl = this.doProcess(event, applications);
                return bl;
            }
            finally {
                ApplicationsUpdater.releaseWriteLockForApplications();
            }
        }
        if (this.nextProcessor != null) {
            return this.nextProcessor.process(type, message, applications);
        }
        throw new RuntimeException(String.format("Failed to process message using available message processors: [type] %s [body] %s", type, message));
    }

    private boolean doProcess(ApplicationInstanceCreatedEvent event, Applications applications) {
        if (event.getApplicationInstance() == null || event.getApplicationId() == null) {
            String errorMsg = "Application instance object of ApplicationInstanceCreatedEvent is invalid. [ApplicationId] " + event.getApplicationId() + ", [ApplicationInstance] " + event.getApplicationInstance();
            log.error((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        if (applications == null) {
            String errorMsg = "Error! Applications object is null";
            log.error((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        ApplicationInstance applicationInstance = event.getApplicationInstance();
        if (applicationInstance.getInstanceId() == null || applicationInstance.getInstanceId().isEmpty()) {
            String errorMsg = "App instance id of application instance created event is invalid: [ " + applicationInstance.getInstanceId() + " ]";
            log.error((Object)errorMsg);
            throw new RuntimeException(errorMsg);
        }
        if (null != applications.getApplication(event.getApplicationId()).getInstanceByNetworkPartitionId(applicationInstance.getNetworkPartitionId())) {
            log.warn((Object)("Application instance [AppInstanceId] " + applicationInstance.getInstanceId() + " already exists"));
        } else {
            applications.getApplication(event.getApplicationId()).addInstance(applicationInstance.getInstanceId(), applicationInstance);
        }
        this.notifyEventListeners(event);
        return true;
    }
}

