/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.filter.topology;

import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.message.filter.MessageFilter;
import org.apache.stratos.messaging.message.filter.topology.TopologyServiceFilter;

public class TopologyMemberFilter
extends MessageFilter {
    private static final Log log = LogFactory.getLog(TopologyServiceFilter.class);
    public static final String TOPOLOGY_MEMBER_FILTER_NETWORK_PARTITION_ID = "network-partition-id";
    private static volatile TopologyMemberFilter instance;

    public TopologyMemberFilter() {
        super("stratos.topology.member.filter");
    }

    public static boolean apply(String lbClusterId, String networkPartitionId) {
        boolean excluded = false;
        if (TopologyMemberFilter.getInstance().isActive()) {
            if (StringUtils.isNotBlank((CharSequence)networkPartitionId) && TopologyMemberFilter.getInstance().networkPartitionExcluded(networkPartitionId)) {
                excluded = true;
            }
            if (excluded && log.isInfoEnabled()) {
                log.info((Object)String.format("Member is excluded: [network-partition-id] %s", networkPartitionId));
            }
        }
        return excluded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TopologyMemberFilter getInstance() {
        if (instance != null) return instance;
        Class<TopologyMemberFilter> clazz = TopologyMemberFilter.class;
        synchronized (TopologyMemberFilter.class) {
            if (instance != null) return instance;
            instance = new TopologyMemberFilter();
            if (!log.isDebugEnabled()) return instance;
            log.debug((Object)"Topology member filter instance created");
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private boolean networkPartitionExcluded(String value) {
        return this.excluded(TOPOLOGY_MEMBER_FILTER_NETWORK_PARTITION_ID, value);
    }

    private Collection<String> getIncludedNetworkPartitionIds() {
        return this.getIncludedPropertyValues(TOPOLOGY_MEMBER_FILTER_NETWORK_PARTITION_ID);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("network-partition-id=");
        for (String networkPartitionId : TopologyMemberFilter.getInstance().getIncludedNetworkPartitionIds()) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(networkPartitionId);
        }
        return sb.toString();
    }
}

