/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.domain.topology;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang.StringUtils;
import org.apache.stratos.messaging.adapters.MapAdapter;
import org.apache.stratos.messaging.domain.instance.ClusterInstance;
import org.apache.stratos.messaging.domain.topology.ClusterStatus;
import org.apache.stratos.messaging.domain.topology.KubernetesService;
import org.apache.stratos.messaging.domain.topology.Member;
import org.apache.stratos.messaging.util.MessagingUtil;

@XmlRootElement
public class Cluster
implements Serializable {
    private static final long serialVersionUID = -361960242360176077L;
    private final String serviceName;
    private final String clusterId;
    private final String autoscalePolicyName;
    private final String deploymentPolicyName;
    private List<String> hostNames;
    private String tenantRange;
    private boolean isLbCluster;
    private boolean isKubernetesCluster;
    @XmlJavaTypeAdapter(value=MapAdapter.class)
    private Map<String, Member> memberMap;
    private String appId;
    private String parentId;
    private String loadBalanceAlgorithmName;
    @XmlJavaTypeAdapter(value=MapAdapter.class)
    private Properties properties;
    private Map<String, ClusterInstance> instanceIdToInstanceContextMap;
    private List<String> accessUrls;
    private List<KubernetesService> kubernetesServices;

    public Cluster(Cluster cluster) {
        this.serviceName = cluster.getServiceName();
        this.clusterId = cluster.getClusterId();
        this.deploymentPolicyName = cluster.getDeploymentPolicyName();
        this.autoscalePolicyName = cluster.getAutoscalePolicyName();
        this.appId = cluster.getAppId();
        this.setHostNames(cluster.getHostNames());
        this.memberMap = cluster.getMemberMap();
        this.setInstanceIdToInstanceContextMap(cluster.getInstanceIdToInstanceContextMap());
        this.properties = cluster.getProperties();
        this.loadBalanceAlgorithmName = cluster.getLoadBalanceAlgorithmName();
        this.parentId = cluster.getParentId();
        this.tenantRange = cluster.getTenantRange();
        this.setLbCluster(cluster.isLbCluster());
        this.setKubernetesCluster(cluster.isKubernetesCluster());
        this.accessUrls = cluster.getAccessUrls();
        this.kubernetesServices = cluster.getKubernetesServices();
    }

    public Cluster(String serviceName, String clusterId, String deploymentPolicyName, String autoscalePolicyName, String appId) {
        this.serviceName = serviceName;
        this.clusterId = clusterId;
        this.deploymentPolicyName = deploymentPolicyName;
        this.autoscalePolicyName = autoscalePolicyName;
        this.setHostNames(new ArrayList<String>());
        this.memberMap = new ConcurrentHashMap<String, Member>();
        this.appId = appId;
        this.setInstanceIdToInstanceContextMap(new ConcurrentHashMap<String, ClusterInstance>());
        this.accessUrls = new ArrayList<String>();
        this.kubernetesServices = new ArrayList<KubernetesService>();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public List<String> getHostNames() {
        return this.hostNames;
    }

    public void addHostName(String hostName) {
        this.hostNames.add(hostName);
    }

    public String getTenantRange() {
        return this.tenantRange;
    }

    public void setTenantRange(String tenantRange) {
        MessagingUtil.validateTenantRange(tenantRange);
        this.tenantRange = tenantRange;
    }

    public Collection<Member> getMembers() {
        return this.memberMap.values();
    }

    public boolean hasMembers() {
        return this.memberMap.isEmpty();
    }

    public void addMember(Member member) {
        this.memberMap.put(member.getMemberId(), member);
    }

    public void removeMember(Member member) {
        this.memberMap.remove(member.getMemberId());
    }

    public Member getMember(String memberId) {
        return this.memberMap.get(memberId);
    }

    public boolean memberExists(String memberId) {
        return this.memberMap.containsKey(memberId);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String getAutoscalePolicyName() {
        return this.autoscalePolicyName;
    }

    public String getDeploymentPolicyName() {
        return this.deploymentPolicyName;
    }

    public String getLoadBalanceAlgorithmName() {
        return this.loadBalanceAlgorithmName;
    }

    public void setLoadBalanceAlgorithmName(String loadBalanceAlgorithmName) {
        this.loadBalanceAlgorithmName = loadBalanceAlgorithmName;
    }

    public boolean isLbCluster() {
        return this.isLbCluster;
    }

    public void setLbCluster(boolean isLbCluster) {
        this.isLbCluster = isLbCluster;
    }

    public boolean isKubernetesCluster() {
        return this.isKubernetesCluster;
    }

    public void setKubernetesCluster(boolean isKubernetesCluster) {
        this.isKubernetesCluster = isKubernetesCluster;
    }

    public boolean tenantIdInRange(int tenantId) {
        if (StringUtils.isEmpty((String)this.getTenantRange())) {
            return false;
        }
        if ("*".equals(this.getTenantRange())) {
            return true;
        }
        String[] array = this.getTenantRange().split("-");
        int tenantStart = Integer.parseInt(array[0]);
        if (tenantStart <= tenantId) {
            String tenantEndStr = array[1];
            if ("*".equals(tenantEndStr)) {
                return true;
            }
            int tenantEnd = Integer.parseInt(tenantEndStr);
            if (tenantId <= tenantEnd) {
                return true;
            }
        }
        return false;
    }

    public Collection<String> findPartitionIds() {
        HashMap<String, Boolean> partitionIds = new HashMap<String, Boolean>();
        for (Member member : this.getMembers()) {
            if (!StringUtils.isNotEmpty((String)member.getPartitionId()) || partitionIds.containsKey(member.getPartitionId())) continue;
            partitionIds.put(member.getPartitionId(), true);
        }
        return partitionIds.keySet();
    }

    public boolean isStateTransitionValid(ClusterStatus newState, String clusterInstanceId) {
        return this.getInstanceIdToInstanceContextMap().get(clusterInstanceId).isStateTransitionValid(newState);
    }

    public Stack<ClusterStatus> getTransitionedStates(String clusterInstanceId) {
        return this.getInstanceIdToInstanceContextMap().get(clusterInstanceId).getTransitionedStates();
    }

    public ClusterStatus getStatus(String applicationInstanceId) {
        ClusterInstance clusterInstance = this.getInstanceIdToInstanceContextMap().get(applicationInstanceId);
        if (clusterInstance != null) {
            return clusterInstance.getStatus();
        }
        return null;
    }

    public boolean setStatus(ClusterStatus newStatus, String applicationInstanceId) {
        return this.getInstanceIdToInstanceContextMap().get(applicationInstanceId).setStatus(newStatus);
    }

    public void addInstanceContext(String instanceId, ClusterInstance instanceContext) {
        this.getInstanceIdToInstanceContextMap().put(instanceId, instanceContext);
    }

    public void removeInstanceContext(String instanceId) {
        this.instanceIdToInstanceContextMap.remove(instanceId);
    }

    public ClusterInstance getInstanceContexts(String instanceId) {
        if (this.getInstanceIdToInstanceContextMap().isEmpty()) {
            return null;
        }
        if (instanceId == null) {
            return this.getInstanceIdToInstanceContextMap().entrySet().iterator().next().getValue();
        }
        return this.getInstanceIdToInstanceContextMap().get(instanceId);
    }

    public int getInstanceContextCount() {
        return this.getInstanceIdToInstanceContextMap().keySet().size();
    }

    public Map<String, Member> getMemberMap() {
        return this.memberMap;
    }

    public void setMemberMap(Map<String, Member> memberMap) {
        this.memberMap = memberMap;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof Cluster)) {
            return false;
        }
        if (this == other) {
            return true;
        }
        Cluster that = (Cluster)other;
        return this.clusterId.equals(that.clusterId);
    }

    public int hashCode() {
        return this.clusterId.hashCode();
    }

    public String getAppId() {
        return this.appId;
    }

    public void setHostNames(List<String> hostNames) {
        this.hostNames = hostNames;
    }

    public String getParentId() {
        return this.parentId;
    }

    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    public Map<String, ClusterInstance> getInstanceIdToInstanceContextMap() {
        return this.instanceIdToInstanceContextMap;
    }

    public void setInstanceIdToInstanceContextMap(Map<String, ClusterInstance> instanceIdToInstanceContextMap) {
        this.instanceIdToInstanceContextMap = instanceIdToInstanceContextMap;
    }

    public Collection<ClusterInstance> getClusterInstances() {
        return this.instanceIdToInstanceContextMap.values();
    }

    public List<String> getAccessUrls() {
        return this.accessUrls;
    }

    public void setAccessUrls(List<String> accessUrls) {
        this.accessUrls = accessUrls;
    }

    public void addAccessUrl(String accessUrl) {
        if (this.accessUrls == null) {
            this.accessUrls = new ArrayList<String>();
        }
        if (!this.accessUrls.contains(accessUrl)) {
            this.accessUrls.add(accessUrl);
        }
    }

    public List<KubernetesService> getKubernetesServices() {
        return this.kubernetesServices;
    }

    public void setKubernetesServices(List<KubernetesService> kubernetesServices) {
        this.kubernetesServices = kubernetesServices;
        this.setKubernetesCluster(kubernetesServices != null && kubernetesServices.size() > 0);
    }

    public String toString() {
        return String.format("[serviceName=%s, clusterId=%s, autoscalePolicyName=%s, deploymentPolicyName=%s, hostNames=%s, tenantRange=%s, loadBalanceAlgorithmName=%s, appId=%s, parentId=%s, accessUrls=%s, kubernetesServices=%s]", this.serviceName, this.clusterId, this.autoscalePolicyName, this.deploymentPolicyName, this.hostNames, this.tenantRange, this.loadBalanceAlgorithmName, this.appId, this.parentId, this.accessUrls, this.kubernetesServices);
    }
}

