/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.broker.publish;

import com.google.gson.Gson;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.connect.TopicPublisher;
import org.apache.stratos.messaging.broker.connect.TopicPublisherFactory;
import org.apache.stratos.messaging.event.Event;
import org.apache.stratos.messaging.util.MessagingUtil;

public class EventPublisher {
    private static final Log log = LogFactory.getLog(EventPublisher.class);
    private final String topicName;
    private final TopicPublisher topicPublisher;

    EventPublisher(String topicName) {
        this.topicName = topicName;
        String protocol = MessagingUtil.getMessagingProtocol();
        this.topicPublisher = TopicPublisherFactory.createTopicPublisher(protocol, topicName);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Topic publisher created: [protocol] %s [topic] %s", protocol, topicName));
        }
    }

    public void publish(Event event) {
        this.publish(event, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void publish(Object messageObj, boolean retry) {
        Class<EventPublisher> clazz = EventPublisher.class;
        synchronized (EventPublisher.class) {
            Gson gson = new Gson();
            String message = gson.toJson(messageObj);
            this.topicPublisher.connect();
            this.topicPublisher.publish(message, retry);
            this.topicPublisher.disconnect();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }
}

