/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport;

import java.nio.ByteBuffer;
import org.wso2.andes.transport.ProtocolDelegate;
import org.wso2.andes.transport.ProtocolEvent;
import org.wso2.andes.transport.network.NetworkDelegate;
import org.wso2.andes.transport.network.NetworkEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ProtocolHeader
implements NetworkEvent,
ProtocolEvent {
    private static final byte[] AMQP = new byte[]{65, 77, 81, 80};
    private static final byte CLASS = 1;
    private final byte protoClass;
    private final byte instance;
    private final byte major;
    private final byte minor;
    private int channel;

    public ProtocolHeader(byte protoClass, byte instance, byte major, byte minor) {
        this.protoClass = protoClass;
        this.instance = instance;
        this.major = major;
        this.minor = minor;
    }

    public ProtocolHeader(int instance, int major, int minor) {
        this(1, (byte)instance, (byte)major, (byte)minor);
    }

    public byte getInstance() {
        return this.instance;
    }

    public byte getMajor() {
        return this.major;
    }

    public byte getMinor() {
        return this.minor;
    }

    @Override
    public int getChannel() {
        return this.channel;
    }

    @Override
    public void setChannel(int channel) {
        this.channel = channel;
    }

    @Override
    public byte getEncodedTrack() {
        return 0;
    }

    @Override
    public boolean isConnectionControl() {
        return false;
    }

    public ByteBuffer toByteBuffer() {
        ByteBuffer buf = ByteBuffer.allocate(8);
        buf.put(AMQP);
        buf.put(this.protoClass);
        buf.put(this.instance);
        buf.put(this.major);
        buf.put(this.minor);
        buf.flip();
        return buf;
    }

    @Override
    public <C> void delegate(C context, ProtocolDelegate<C> delegate) {
        delegate.init(context, this);
    }

    @Override
    public void delegate(NetworkDelegate delegate) {
        delegate.init(this);
    }

    public String toString() {
        return String.format("AMQP.%d %d-%d", this.instance, this.major, this.minor);
    }
}

