/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.jms.failover;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.jms.BrokerDetails;
import org.wso2.andes.jms.ConnectionURL;
import org.wso2.andes.jms.failover.FailoverMethod;

public class FailoverSingleServer
implements FailoverMethod {
    private static final Logger _logger = LoggerFactory.getLogger(FailoverSingleServer.class);
    public static final int DEFAULT_SERVER_RETRIES = 0;
    private BrokerDetails _brokerDetail;
    protected int _retries;
    protected int _currentRetries = 0;

    public FailoverSingleServer(ConnectionURL connectionDetails) {
        if (connectionDetails.getBrokerCount() <= 0) {
            throw new IllegalArgumentException("BrokerDetails details required for connection.");
        }
        this.setBroker(connectionDetails.getBrokerDetails(0));
    }

    public FailoverSingleServer(BrokerDetails brokerDetail) {
        this.setBroker(brokerDetail);
    }

    public void reset() {
        this._currentRetries = 0;
    }

    public boolean failoverAllowed() {
        return this._currentRetries < this._retries;
    }

    public void attainedConnection() {
        this.reset();
    }

    public BrokerDetails getCurrentBrokerDetails() {
        return this._brokerDetail;
    }

    public BrokerDetails getNextBrokerDetails() {
        String delayStr;
        if (this._currentRetries == this._retries) {
            return null;
        }
        if (this._currentRetries < this._retries) {
            ++this._currentRetries;
        }
        if ((delayStr = this._brokerDetail.getProperty("connectdelay")) != null && this._currentRetries > 0) {
            Long delay = Long.parseLong(delayStr);
            _logger.info("Delay between connect retries:" + delay);
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException ie) {
                return null;
            }
        } else {
            _logger.info("No delay between connect retries, use tcp://host:port?connectdelay='value' to enable.");
        }
        return this._brokerDetail;
    }

    public void setBroker(BrokerDetails broker) {
        if (broker == null) {
            throw new IllegalArgumentException("BrokerDetails details cannot be null");
        }
        this._brokerDetail = broker;
        String retries = broker.getProperty("retries");
        if (retries != null) {
            try {
                this._retries = Integer.parseInt(retries);
            }
            catch (NumberFormatException nfe) {
                this._retries = 0;
            }
        } else {
            this._retries = 0;
        }
        this.reset();
    }

    public void setRetries(int retries) {
        this._retries = retries;
    }

    public String methodName() {
        return "Single Server";
    }

    public String toString() {
        return this.methodName() + ":\n" + "Max Retries:" + this._retries + "\nCurrent Retry:" + this._currentRetries + "\n" + this._brokerDetail + "\n";
    }
}

