/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.core.internal;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;

public abstract class BundleCheckActivator
implements BundleActivator {
    private static final Log log = LogFactory.getLog(BundleCheckActivator.class);
    private String DEPLOY_BEFORE = "DeployBefore";

    public void start(final BundleContext bundleContext) throws Exception {
        String pendingBundleName = null;
        final ArrayList<Bundle> pendingBundles = new ArrayList<Bundle>();
        for (Bundle bundle : bundleContext.getBundles()) {
            pendingBundleName = (String)bundle.getHeaders().get(this.DEPLOY_BEFORE);
            if (pendingBundleName == null || !pendingBundleName.equals(this.getName()) || bundle.getState() == 32) continue;
            pendingBundles.add(bundle);
        }
        if (pendingBundles.isEmpty()) {
            this.startDeploy(bundleContext);
        } else {
            BundleListener bundleListener = new BundleListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void bundleChanged(BundleEvent bundleEvent) {
                    List list = pendingBundles;
                    synchronized (list) {
                        if (bundleEvent.getType() == 2) {
                            pendingBundles.remove(bundleEvent.getBundle());
                            if (pendingBundles.isEmpty()) {
                                bundleContext.removeBundleListener((BundleListener)this);
                                try {
                                    BundleCheckActivator.this.startDeploy(bundleContext);
                                }
                                catch (Exception e) {
                                    log.error((Object)"Can not start the bundle ", (Throwable)e);
                                }
                            }
                        }
                    }
                }
            };
            bundleContext.addBundleListener(bundleListener);
        }
    }

    public abstract void startDeploy(BundleContext var1) throws Exception;

    public abstract String getName();
}

