/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.thrift.internal;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.ComponentContext;
import org.wso2.carbon.databridge.agent.thrift.Agent;
import org.wso2.carbon.databridge.agent.thrift.AgentHolder;

public class AgentDS {
    private static Log log = LogFactory.getLog(AgentDS.class);
    private ServiceRegistration serviceRegistration;
    private boolean agentLoaded = false;

    protected void activate(ComponentContext context) {
        if (!this.agentLoaded) {
            this.serviceRegistration = context.getBundleContext().registerService(Agent.class.getName(), (Object)AgentHolder.getOrCreateAgent(), null);
            log.info((Object)"Successfully deployed Agent Client");
            this.agentLoaded = true;
        }
    }

    protected void deactivate(ComponentContext context) {
        context.getBundleContext().ungetService(this.serviceRegistration.getReference());
        AgentHolder.getAgent().shutdown();
        AgentHolder.setAgentConfiguration(null);
        if (log.isDebugEnabled()) {
            log.debug((Object)"Successfully stopped agent");
        }
    }
}

