/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.databridge.agent.thrift;

import com.google.gson.Gson;
import java.net.MalformedURLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.databridge.agent.thrift.Agent;
import org.wso2.carbon.databridge.agent.thrift.DataPublisher;
import org.wso2.carbon.databridge.agent.thrift.exception.AgentException;
import org.wso2.carbon.databridge.agent.thrift.lb.ReceiverStateObserver;
import org.wso2.carbon.databridge.agent.thrift.util.DataPublisherUtil;
import org.wso2.carbon.databridge.agent.thrift.util.PublishData;
import org.wso2.carbon.databridge.commons.Event;
import org.wso2.carbon.databridge.commons.StreamDefinition;
import org.wso2.carbon.databridge.commons.exception.AuthenticationException;
import org.wso2.carbon.databridge.commons.exception.DifferentStreamDefinitionAlreadyDefinedException;
import org.wso2.carbon.databridge.commons.exception.MalformedStreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.NoStreamDefinitionExistException;
import org.wso2.carbon.databridge.commons.exception.StreamDefinitionException;
import org.wso2.carbon.databridge.commons.exception.TransportException;

public class AsyncDataPublisher {
    private static Log log = LogFactory.getLog(AsyncDataPublisher.class);
    private DataPublisher dataPublisher;
    private ConcurrentHashMap<String, String> streamIdCache = new ConcurrentHashMap();
    private ConcurrentHashMap<String, String> streamDefnCache = new ConcurrentHashMap();
    private LinkedBlockingQueue<PublishData> publishDataQueue;
    private AtomicBoolean isPublisherAlive = new AtomicBoolean(false);
    private AtomicBoolean isConnectorAlive;
    private ReceiverConnectionWorker receiverConnectionWorker;
    private ExecutorService connectorService = Executors.newSingleThreadExecutor();
    private ExecutorService publisherService = Executors.newSingleThreadExecutor();
    private ReceiverStateObserver receiverStateObserver;
    private Gson gson = new Gson();

    public AsyncDataPublisher(String authenticationURL, String receiverURL, String username, String password) {
        this.isConnectorAlive = new AtomicBoolean(true);
        this.publishDataQueue = new LinkedBlockingQueue(10000);
        this.receiverConnectionWorker = new ReceiverConnectionWorker(authenticationURL, receiverURL, username, password, null);
        this.connectorService.submit(this.receiverConnectionWorker);
    }

    public AsyncDataPublisher(String receiverURL, String username, String password) {
        this.isConnectorAlive = new AtomicBoolean(true);
        this.publishDataQueue = new LinkedBlockingQueue(10000);
        this.receiverConnectionWorker = new ReceiverConnectionWorker(receiverURL, username, password);
        this.connectorService.submit(this.receiverConnectionWorker);
    }

    public AsyncDataPublisher(String receiverURL, String username, String password, Agent agent) {
        this.isConnectorAlive = new AtomicBoolean(true);
        this.publishDataQueue = new LinkedBlockingQueue(agent.getAgentConfiguration().getAsyncDataPublisherBufferedEventSize());
        this.receiverConnectionWorker = new ReceiverConnectionWorker(receiverURL, username, password, agent);
        this.connectorService.submit(this.receiverConnectionWorker);
    }

    public AsyncDataPublisher(String authenticationUrl, String receiverUrl, String userName, String password, Agent agent) {
        this.isConnectorAlive = new AtomicBoolean(true);
        this.publishDataQueue = new LinkedBlockingQueue(agent.getAgentConfiguration().getAsyncDataPublisherBufferedEventSize());
        this.receiverConnectionWorker = new ReceiverConnectionWorker(authenticationUrl, receiverUrl, userName, password, agent);
        this.connectorService.submit(this.receiverConnectionWorker);
    }

    public AsyncDataPublisher(String authenticationUrl, String receiverUrl, String userName, String password, Agent agent, ConcurrentHashMap<String, String> streamDefnCache) {
        if (streamDefnCache != null) {
            this.streamDefnCache = streamDefnCache;
        }
        this.isConnectorAlive = new AtomicBoolean(true);
        if (agent != null) {
            this.publishDataQueue = new LinkedBlockingQueue(agent.getAgentConfiguration().getAsyncDataPublisherBufferedEventSize());
            this.receiverConnectionWorker = new ReceiverConnectionWorker(authenticationUrl, receiverUrl, userName, password, agent);
        } else {
            this.publishDataQueue = new LinkedBlockingQueue(10000);
            this.receiverConnectionWorker = new ReceiverConnectionWorker(authenticationUrl, receiverUrl, userName, password, null);
        }
        this.connectorService.submit(this.receiverConnectionWorker);
    }

    public AsyncDataPublisher(DataPublisher dataPublisher) {
        this.dataPublisher = dataPublisher;
        int bufferSize = dataPublisher.getAgent().getAgentConfiguration().getAsyncDataPublisherBufferedEventSize();
        this.publishDataQueue = new LinkedBlockingQueue(bufferSize);
    }

    public void reconnect() {
        if (!this.isConnectorAlive.get() && this.isConnectorAlive.compareAndSet(false, true)) {
            this.receiverConnectionWorker.isReconnecting = true;
            this.publisherService.submit(this.receiverConnectionWorker);
        }
    }

    public boolean canPublish() {
        return null != this.dataPublisher || this.isConnectorAlive.get();
    }

    public void setAgent(Agent agent) throws AgentException, AuthenticationException, TransportException {
        this.dataPublisher.setAgent(agent);
    }

    public Agent getAgent() {
        if (null != this.dataPublisher) {
            return this.dataPublisher.getAgent();
        }
        return null;
    }

    public void registerReceiverObserver(ReceiverStateObserver observer) {
        this.receiverStateObserver = observer;
        if (null != this.dataPublisher) {
            this.dataPublisher.registerReceiverStateObserver(this.receiverStateObserver);
        }
    }

    public void publish(String streamName, String streamVersion, long timeStamp, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray) throws AgentException {
        this.publish(streamName, streamVersion, timeStamp, metaDataArray, correlationDataArray, payloadDataArray, null);
    }

    public void publish(String streamName, String streamVersion, long timeStamp, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray, Map<String, String> arbitraryDataMap) throws AgentException {
        if (this.canPublish()) {
            if (null != this.dataPublisher) {
                String streamKey = DataPublisherUtil.getStreamCacheKey(streamName, streamVersion);
                String streamId = this.streamIdCache.get(streamKey);
                if (null != streamId) {
                    this.dataPublisher.publish(streamId, timeStamp, metaDataArray, correlationDataArray, payloadDataArray, arbitraryDataMap);
                } else {
                    boolean isAdded = this.publishDataQueue.offer(new PublishData(streamName, streamVersion, timeStamp, metaDataArray, correlationDataArray, payloadDataArray, arbitraryDataMap));
                    if (this.isPublisherAlive.compareAndSet(false, true)) {
                        this.publisherService.submit(new DataPublishWorker());
                    }
                    if (!isAdded) {
                        log.error((Object)"Event queue is full, and Event is not added to the queue to publish");
                    }
                }
            } else {
                boolean isAdded = this.publishDataQueue.offer(new PublishData(streamName, streamVersion, timeStamp, metaDataArray, correlationDataArray, payloadDataArray, arbitraryDataMap));
                if (!isAdded && log.isDebugEnabled()) {
                    log.debug((Object)"Event queue is full, and Event is not added to the queue to publish");
                }
            }
        } else {
            boolean isAdded = this.publishDataQueue.offer(new PublishData(streamName, streamVersion, timeStamp, metaDataArray, correlationDataArray, payloadDataArray, arbitraryDataMap));
            this.reconnect();
            if (!isAdded && log.isDebugEnabled()) {
                log.debug((Object)"Event queue is full, and Event is not added to the queue to publish");
            }
        }
    }

    public void publish(String streamName, String streamVersion, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray) throws AgentException {
        this.publish(streamName, streamVersion, metaDataArray, correlationDataArray, payloadDataArray, null);
    }

    public void publish(String streamName, String streamVersion, Object[] metaDataArray, Object[] correlationDataArray, Object[] payloadDataArray, Map<String, String> arbitraryDataMap) throws AgentException {
        if (this.canPublish()) {
            if (null != this.dataPublisher) {
                String streamKey = DataPublisherUtil.getStreamCacheKey(streamName, streamVersion);
                String streamId = this.streamIdCache.get(streamKey);
                if (null != streamId) {
                    this.dataPublisher.publish(streamId, metaDataArray, correlationDataArray, payloadDataArray);
                } else {
                    boolean isAdded = this.publishDataQueue.offer(new PublishData(streamName, streamVersion, metaDataArray, correlationDataArray, payloadDataArray, arbitraryDataMap));
                    if (this.isPublisherAlive.compareAndSet(false, true)) {
                        this.publisherService.submit(new DataPublishWorker());
                    }
                    if (!isAdded) {
                        log.error((Object)"Event queue is full, and Event is not added to the queue to publish");
                    }
                }
            } else {
                boolean isAdded = this.publishDataQueue.offer(new PublishData(streamName, streamVersion, metaDataArray, correlationDataArray, payloadDataArray, arbitraryDataMap));
                if (!isAdded && log.isDebugEnabled()) {
                    log.debug((Object)"Event queue is full, and Event is not added to the queue to publish");
                }
            }
        } else {
            boolean isAdded = this.publishDataQueue.offer(new PublishData(streamName, streamVersion, metaDataArray, correlationDataArray, payloadDataArray, arbitraryDataMap));
            this.reconnect();
            if (!isAdded && log.isDebugEnabled()) {
                log.debug((Object)"Event queue is full, and Event is not added to the queue to publish");
            }
        }
    }

    public void publish(String streamName, String streamVersion, Event event) throws AgentException {
        if (this.canPublish()) {
            if (null != this.dataPublisher) {
                String streamKey = DataPublisherUtil.getStreamCacheKey(streamName, streamVersion);
                String streamId = this.streamIdCache.get(streamKey);
                if (null != streamId) {
                    event.setStreamId(streamId);
                    this.dataPublisher.publish(event);
                } else {
                    boolean isAdded = this.publishDataQueue.offer(new PublishData(streamName, streamVersion, event));
                    if (this.isPublisherAlive.compareAndSet(false, true)) {
                        this.publisherService.submit(new DataPublishWorker());
                    }
                    if (!isAdded) {
                        log.error((Object)"Event queue is full, and Event is not added to the queue to publish");
                    }
                }
            } else {
                boolean isAdded = this.publishDataQueue.offer(new PublishData(streamName, streamVersion, event));
                if (!isAdded && log.isDebugEnabled()) {
                    log.debug((Object)"Event queue is full, and Event is not added to the queue to publish");
                }
            }
        } else {
            boolean isAdded = this.publishDataQueue.offer(new PublishData(streamName, streamVersion, event));
            this.reconnect();
            if (!isAdded && log.isDebugEnabled()) {
                log.debug((Object)"Event queue is full, and Event is not added to the queue to publish");
            }
        }
    }

    public void publish(Event event) throws AgentException {
        if (this.canPublish()) {
            if (null != this.dataPublisher) {
                this.dataPublisher.publish(event);
            } else {
                boolean isAdded = this.publishDataQueue.offer(new PublishData(null, null, event));
                if (!isAdded && log.isDebugEnabled()) {
                    log.debug((Object)"Event queue is full, and Event is not added to the queue to publish");
                }
            }
        } else {
            boolean isAdded = this.publishDataQueue.offer(new PublishData(null, null, event));
            this.reconnect();
            if (!isAdded && log.isDebugEnabled()) {
                log.debug((Object)"Event queue is full, and Event is not added to the queue to publish");
            }
        }
    }

    public synchronized LinkedBlockingQueue<PublishData> getQueuedEventsAndReset() {
        LinkedBlockingQueue<PublishData> temp = this.publishDataQueue;
        this.publishDataQueue = null;
        return temp;
    }

    public void addStreamDefinition(String streamDefn, String streamName, String version) {
        String key = DataPublisherUtil.getStreamCacheKey(streamName, version);
        this.streamDefnCache.put(key, streamDefn);
    }

    public void addStreamDefinition(StreamDefinition definition) {
        String key = DataPublisherUtil.getStreamCacheKey(definition.getName(), definition.getVersion());
        this.streamDefnCache.put(key, this.gson.toJson((Object)definition));
    }

    public boolean isStreamDefinitionAdded(String streamName, String version) {
        String key = DataPublisherUtil.getStreamCacheKey(streamName, version);
        return null != this.streamDefnCache.get(key);
    }

    public boolean isStreamDefinitionAdded(StreamDefinition streamDefinition) {
        String key = DataPublisherUtil.getStreamCacheKey(streamDefinition.getName(), streamDefinition.getVersion());
        return null != this.streamDefnCache.get(key);
    }

    @Deprecated
    public String findStream(String name, String version) throws AgentException, StreamDefinitionException, NoStreamDefinitionExistException {
        if (null != this.dataPublisher) {
            String key = DataPublisherUtil.getStreamCacheKey(name, version);
            String streamId = this.streamIdCache.get(key);
            if (null == streamId) {
                streamId = this.dataPublisher.findStream(name, version);
                this.streamIdCache.put(key, streamId);
            }
            return streamId;
        }
        return null;
    }

    public String findStreamId(String name, String version) throws AgentException {
        if (null != this.dataPublisher) {
            String key = DataPublisherUtil.getStreamCacheKey(name, version);
            String streamId = this.streamIdCache.get(key);
            if (null == streamId) {
                streamId = this.dataPublisher.findStreamId(name, version);
                this.streamIdCache.put(key, streamId);
            }
            return streamId;
        }
        return null;
    }

    public void stop() {
        this.publisherService.shutdown();
        this.connectorService.shutdown();
        if (null != this.dataPublisher) {
            this.dataPublisher.stop();
        }
    }

    private class ReceiverConnectionWorker
    implements Runnable {
        private String authenticationUrl;
        private String receiverUrl;
        private String username;
        private String password;
        private Agent agent;
        private boolean isReconnecting;

        private ReceiverConnectionWorker(String authenticationUrl, String receiverUrl, String username, String password, Agent agent) {
            this.authenticationUrl = authenticationUrl;
            this.receiverUrl = receiverUrl;
            this.username = username;
            this.password = password;
            this.agent = agent;
        }

        private ReceiverConnectionWorker(String receiverUrl, String username, String password) {
            this.receiverUrl = receiverUrl;
            this.username = username;
            this.password = password;
        }

        private ReceiverConnectionWorker(String receiverUrl, String username, String password, Agent agent) {
            this.receiverUrl = receiverUrl;
            this.username = username;
            this.password = password;
            this.agent = agent;
        }

        @Override
        public void run() {
            try {
                block25: {
                    try {
                        if (null != this.authenticationUrl) {
                            if (null != this.agent) {
                                AsyncDataPublisher.this.dataPublisher = new DataPublisher(this.authenticationUrl, this.receiverUrl, this.username, this.password, this.agent);
                            } else {
                                AsyncDataPublisher.this.dataPublisher = new DataPublisher(this.authenticationUrl, this.receiverUrl, this.username, this.password);
                            }
                        } else if (null != this.agent) {
                            AsyncDataPublisher.this.dataPublisher = new DataPublisher(this.receiverUrl, this.username, this.password, this.agent);
                        } else {
                            AsyncDataPublisher.this.dataPublisher = new DataPublisher(this.receiverUrl, this.username, this.password);
                        }
                        if (null != AsyncDataPublisher.this.receiverStateObserver) {
                            AsyncDataPublisher.this.dataPublisher.registerReceiverStateObserver(AsyncDataPublisher.this.receiverStateObserver);
                            AsyncDataPublisher.this.receiverStateObserver.notifyConnectionSuccess(this.receiverUrl, this.username, this.password);
                        }
                        AsyncDataPublisher.this.isPublisherAlive.compareAndSet(false, true);
                        Thread triggerDataPublisherWorker = new Thread(new DataPublishWorker());
                        triggerDataPublisherWorker.start();
                    }
                    catch (MalformedURLException e) {
                        AsyncDataPublisher.this.dataPublisher = null;
                        if (!this.isReconnecting) {
                            log.error((Object)"Malformed url error when connecting to receiver", (Throwable)e);
                        } else {
                            log.error((Object)("Reconnection failed for " + this.receiverUrl));
                        }
                        if (null != AsyncDataPublisher.this.receiverStateObserver) {
                            AsyncDataPublisher.this.receiverStateObserver.notifyConnectionFailure(this.receiverUrl, this.username, this.password);
                            AsyncDataPublisher.this.receiverStateObserver.resendPublishedData(AsyncDataPublisher.this.publishDataQueue);
                        }
                    }
                    catch (AgentException e) {
                        AsyncDataPublisher.this.dataPublisher = null;
                        if (!this.isReconnecting) {
                            log.error((Object)"Error while connection to event receiver", (Throwable)e);
                        } else {
                            log.error((Object)("Reconnection failed for for " + this.receiverUrl));
                        }
                        if (null != AsyncDataPublisher.this.receiverStateObserver) {
                            AsyncDataPublisher.this.receiverStateObserver.notifyConnectionFailure(this.receiverUrl, this.username, this.password);
                            AsyncDataPublisher.this.receiverStateObserver.resendPublishedData(AsyncDataPublisher.this.publishDataQueue);
                        }
                    }
                    catch (AuthenticationException e) {
                        AsyncDataPublisher.this.dataPublisher = null;
                        if (!this.isReconnecting) {
                            log.error((Object)"Error while connection to event receiver", (Throwable)e);
                        } else {
                            log.error((Object)("Reconnection failed for" + this.receiverUrl));
                        }
                        if (null != AsyncDataPublisher.this.receiverStateObserver) {
                            AsyncDataPublisher.this.receiverStateObserver.notifyConnectionFailure(this.receiverUrl, this.username, this.password);
                            AsyncDataPublisher.this.receiverStateObserver.resendPublishedData(AsyncDataPublisher.this.publishDataQueue);
                        }
                    }
                    catch (TransportException e) {
                        AsyncDataPublisher.this.dataPublisher = null;
                        if (!this.isReconnecting) {
                            log.error((Object)"Error while connection to event receiver", (Throwable)e);
                        } else {
                            log.error((Object)("Reconnection failed for " + this.receiverUrl));
                        }
                        if (null == AsyncDataPublisher.this.receiverStateObserver) break block25;
                        AsyncDataPublisher.this.receiverStateObserver.notifyConnectionFailure(this.receiverUrl, this.username, this.password);
                        AsyncDataPublisher.this.receiverStateObserver.resendPublishedData(AsyncDataPublisher.this.publishDataQueue);
                    }
                }
                this.isReconnecting = false;
                AsyncDataPublisher.this.isConnectorAlive.set(false);
            }
            catch (Throwable extremeCaseEx) {
                log.error((Object)extremeCaseEx.getMessage(), extremeCaseEx);
                this.isReconnecting = false;
                AsyncDataPublisher.this.isConnectorAlive.set(false);
            }
        }
    }

    private class DataPublishWorker
    implements Runnable {
        private DataPublishWorker() {
        }

        @Override
        public void run() {
            block21: {
                try {
                    PublishData data = (PublishData)AsyncDataPublisher.this.publishDataQueue.poll();
                    while (null != data) {
                        block20: {
                            String streamIdKey = null;
                            String streamId = null;
                            if (data.getStreamName() != null && data.getStreamVersion() != null) {
                                streamIdKey = DataPublisherUtil.getStreamCacheKey(data.getStreamName(), data.getStreamVersion());
                                streamId = (String)AsyncDataPublisher.this.streamIdCache.get(streamIdKey);
                            } else {
                                streamId = data.getEvent().getStreamId();
                            }
                            if (null == streamId) {
                                try {
                                    Object defn = AsyncDataPublisher.this.streamDefnCache.get(streamIdKey);
                                    if (defn instanceof StreamDefinition) {
                                        streamId = AsyncDataPublisher.this.dataPublisher.defineStream((StreamDefinition)defn);
                                    } else if (defn instanceof String) {
                                        streamId = AsyncDataPublisher.this.dataPublisher.defineStream(defn.toString());
                                    } else {
                                        log.error((Object)"Not Supported stream definition type");
                                    }
                                    if (null != streamId) {
                                        AsyncDataPublisher.this.streamIdCache.put(streamIdKey, streamId);
                                        data.getEvent().setStreamId(streamId);
                                        AsyncDataPublisher.this.dataPublisher.publish(data.getEvent());
                                        break block20;
                                    }
                                    log.error((Object)("Stream Id is null for stream definition :" + defn.toString()));
                                }
                                catch (AgentException e) {
                                    log.error((Object)"Error occurred while finding | defining the event", (Throwable)e);
                                }
                                catch (StreamDefinitionException e) {
                                    log.error((Object)"Error occurred while defining the event", (Throwable)e);
                                }
                                catch (DifferentStreamDefinitionAlreadyDefinedException e) {
                                    log.error((Object)"Stream definition already exist", (Throwable)e);
                                }
                                catch (MalformedStreamDefinitionException e) {
                                    log.error((Object)"Malformed stream definition", (Throwable)e);
                                }
                            } else {
                                data.getEvent().setStreamId(streamId);
                                try {
                                    AsyncDataPublisher.this.dataPublisher.publish(data.getEvent());
                                }
                                catch (AgentException e) {
                                    log.error((Object)"Error occurred while publishing the event", (Throwable)e);
                                }
                            }
                        }
                        data = (PublishData)AsyncDataPublisher.this.publishDataQueue.poll();
                    }
                    AsyncDataPublisher.this.isPublisherAlive.set(false);
                    if (null != AsyncDataPublisher.this.publishDataQueue.peek() && !AsyncDataPublisher.this.isPublisherAlive.get() && AsyncDataPublisher.this.isPublisherAlive.compareAndSet(false, true)) {
                        AsyncDataPublisher.this.publisherService.submit(new DataPublishWorker());
                    }
                }
                catch (Throwable extremeCaseEx) {
                    log.error((Object)extremeCaseEx.getMessage(), extremeCaseEx);
                    AsyncDataPublisher.this.isPublisherAlive.set(false);
                    if (null == AsyncDataPublisher.this.publishDataQueue.peek() || AsyncDataPublisher.this.isPublisherAlive.get() || !AsyncDataPublisher.this.isPublisherAlive.compareAndSet(false, true)) break block21;
                    AsyncDataPublisher.this.publisherService.submit(new DataPublishWorker());
                }
            }
        }
    }
}

