/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.multimap.tx;

import com.hazelcast.collection.CollectionContainer;
import com.hazelcast.collection.CollectionProxyId;
import com.hazelcast.collection.operations.CollectionKeyBasedOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.transaction.TransactionException;
import java.io.IOException;

public class TxnPrepareBackupOperation
extends CollectionKeyBasedOperation
implements BackupOperation {
    String caller;
    int threadId;
    long ttl;

    public TxnPrepareBackupOperation() {
    }

    public TxnPrepareBackupOperation(CollectionProxyId proxyId, Data dataKey, String caller, int threadId) {
        super(proxyId, dataKey);
        this.caller = caller;
        this.threadId = threadId;
    }

    @Override
    public void run() throws Exception {
        CollectionContainer container = this.getOrCreateContainer();
        if (!container.txnLock(this.dataKey, this.caller, this.threadId, this.ttl + 10000L)) {
            throw new TransactionException("Lock is not owned by the transaction! -> " + container.getLockOwnerInfo(this.dataKey));
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeUTF(this.caller);
        out.writeInt(this.threadId);
        out.writeLong(this.ttl);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.caller = in.readUTF();
        this.threadId = in.readInt();
        this.ttl = in.readLong();
    }

    @Override
    public int getId() {
        return 31;
    }
}

