/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.engine;

import java.util.Iterator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.HandlerDescription;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.axis2.i18n.Messages;
import org.apache.axis2.util.LoggingControl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractDispatcher
extends AbstractHandler {
    public static final String NAME = "AbstractDispatcher";
    private static final Log log = LogFactory.getLog(AbstractDispatcher.class);

    public AbstractDispatcher() {
        this.init(new HandlerDescription(NAME));
    }

    public abstract AxisOperation findOperation(AxisService var1, MessageContext var2) throws AxisFault;

    public abstract AxisService findService(MessageContext var1) throws AxisFault;

    public abstract void initDispatcher();

    @Override
    public Handler.InvocationResponse invoke(MessageContext msgctx) throws AxisFault {
        AxisOperation axisOperation;
        AxisService axisService = msgctx.getAxisService();
        if (axisService == null && (axisService = this.findService(msgctx)) != null) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug(msgctx.getLogIDString() + " " + Messages.getMessage("servicefound", axisService.getName()));
            }
            msgctx.setAxisService(axisService);
        }
        if (axisService != null && msgctx.getAxisOperation() == null && (axisOperation = this.findOperation(axisService, msgctx)) != null) {
            if (LoggingControl.debugLoggingAllowed && log.isDebugEnabled()) {
                log.debug(msgctx.getLogIDString() + " " + Messages.getMessage("operationfound", axisOperation.getName().getLocalPart()));
            }
            msgctx.setAxisOperation(axisOperation);
            msgctx.setAxisMessage(axisOperation.getMessage("In"));
            AxisEndpoint axisEndpoint = (AxisEndpoint)msgctx.getProperty("endpoint");
            if (axisEndpoint != null) {
                AxisBinding axisBinding = axisEndpoint.getBinding();
                AxisBindingOperation axisBindingOperation = (AxisBindingOperation)axisBinding.getChild(axisOperation.getName());
                if (axisBindingOperation == null) {
                    String localName = axisOperation.getName().getLocalPart();
                    AxisBindingOperation bindingOp = null;
                    Iterator<AxisBindingOperation> iterator = axisBinding.getChildren();
                    while (iterator.hasNext()) {
                        bindingOp = iterator.next();
                        if (!localName.equals(bindingOp.getName().getLocalPart())) continue;
                        axisBindingOperation = bindingOp;
                        break;
                    }
                }
                if (axisBindingOperation != null) {
                    msgctx.setProperty("AxisBindingMessage", axisBindingOperation.getChild("In"));
                    msgctx.setProperty("AxisBindingOperation", axisBindingOperation);
                }
            }
        }
        return Handler.InvocationResponse.CONTINUE;
    }
}

