/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.persistence;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisBinding;
import org.apache.axis2.description.AxisBindingOperation;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisEndpoint;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.InOnlyAxisOperation;
import org.apache.axis2.description.OutOnlyAxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.util.JavaUtils;
import org.apache.axis2.util.PolicyUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.neethi.PolicyEngine;
import org.wso2.carbon.CarbonException;
import org.wso2.carbon.core.persistence.AbstractPersistenceManager;
import org.wso2.carbon.core.persistence.PersistenceDataNotFoundException;
import org.wso2.carbon.core.persistence.PersistenceException;
import org.wso2.carbon.core.persistence.PersistenceFactory;
import org.wso2.carbon.core.persistence.PersistenceUtils;
import org.wso2.carbon.core.transports.TransportPersistenceManager;
import org.wso2.carbon.registry.core.Resource;
import org.wso2.carbon.utils.deployment.GhostDeployerUtils;

public class ServicePersistenceManager
extends AbstractPersistenceManager {
    private static final String ADDRESSING_MODULE = "addressing";
    private static final Log log = LogFactory.getLog(ServicePersistenceManager.class);

    public ServicePersistenceManager(AxisConfiguration axisConfig, PersistenceFactory pf) throws AxisFault {
        super(axisConfig, pf.getServiceGroupFilePM(), pf);
    }

    public ServicePersistenceManager(AxisConfiguration axisConfig) throws AxisFault {
        super(axisConfig);
        try {
            if (this.pf == null) {
                this.pf = PersistenceFactory.getInstance(axisConfig);
            }
            this.fpm = this.pf.getServiceGroupFilePM();
        }
        catch (Exception e) {
            log.error((Object)"Error getting PersistenceFactory instance", (Throwable)e);
        }
    }

    public OMElement getService(AxisService axisService) throws Exception {
        block8: {
            try {
                OMElement serviceElement;
                String xpathStr = PersistenceUtils.getResourcePath(axisService);
                String sgName = axisService.getAxisServiceGroup().getServiceGroupName();
                if (this.getServiceGroupFilePM().isTransactionStarted(sgName) && this.getServiceGroupFilePM().elementExists(sgName, xpathStr)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Successfully retrieved resource for " + axisService.getName() + " Service"));
                    }
                    return (OMElement)this.getServiceGroupFilePM().get(sgName, xpathStr);
                }
                if (!this.getCurrentFPM().fileExists(sgName)) break block8;
                try {
                    serviceElement = (OMElement)this.getCurrentFPM().get(sgName, xpathStr);
                }
                catch (PersistenceDataNotFoundException e) {
                    return null;
                }
                if (serviceElement != null && serviceElement.getAttributeValue(new QName("successfullyAdded")) != null) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Successfully retrieved resource for " + axisService.getName() + " Service"));
                    }
                    return serviceElement;
                }
            }
            catch (Throwable e) {
                this.handleException("Could not get the Service resource from file ", e);
            }
        }
        return null;
    }

    public void deleteService(AxisService axisService) throws Exception {
        Parameter param = axisService.getParameter("preserveServiceHistory");
        String xpathStr = PersistenceUtils.getResourcePath(axisService);
        String sgName = axisService.getAxisServiceGroup().getServiceGroupName();
        try {
            this.getServiceGroupFilePM().beginTransaction(sgName);
            if (this.getServiceGroupFilePM().fileExists(sgName) && (param == null || !JavaUtils.isTrue((String)param.getValue().toString()))) {
                this.getServiceGroupFilePM().delete(sgName, xpathStr);
            }
            this.getServiceGroupFilePM().commitTransaction(sgName);
        }
        catch (PersistenceDataNotFoundException e) {
            log.debug((Object)(sgName + " deleteService exception"), (Throwable)e);
            this.handleExceptionWithRollback(sgName, "Could not delete Service resource from file", e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Successfully deleted " + axisService.getName() + " Service"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNewServiceAddition(AxisService axisService) throws Exception {
        if (axisService.isClientSide()) {
            return;
        }
        String sgName = axisService.getAxisServiceGroup().getServiceGroupName();
        boolean isProxyService = PersistenceUtils.isProxyService(axisService);
        Object object = WRITE_LOCK;
        synchronized (object) {
            try {
                this.getServiceGroupFilePM().beginTransaction(sgName);
                this.configRegistry.beginTransaction();
                OMElement serviceElement = this.omFactory.createOMElement("service", null);
                serviceElement.addAttribute("name", axisService.getName(), null);
                if (axisService.getDocumentation() != null) {
                    serviceElement.addAttribute("serviceDocumentation", axisService.getDocumentation(), null);
                }
                serviceElement.addAttribute("exposedAllTransports", String.valueOf(axisService.isEnableAllTransports()), null);
                long serviceDeployedTime = new Date().getTime();
                axisService.addParameter(new Parameter("serviceDeploymentTime", (Object)serviceDeployedTime));
                serviceElement.addAttribute("serviceDeployedTime", String.valueOf(serviceDeployedTime), null);
                this.getServiceGroupFilePM().put(sgName, serviceElement, "/");
                String xpathToService = PersistenceUtils.getResourcePath(axisService);
                Iterator iter = axisService.getOperations();
                while (iter.hasNext()) {
                    AxisOperation axisOperation = (AxisOperation)iter.next();
                    OMElement operation = PersistenceUtils.createOperation((AxisDescription)axisOperation, axisOperation.getName().getLocalPart());
                    serviceElement.addChild((OMNode)operation);
                    this.writeParameters(sgName, axisOperation.getParameters(), PersistenceUtils.getResourcePath(axisOperation));
                }
                Map endPointMap = axisService.getEndpoints();
                Iterator i$ = endPointMap.entrySet().iterator();
                while (i$.hasNext()) {
                    Map.Entry o;
                    Map.Entry entry = o = i$.next();
                    AxisBinding axisBinding = ((AxisEndpoint)entry.getValue()).getBinding();
                    String bindingsPath = PersistenceUtils.getResourcePath(axisService) + "/" + "bindings";
                    if (this.getServiceGroupFilePM().elementExists(sgName, bindingsPath + "/" + "binding" + PersistenceUtils.getXPathAttrPredicate("name", axisBinding.getName().getLocalPart()))) continue;
                    this.handleNewBindingAddition(axisService, axisBinding, bindingsPath);
                }
                List<OMElement> servicePolicies = this.getServicePolicies(axisService);
                String policiesPath = PersistenceUtils.getResourcePath(axisService) + "/" + "policies";
                if (!this.getServiceGroupFilePM().elementExists(sgName, policiesPath)) {
                    OMElement policiesEl = this.omFactory.createOMElement("policies", null);
                    this.getServiceGroupFilePM().put(sgName, policiesEl, PersistenceUtils.getResourcePath(axisService));
                }
                for (OMElement servicePolicy : servicePolicies) {
                    this.getServiceGroupFilePM().put(sgName, servicePolicy, policiesPath);
                }
                if (isProxyService && servicePolicies != null && !servicePolicies.isEmpty()) {
                    org.wso2.carbon.registry.core.Collection serviceResource = this.configRegistry.newCollection();
                    String serviceResourcePath = PersistenceUtils.getRegistryResourcePath(axisService);
                    this.configRegistry.put(serviceResourcePath, (Resource)serviceResource);
                    for (OMElement wrappedServicePolicyElement : servicePolicies) {
                        Policy servicePolicy = PolicyEngine.getPolicy((OMElement)wrappedServicePolicyElement.getFirstChildWithName(new QName("http://schemas.xmlsoap.org/ws/2004/09/policy", "Policy")));
                        Resource servicePolicyResource = PersistenceUtils.createPolicyResource(this.configRegistry, servicePolicy, servicePolicy.getId(), "" + servicePolicy.getType());
                        this.configRegistry.put(serviceResourcePath + "/policies/" + servicePolicyResource.getProperty("policy.uuid"), servicePolicyResource);
                    }
                }
                if (axisService.getScope().equals("soapsession") && !axisService.isEngaged(ADDRESSING_MODULE)) {
                    axisService.engageModule(axisService.getAxisConfiguration().getModule(ADDRESSING_MODULE));
                }
                Iterator<Object> i$2 = axisService.getEngagedModules().iterator();
                while (i$2.hasNext()) {
                    AxisModule node;
                    AxisModule axisModule = node = (AxisModule)i$2.next();
                    String version = PersistenceUtils.getModuleVersion(axisModule);
                    if (this.isGloballyEngaged(axisModule.getName(), version) || axisService.getParent().isEngaged(axisModule.getName())) continue;
                    OMElement module = this.omFactory.createOMElement("module", null);
                    module.addAttribute("name", axisModule.getName(), null);
                    module.addAttribute("version", version, null);
                    module.addAttribute("type", "engagedModules", null);
                    this.getServiceGroupFilePM().put(sgName, module, "/service");
                }
                Iterator iter2 = axisService.getOperations();
                while (iter2.hasNext()) {
                    AxisOperation axisOperation = (AxisOperation)iter2.next();
                    Iterator<Object> i$3 = axisOperation.getEngagedModules().iterator();
                    while (i$3.hasNext()) {
                        AxisModule o;
                        AxisModule axisModule = o = (AxisModule)i$3.next();
                        String version = PersistenceUtils.getModuleVersion(axisModule);
                        if (this.isGloballyEngaged(axisModule.getName(), version) || axisService.getParent().isEngaged(axisModule.getName()) || axisService.isEngaged(axisModule.getName())) continue;
                        OMElement module = PersistenceUtils.createModule(axisModule.getName(), version, "engagedModules");
                        this.getServiceGroupFilePM().put(sgName, module, PersistenceUtils.getResourcePath(axisOperation));
                    }
                }
                this.writeParameters(sgName, axisService.getParameters(), xpathToService);
                if (!axisService.isEnableAllTransports()) {
                    List exposedTransports = axisService.getExposedTransports();
                    for (String exposedTransport : exposedTransports) {
                        Resource transportResource = new TransportPersistenceManager(this.axisConfig).getTransportResource(exposedTransport);
                        if (transportResource == null) {
                            throw new CarbonException("The configuration resource for " + exposedTransport + " transport does not exist in Registry");
                        }
                        OMElement association = this.omFactory.createOMElement("association", null);
                        association.addAttribute("destinationPath", transportResource.getPath(), null);
                        association.addAttribute("type", "exposedTransports", null);
                        this.getServiceGroupFilePM().put(sgName, association, xpathToService);
                    }
                }
                if ((serviceElement = (OMElement)this.getServiceGroupFilePM().get(sgName, xpathToService)) != null) {
                    serviceElement.addAttribute("successfullyAdded", "true", null);
                    this.getServiceGroupFilePM().setMetaFileModification(sgName);
                }
                this.getServiceGroupFilePM().commitTransaction(sgName);
                this.configRegistry.commitTransaction();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Added new service - " + axisService.getName()));
                }
            }
            catch (Throwable e) {
                this.configRegistry.rollbackTransaction();
                this.handleExceptionWithRollback(sgName, "Unable to handle new service addition. Service: " + axisService.getName(), e);
            }
        }
    }

    private void handleNewBindingAddition(AxisService axisService, AxisBinding axisBinding, String xpathToBindings) throws PersistenceException {
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        OMElement bindings = (OMElement)this.getServiceGroupFilePM().get(serviceGroupId, xpathToBindings);
        if (bindings == null) {
            bindings = this.omFactory.createOMElement("bindings", null);
        } else {
            bindings.detach();
        }
        OMElement bindingElement = this.omFactory.createOMElement("binding", null, (OMContainer)bindings);
        bindingElement.addAttribute("name", axisBinding.getName().getLocalPart(), null);
        Iterator operations = axisBinding.getChildren();
        while (operations.hasNext()) {
            AxisBindingOperation bo = (AxisBindingOperation)operations.next();
            bindingElement.addChild((OMNode)PersistenceUtils.createOperation((AxisDescription)bo, bo.getName().getLocalPart()));
        }
        this.getServiceGroupFilePM().put(serviceGroupId, bindings, "/service" + PersistenceUtils.getXPathAttrPredicate("name", axisService.getName()));
    }

    public void handleExistingServiceInit(AxisService axisService) throws Exception {
        AxisService actualService = null;
        Parameter isGhostService = axisService.getParameter("GhostService");
        if (isGhostService != null && "true".equals(isGhostService.getValue()) && (actualService = GhostDeployerUtils.deployActualService((AxisConfiguration)this.axisConfig, (AxisService)axisService)) != null) {
            axisService = actualService;
        }
        boolean isProxyService = PersistenceUtils.isProxyService(axisService);
        boolean wsdlChangeDetected = false;
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        try {
            String serviceState;
            String string;
            boolean isTransactionStarted = this.getServiceGroupFilePM().isTransactionStarted(serviceGroupId);
            if (!isTransactionStarted) {
                this.getServiceGroupFilePM().beginTransaction(serviceGroupId);
            }
            String serviceElementPath = PersistenceUtils.getResourcePath(axisService);
            OMElement serviceElement = (OMElement)this.getServiceGroupFilePM().get(serviceGroupId, serviceElementPath);
            if (!isProxyService) {
                this.loadPolicies(serviceGroupId, (AxisDescription)axisService, this.getServiceGroupFilePM().getAll(serviceGroupId, serviceElementPath + "/" + "policyUUID"), serviceElementPath);
            }
            Iterator iter = axisService.getOperations();
            while (iter.hasNext()) {
                AxisOperation axisOperation = (AxisOperation)iter.next();
                String operationXPath = PersistenceUtils.getResourcePath(axisOperation);
                if (this.getServiceGroupFilePM().elementExists(serviceGroupId, operationXPath)) {
                    if (axisOperation.isControlOperation()) continue;
                    if (!isProxyService) {
                        this.loadPolicies(serviceGroupId, (AxisDescription)axisOperation, this.getServiceGroupFilePM().getAll(serviceGroupId, operationXPath + "/" + "policyUUID"), serviceElementPath);
                    }
                    if (!(axisOperation instanceof OutOnlyAxisOperation) && !isProxyService) {
                        this.loadPolicies(serviceGroupId, (AxisDescription)axisOperation.getMessage("In"), this.getServiceGroupFilePM().getAll(serviceGroupId, operationXPath + "/" + "messageInPolicyUuid"), serviceElementPath);
                    }
                    if (!(axisOperation instanceof InOnlyAxisOperation) && !isProxyService) {
                        this.loadPolicies(serviceGroupId, (AxisDescription)axisOperation.getMessage("Out"), this.getServiceGroupFilePM().getAll(serviceGroupId, operationXPath + "/" + "messageOutPolicyUuid"), serviceElementPath);
                    }
                    for (AxisModule axisModule : axisOperation.getEngagedModules()) {
                        axisOperation.disengageModule(axisModule);
                    }
                    List moduleList = this.getServiceGroupFilePM().getAll(serviceGroupId, operationXPath + "/" + "module");
                    for (Object node : moduleList) {
                        OMElement module = (OMElement)node;
                        String modName = module.getAttributeValue(new QName("name"));
                        String modVersion = module.getAttributeValue(new QName("version"));
                        AxisModule axisModule = this.getExistingAxisModule(modName, modVersion);
                        if (this.isGloballyEngaged(modName, modVersion) || axisService.isEngaged(axisModule)) continue;
                        axisOperation.engageModule(axisModule);
                    }
                    this.loadParameters(serviceGroupId, (AxisDescription)axisOperation, operationXPath + "/" + "parameter");
                    this.loadDocumentation(serviceGroupId, (AxisDescription)axisOperation, operationXPath);
                    continue;
                }
                wsdlChangeDetected = true;
                OMElement operationElement = PersistenceUtils.createOperation((AxisDescription)axisOperation, axisOperation.getName().getLocalPart());
                this.getServiceGroupFilePM().put(serviceGroupId, operationElement, serviceElementPath);
                this.writeParameters(serviceGroupId, axisOperation.getParameters(), PersistenceUtils.getResourcePath(axisOperation));
                Iterator iterator = axisOperation.getEngagedModules().iterator();
                while (iterator.hasNext()) {
                    AxisModule o;
                    AxisModule axisModule = o = (AxisModule)iterator.next();
                    String version = PersistenceUtils.getModuleVersion(axisModule);
                    if (this.isGloballyEngaged(axisModule.getName(), version) || axisService.getParent().isEngaged(axisModule.getName()) || axisService.isEngaged(axisModule.getName())) continue;
                    OMElement moduleElement = PersistenceUtils.createModule(axisModule.getName(), version, "engagedModules");
                    this.getServiceGroupFilePM().put(serviceGroupId, moduleElement, PersistenceUtils.getResourcePath(axisOperation));
                }
            }
            String operationsPath = serviceElementPath + "/" + "operation";
            List operations = this.getServiceGroupFilePM().getAll(serviceGroupId, operationsPath);
            for (Object node : operations) {
                OMElement oMElement = (OMElement)node;
                String opName = oMElement.getAttributeValue(new QName("name"));
                if (axisService.getOperation(new QName(opName)) != null) continue;
                wsdlChangeDetected = true;
                oMElement.detach();
            }
            Map endPointMap = axisService.getEndpoints();
            for (Object object : endPointMap.entrySet()) {
                Map.Entry entry = (Map.Entry)object;
                AxisEndpoint point = (AxisEndpoint)entry.getValue();
                if (point == null || point.getBinding() == null || point.getBinding().getName() == null) {
                    if (!log.isDebugEnabled()) continue;
                    if (point != null) {
                        log.debug((Object)("The axis binding does not exist for SG " + serviceGroupId));
                        continue;
                    }
                    log.debug((Object)("The axis binding does not exist for " + point.getName() + serviceGroupId));
                    continue;
                }
                AxisBinding currentAxisBinding = point.getBinding();
                String bindingXPath = serviceElementPath + "/" + "bindings" + "/" + "binding" + PersistenceUtils.getXPathAttrPredicate("name", currentAxisBinding.getName().getLocalPart());
                if (this.getServiceGroupFilePM().elementExists(serviceGroupId, bindingXPath)) {
                    Collection attachedPolicies;
                    if (isProxyService && (attachedPolicies = axisService.getPolicySubject().getAttachedPolicyComponents()) != null && !attachedPolicies.isEmpty()) {
                        List tmpProperties = this.getServiceGroupFilePM().getAll(serviceGroupId, bindingXPath + "/" + "policyUUID" + "/text()");
                        ArrayList<String> properties = new ArrayList<String>(tmpProperties.size());
                        for (Object node : tmpProperties) {
                            if (!(node instanceof OMText)) continue;
                            properties.add(((OMText)node).getText());
                        }
                        if (properties != null && properties.size() > 0) {
                            ArrayList<String> removablePolicies = new ArrayList<String>();
                            for (PolicyComponent pc : attachedPolicies) {
                                String id;
                                if (!(pc instanceof Policy) || !properties.contains(id = ((Policy)pc).getId())) continue;
                                removablePolicies.add(id);
                            }
                            for (String id : removablePolicies) {
                                axisService.getPolicySubject().detachPolicyComponent(id);
                            }
                        }
                    }
                    this.loadPolicies(serviceGroupId, (AxisDescription)currentAxisBinding, this.getServiceGroupFilePM().getAll(serviceGroupId, bindingXPath + "/" + "policyUUID"), serviceElementPath);
                    Iterator operationsItr = currentAxisBinding.getChildren();
                    while (operationsItr.hasNext()) {
                        AxisBindingOperation bindingOp = (AxisBindingOperation)operationsItr.next();
                        String bindingOpPath = PersistenceUtils.getBindingOperationPath(serviceElementPath, bindingOp);
                        if (this.getServiceGroupFilePM().elementExists(serviceGroupId, bindingOpPath)) {
                            this.loadPolicies(serviceGroupId, (AxisDescription)bindingOp, this.getServiceGroupFilePM().getAll(serviceGroupId, bindingOpPath + "/" + "policyUUID"), serviceElementPath);
                            this.loadPolicies(serviceGroupId, bindingOp.getChild((Object)"In"), this.getServiceGroupFilePM().getAll(serviceGroupId, bindingOpPath + "/" + "messageInPolicyUuid"), serviceElementPath);
                            this.loadPolicies(serviceGroupId, bindingOp.getChild((Object)"Out"), this.getServiceGroupFilePM().getAll(serviceGroupId, bindingOpPath + "/" + "messageOutPolicyUuid"), serviceElementPath);
                            continue;
                        }
                        OMElement opElement = PersistenceUtils.createOperation((AxisDescription)bindingOp, bindingOp.getName().getLocalPart());
                        this.getServiceGroupFilePM().put(serviceGroupId, opElement, PersistenceUtils.getBindingPath(serviceElementPath, bindingOp.getAxisBinding()));
                    }
                    continue;
                }
                this.handleNewBindingAddition(axisService, currentAxisBinding, serviceElementPath + "/" + "bindings");
            }
            for (AxisModule axisModule : axisService.getEngagedModules()) {
                axisService.disengageModule(axisModule);
            }
            List engModules = this.getServiceGroupFilePM().getAll(serviceGroupId, serviceElementPath + "/" + "module");
            for (Object node : engModules) {
                String modName = ((OMElement)node).getAttributeValue(new QName("name"));
                String modVersion = ((OMElement)node).getAttributeValue(new QName("version"));
                AxisModule axisModule = this.getExistingAxisModule(modName, modVersion);
                if (this.isGloballyEngaged(modName, modVersion)) continue;
                axisService.disengageModule(axisModule);
                axisService.engageModule(axisModule);
            }
            if (wsdlChangeDetected) {
                if (axisService.getDocumentation() != null) {
                    serviceElement.addAttribute("serviceDocumentation", axisService.getDocumentation(), null);
                }
            } else {
                this.loadDocumentation(serviceGroupId, (AxisDescription)axisService, serviceElementPath);
            }
            if (isProxyService) {
                ArrayList arrayList = axisService.getParameters();
                ListIterator ite2 = arrayList.listIterator();
                while (ite2.hasNext()) {
                    Parameter serviceParameter = (Parameter)ite2.next();
                    if (serviceParameter.getParameterType() == 0) continue;
                    this.updateServiceParameter(axisService, serviceParameter);
                }
            }
            this.loadParameters(serviceGroupId, (AxisDescription)axisService, serviceElementPath + "/" + "parameter");
            if (isProxyService) {
                List list = axisService.getExposedTransports();
                ListIterator transportItr = list.listIterator();
                List associations = this.getServiceGroupFilePM().getAssociations(serviceGroupId, serviceElementPath, "exposedTransports");
                for (Object node : associations) {
                    ((OMElement)node).detach();
                }
                String allTransports = serviceElement.getAttributeValue(new QName("exposedAllTransports"));
                if (allTransports != null && "true".equals(allTransports)) {
                    serviceElement.addAttribute("exposedAllTransports", String.valueOf(false), null);
                }
                while (transportItr.hasNext()) {
                    String transport = (String)transportItr.next();
                    Resource transportResource = new TransportPersistenceManager(this.axisConfig).getTransportResource(transport);
                    if (transportResource == null) {
                        throw new CarbonException("The configuration resource for " + transport + " transport does not exist");
                    }
                    OMElement association = PersistenceUtils.createAssociation(transportResource.getPath(), "exposedTransports");
                    this.getServiceGroupFilePM().put(serviceGroupId, association, serviceElementPath);
                    if (!log.isDebugEnabled()) continue;
                    log.debug((Object)("Added " + transport + " transport binding for " + axisService.getName() + " service"));
                }
            } else if (!Boolean.valueOf(serviceElement.getAttributeValue(new QName("exposedAllTransports"))).booleanValue()) {
                axisService.setExposedTransports(new ArrayList());
                List list = this.getServiceGroupFilePM().getAssociations(serviceGroupId, serviceElementPath, "exposedTransports");
                for (Object node : list) {
                    String destinationPath = ((OMElement)node).getAttributeValue(new QName("destinationPath"));
                    Resource resource = this.configRegistry.get(destinationPath);
                    String transportProtocol = resource.getProperty("Protocol.Name");
                    axisService.addExposedTransport(transportProtocol);
                    resource.discard();
                }
            }
            if ((string = serviceElement.getAttributeValue(new QName("serviceDeployedTime"))) != null) {
                axisService.addParameter(new Parameter("serviceDeploymentTime", (Object)Long.parseLong(string)));
            }
            if ((serviceState = serviceElement.getAttributeValue(new QName("serviceActive"))) == null || serviceState.trim().length() == 0) {
                serviceState = "true";
            }
            axisService.setActive(Boolean.parseBoolean(serviceState));
            if (!isTransactionStarted) {
                this.getServiceGroupFilePM().commitTransaction(serviceGroupId);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Initialized service - " + axisService.getName()));
            }
        }
        catch (Throwable e) {
            this.handleExceptionWithRollback(axisService.getAxisServiceGroup().getServiceGroupName(), "Unable to handle service initialization. Service: " + axisService.getName(), e);
        }
    }

    public void engageModuleForService(AxisModule module, AxisService service) throws Exception {
        try {
            this.handleModuleForAxisDescription(service.getAxisServiceGroup().getServiceGroupName(), module, PersistenceUtils.getResourcePath(service), true);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully engaged " + module.getName() + " module for " + service.getName() + "service"));
            }
        }
        catch (Throwable e) {
            this.handleExceptionWithRollback(module.getName(), "Unable to engage " + module.getName() + " module to " + service.getName() + " service", e);
        }
    }

    public void disengageModuleForService(AxisModule module, AxisService service) throws Exception {
        try {
            this.handleModuleForAxisDescription(service.getAxisServiceGroup().getServiceGroupName(), module, PersistenceUtils.getResourcePath(service), false);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully disengaged " + module.getName() + " module from " + service.getName() + "service"));
            }
        }
        catch (Throwable e) {
            this.handleExceptionWithRollback(module.getName(), "Unable to disengage " + module.getName() + " module from " + service.getName() + " service", e);
        }
    }

    public void removeServiceParameter(AxisService service, Parameter parameter) throws Exception {
        this.removeParameter(service.getAxisServiceGroup().getServiceGroupName(), parameter.getName(), PersistenceUtils.getResourcePath(service));
    }

    public void setServiceProperty(AxisService service, String propertyName, String propertyValue) throws Exception {
        try {
            String serviceXPath = PersistenceUtils.getResourcePath(service);
            String sgName = service.getAxisServiceGroup().getServiceGroupName();
            boolean transactionStarted = this.getServiceGroupFilePM().isTransactionStarted(sgName);
            if (!transactionStarted) {
                this.getServiceGroupFilePM().beginTransaction(sgName);
            }
            if (this.getServiceGroupFilePM().elementExists(sgName, serviceXPath)) {
                OMElement serviceElement = (OMElement)this.getServiceGroupFilePM().get(sgName, serviceXPath);
                serviceElement.addAttribute(propertyName, propertyValue, null);
                this.getServiceGroupFilePM().setMetaFileModification(sgName);
            }
            if (!transactionStarted) {
                this.getServiceGroupFilePM().commitTransaction(sgName);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully set " + propertyName + " property for " + service.getName() + "service"));
            }
        }
        catch (Throwable e) {
            this.handleExceptionWithRollback(service.getAxisServiceGroup().getServiceGroupName(), "Unable to set property " + propertyName + " to service " + service.getName(), e);
        }
    }

    public void deleteServiceProperty(AxisService service, String propertyName) throws Exception {
        try {
            String serviceResourcePath = PersistenceUtils.getResourcePath(service);
            String sgName = service.getAxisServiceGroup().getServiceGroupName();
            boolean transactionStarted = this.getServiceGroupFilePM().isTransactionStarted(sgName);
            if (!transactionStarted) {
                this.getServiceGroupFilePM().beginTransaction(sgName);
            }
            if (this.getServiceGroupFilePM().elementExists(sgName, serviceResourcePath)) {
                OMElement serviceElement = (OMElement)this.getServiceGroupFilePM().get(sgName, serviceResourcePath);
                serviceElement.removeAttribute(serviceElement.getAttribute(new QName(propertyName)));
                this.getServiceGroupFilePM().setMetaFileModification(sgName);
            }
            if (!transactionStarted) {
                this.getServiceGroupFilePM().commitTransaction(sgName);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully set " + propertyName + " property for " + service.getName() + "service"));
            }
        }
        catch (Throwable e) {
            this.handleExceptionWithRollback(service.getAxisServiceGroup().getServiceGroupName(), "Unable to set property " + propertyName + " to service " + service.getName(), e);
        }
    }

    public void updateServiceAssociation(AxisService service, String destinationPath, String type) throws PersistenceException {
        OMElement assoc = PersistenceUtils.createAssociation(destinationPath, type);
        String serviceGroupId = service.getAxisServiceGroup().getServiceGroupName();
        String serviceXPath = PersistenceUtils.getResourcePath(service);
        String assocXPath = serviceXPath + "/" + "association" + PersistenceUtils.getXPathAttrPredicate("destinationPath", destinationPath);
        PersistenceUtils.getXPathAttrPredicate("type", type);
        boolean transactionStarted = this.getServiceGroupFilePM().isTransactionStarted(serviceGroupId);
        if (!transactionStarted) {
            this.getServiceGroupFilePM().beginTransaction(serviceGroupId);
        }
        if (this.getServiceGroupFilePM().elementExists(serviceGroupId, assocXPath)) {
            return;
        }
        this.getServiceGroupFilePM().put(serviceGroupId, assoc, serviceXPath);
        if (!transactionStarted) {
            this.getServiceGroupFilePM().commitTransaction(serviceGroupId);
        }
    }

    public void updateServiceParameter(AxisService service, Parameter parameter) throws Exception {
        try {
            this.updateParameter(service.getAxisServiceGroup().getServiceGroupName(), parameter, PersistenceUtils.getResourcePath(service));
        }
        catch (Exception e) {
            this.handleExceptionWithRollback(service.getAxisServiceGroup().getServiceGroupName(), "Unable to update the service parameter " + parameter.getName() + " of service " + service.getName(), e);
        }
    }

    public void removeExposedTransports(String serviceName, String transportProtocol) throws Exception {
        AxisService axisService = this.axisConfig.getServiceForActivation(serviceName);
        if (axisService == null) {
            this.handleException("No service found for the provided service name : " + serviceName);
            return;
        }
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        try {
            Resource transportResource = new TransportPersistenceManager(this.axisConfig).getTransportResource(transportProtocol);
            boolean transactionStarted = this.getServiceGroupFilePM().isTransactionStarted(serviceGroupId);
            if (!transactionStarted) {
                this.getServiceGroupFilePM().beginTransaction(serviceGroupId);
            }
            if (transportResource != null) {
                String transportXPath = PersistenceUtils.getResourcePath(axisService) + "/" + "association" + PersistenceUtils.getXPathAttrPredicate("destinationPath", transportResource.getPath()) + PersistenceUtils.getXPathAttrPredicate("type", "exposedTransports");
                if (this.getServiceGroupFilePM().elementExists(serviceGroupId, transportXPath)) {
                    this.getServiceGroupFilePM().delete(serviceGroupId, PersistenceUtils.getResourcePath(axisService) + "/" + "association" + PersistenceUtils.getXPathAttrPredicate("destinationPath", transportResource.getPath()) + PersistenceUtils.getXPathAttrPredicate("type", "exposedTransports"));
                }
                transportResource.discard();
            }
            List exposedTrps = axisService.getExposedTransports();
            for (String transport : exposedTrps) {
                transportResource = new TransportPersistenceManager(this.axisConfig).getTransportResource(transport);
                if (transportResource == null) {
                    throw new CarbonException("The configuration resource for " + transport + " transport does not exist");
                }
                OMElement assocElement = PersistenceUtils.createAssociation(transportResource.getPath(), "exposedTransports");
                String assocPath = PersistenceUtils.getResourcePath(axisService) + "/" + "association" + PersistenceUtils.getXPathAttrPredicate("destinationPath", transportResource.getPath()) + PersistenceUtils.getXPathAttrPredicate("type", "exposedTransports");
                if (!this.getServiceGroupFilePM().elementExists(serviceGroupId, assocPath)) {
                    this.getServiceGroupFilePM().put(serviceGroupId, assocElement, PersistenceUtils.getResourcePath(axisService));
                }
                transportResource.discard();
            }
            this.setServiceProperty(axisService, "exposedAllTransports", String.valueOf(false));
            if (!transactionStarted) {
                this.getServiceGroupFilePM().commitTransaction(serviceGroupId);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Successfully removed " + transportProtocol + " transport from " + serviceName + "service"));
            }
        }
        catch (Exception e) {
            this.handleExceptionWithRollback(serviceGroupId, "Error while removing exposed transport : " + transportProtocol, e);
        }
    }

    private List<OMElement> getServicePolicies(AxisService axisService) throws Exception {
        ArrayList<OMElement> policyElements = new ArrayList<OMElement>();
        String serviceGroupId = axisService.getAxisServiceGroup().getServiceGroupName();
        String serviceXPath = PersistenceUtils.getResourcePath(axisService);
        ArrayList servicePolicyList = new ArrayList(axisService.getPolicySubject().getAttachedPolicyComponents());
        Policy servicePolicy = PolicyUtil.getMergedPolicy(servicePolicyList, (AxisService)axisService);
        if (servicePolicy != null) {
            this.addPolicyElement(policyElements, servicePolicy, 3);
            this.setResourcePolicyId(axisService.getAxisServiceGroup().getServiceGroupName(), serviceXPath, servicePolicy.getId());
        }
        Iterator serviceOperations = axisService.getOperations();
        while (serviceOperations.hasNext()) {
            AxisMessage axisOutMessage;
            ArrayList messageOutPolicyList;
            Policy messageOutPolicy;
            AxisMessage axisInMessage;
            ArrayList messageInPolicyList;
            Policy messageInPolicy;
            AxisOperation axisOperation = (AxisOperation)serviceOperations.next();
            String opXPath = PersistenceUtils.getResourcePath(axisOperation);
            if (!this.getServiceGroupFilePM().elementExists(axisService.getAxisServiceGroup().getServiceGroupName(), opXPath)) continue;
            OMElement operationElement = (OMElement)this.getServiceGroupFilePM().get(axisService.getAxisServiceGroup().getServiceGroupName(), opXPath);
            ArrayList opPolicyList = new ArrayList(axisOperation.getPolicySubject().getAttachedPolicyComponents());
            Policy operationPolicy = PolicyUtil.getMergedPolicy(opPolicyList, (AxisDescription)axisOperation);
            if (operationPolicy != null) {
                this.addPolicyElement(policyElements, operationPolicy, 4);
                OMElement idElement = this.omFactory.createOMElement("policyUUID", null);
                idElement.setText(operationPolicy.getId());
                operationElement.addChild((OMNode)idElement);
            }
            if (!(axisOperation instanceof OutOnlyAxisOperation) && (messageInPolicy = PolicyUtil.getMergedPolicy(messageInPolicyList = new ArrayList((axisInMessage = axisOperation.getMessage("In")).getPolicySubject().getAttachedPolicyComponents()), (AxisDescription)axisInMessage)) != null) {
                this.addPolicyElement(policyElements, messageInPolicy, 5);
                operationElement.addAttribute("messageInPolicyUuid", messageInPolicy.getId(), null);
            }
            if (!(axisOperation instanceof InOnlyAxisOperation) && (messageOutPolicy = PolicyUtil.getMergedPolicy(messageOutPolicyList = new ArrayList((axisOutMessage = axisOperation.getMessage("Out")).getPolicySubject().getAttachedPolicyComponents()), (AxisDescription)axisOutMessage)) != null) {
                this.addPolicyElement(policyElements, messageOutPolicy, 5);
                operationElement.addAttribute("messageOutPolicyUuid", messageOutPolicy.getId(), null);
            }
            this.getServiceGroupFilePM().put(serviceGroupId, operationElement, PersistenceUtils.getResourcePath(axisService));
        }
        Map endPointMap = axisService.getEndpoints();
        ArrayList<String> bindingsList = new ArrayList<String>();
        for (Map.Entry o : endPointMap.entrySet()) {
            Map.Entry entry = o;
            AxisBinding currentAxisBinding = ((AxisEndpoint)entry.getValue()).getBinding();
            if (bindingsList.contains(currentAxisBinding.getName().getLocalPart())) continue;
            bindingsList.add(currentAxisBinding.getName().getLocalPart());
            ArrayList bindingPolicyList = new ArrayList(currentAxisBinding.getPolicySubject().getAttachedPolicyComponents());
            Policy bindingPolicy = PolicyUtil.getMergedPolicy(bindingPolicyList, (AxisDescription)currentAxisBinding);
            if (bindingPolicy != null) {
                this.addPolicyElement(policyElements, bindingPolicy, 9);
                this.setResourcePolicyId(axisService.getAxisServiceGroup().getServiceGroupName(), PersistenceUtils.getBindingPath(serviceXPath, currentAxisBinding), bindingPolicy.getId());
            }
            Iterator operations = currentAxisBinding.getChildren();
            while (operations.hasNext()) {
                ArrayList boMessageOutPolicyList;
                Policy boMessageOutPolicy;
                AxisDescription boMessageOut;
                ArrayList boMessageInPolicyList;
                Policy boMessageInPolicy;
                AxisDescription boMessageIn;
                AxisBindingOperation currentOperation = (AxisBindingOperation)operations.next();
                String opPath = PersistenceUtils.getBindingOperationPath(serviceXPath, currentOperation);
                if (!this.getServiceGroupFilePM().elementExists(serviceGroupId, opPath)) continue;
                OMElement bindingOperationElement = (OMElement)this.getServiceGroupFilePM().get(serviceGroupId, opPath);
                ArrayList boPolicyList = new ArrayList(currentOperation.getPolicySubject().getAttachedPolicyComponents());
                Policy boPolicy = PolicyUtil.getMergedPolicy(boPolicyList, (AxisDescription)currentOperation);
                if (boPolicy != null) {
                    this.addPolicyElement(policyElements, boPolicy, 11);
                    OMElement idElement = this.omFactory.createOMElement("policyUUID", null);
                    idElement.setText(boPolicy.getId());
                    bindingOperationElement.addChild((OMNode)idElement);
                }
                if ((boMessageIn = currentOperation.getChild((Object)"In")) != null && (boMessageInPolicy = PolicyUtil.getMergedPolicy(boMessageInPolicyList = new ArrayList(boMessageIn.getPolicySubject().getAttachedPolicyComponents()), (AxisDescription)boMessageIn)) != null) {
                    this.addPolicyElement(policyElements, boMessageInPolicy, 14);
                    bindingOperationElement.addAttribute("messageInPolicyUuid", boMessageInPolicy.getId(), null);
                }
                if ((boMessageOut = currentOperation.getChild((Object)"Out")) != null && (boMessageOutPolicy = PolicyUtil.getMergedPolicy(boMessageOutPolicyList = new ArrayList(boMessageOut.getPolicySubject().getAttachedPolicyComponents()), (AxisDescription)boMessageOut)) != null) {
                    this.addPolicyElement(policyElements, boMessageOutPolicy, 15);
                    bindingOperationElement.addAttribute("messageOutPolicyUuid", boMessageOutPolicy.getId(), null);
                }
                this.getServiceGroupFilePM().put(serviceGroupId, bindingOperationElement, PersistenceUtils.getBindingPath(serviceXPath, currentAxisBinding));
            }
        }
        return policyElements;
    }

    private void setResourcePolicyId(String serviceGroupId, String xpathStr, String policyId) throws PersistenceException {
        if (this.getServiceGroupFilePM().elementExists(serviceGroupId, xpathStr)) {
            OMElement idElement = this.omFactory.createOMElement("policyUUID", null);
            idElement.setText(policyId);
            ((OMElement)this.getServiceGroupFilePM().get(serviceGroupId, xpathStr)).addChild((OMNode)idElement);
        }
    }

    private void addPolicyElement(List<OMElement> policyElements, Policy policy, int policyType) throws Exception {
        OMElement policyWrapperElement = this.omFactory.createOMElement("policy", null);
        policyWrapperElement.addAttribute("policyType", "" + policyType, null);
        if (policy.getId() == null) {
            policy.setId(UUIDGenerator.getUUID());
            OMElement idElement = this.omFactory.createOMElement("policyUUID", null);
            idElement.setText("" + policy.getId());
            policyWrapperElement.addChild((OMNode)idElement);
            OMElement policyElement = PersistenceUtils.createPolicyElement(policy);
            policyWrapperElement.addChild((OMNode)policyElement);
            policyElements.add(policyWrapperElement);
        } else if (PersistenceUtils.getPolicyElementFromList(policy.getId(), policyElements) == null) {
            OMElement policyElement = PersistenceUtils.createPolicyElement(policy);
            OMElement idElement = this.omFactory.createOMElement("policyUUID", null);
            idElement.setText("" + policy.getId());
            policyWrapperElement.addChild((OMNode)idElement);
            policyWrapperElement.addChild((OMNode)policyElement);
            policyElements.add(policyWrapperElement);
        }
    }

    public void persistServicePolicy(String serviceGroupId, Policy policy, String policyUuid, String policyType, String servicePath, String engagementPath) throws Exception {
        boolean transactionStarted;
        if (engagementPath == null) {
            engagementPath = servicePath;
        }
        if (!(transactionStarted = this.getServiceGroupFilePM().isTransactionStarted(serviceGroupId))) {
            this.getServiceGroupFilePM().beginTransaction(serviceGroupId);
        }
        OMFactory omFactory = OMAbstractFactory.getOMFactory();
        OMElement policyWrapperElement = omFactory.createOMElement("policy", null);
        policyWrapperElement.addAttribute("policyType", policyType, null);
        OMElement idElement = omFactory.createOMElement("policyUUID", null);
        idElement.setText("" + policyUuid);
        policyWrapperElement.addChild((OMNode)idElement);
        OMElement policyElementToPersist = PersistenceUtils.createPolicyElement(policy);
        policyWrapperElement.addChild((OMNode)policyElementToPersist);
        if (!this.getServiceGroupFilePM().elementExists(serviceGroupId, servicePath + "/" + "policies")) {
            this.getServiceGroupFilePM().put(serviceGroupId, omFactory.createOMElement("policies", null), serviceGroupId);
        } else {
            String pathToPolicy = servicePath + "/" + "policies" + "/" + "policy" + PersistenceUtils.getXPathTextPredicate("policyUUID", policyUuid);
            if (this.getServiceGroupFilePM().elementExists(serviceGroupId, pathToPolicy)) {
                this.getServiceGroupFilePM().delete(serviceGroupId, pathToPolicy);
            }
        }
        this.getServiceGroupFilePM().put(serviceGroupId, policyWrapperElement, servicePath + "/" + "policies");
        if (!this.getServiceGroupFilePM().elementExists(serviceGroupId, engagementPath + PersistenceUtils.getXPathTextPredicate("policyUUID", policy.getId()))) {
            this.getServiceGroupFilePM().put(serviceGroupId, idElement.cloneOMElement(), engagementPath);
        }
        if (!transactionStarted) {
            this.getServiceGroupFilePM().commitTransaction(serviceGroupId);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Policy is saved in the file system for " + servicePath + policyUuid));
        }
    }
}

