/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.load.balancer.common.domain;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.stratos.load.balancer.common.domain.Port;

public class Member {
    private String serviceName;
    private String clusterId;
    private String memberId;
    private String hostName;
    private Map<Integer, Port> portMap;

    public Member(String serviceName, String clusterId, String memberId, String hostName) {
        this.serviceName = serviceName;
        this.clusterId = clusterId;
        this.memberId = memberId;
        this.hostName = hostName;
        this.portMap = new HashMap<Integer, Port>();
    }

    public String getClusterId() {
        return this.clusterId;
    }

    public String getMemberId() {
        return this.memberId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public Port getPort(int proxy) {
        if (this.portMap.containsKey(proxy)) {
            return this.portMap.get(proxy);
        }
        return null;
    }

    public void addPort(Port port) {
        this.portMap.put(port.getProxy(), port);
    }

    public void addPorts(Collection<Port> ports) {
        for (Port port : ports) {
            this.addPort(port);
        }
    }

    public void removePort(Port port) {
        this.portMap.remove(port.getProxy());
    }

    public boolean portExists(Port port) {
        return this.portMap.containsKey(port.getProxy());
    }

    public Collection getPorts() {
        return this.portMap.values();
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

