/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.haproxy.extension;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.util.CommandUtils;
import org.apache.stratos.haproxy.extension.HAProxyContext;
import org.apache.stratos.load.balancer.common.domain.Cluster;
import org.apache.stratos.load.balancer.common.domain.Member;
import org.apache.stratos.load.balancer.common.domain.Port;
import org.apache.stratos.load.balancer.common.domain.Service;
import org.apache.stratos.load.balancer.common.statistics.LoadBalancerStatisticsReader;
import org.apache.stratos.load.balancer.common.topology.TopologyProvider;

public class HAProxyStatisticsReader
implements LoadBalancerStatisticsReader {
    private static final Log log = LogFactory.getLog(HAProxyStatisticsReader.class);
    private String scriptsPath = HAProxyContext.getInstance().getScriptsPath();
    private String statsSocketFilePath = HAProxyContext.getInstance().getStatsSocketFilePath();
    private TopologyProvider topologyProvider;
    private String clusterInstanceId;

    public HAProxyStatisticsReader(TopologyProvider topologyProvider) {
        this.topologyProvider = topologyProvider;
        this.clusterInstanceId = System.getProperty("cluster.instance.id", "not-defined");
    }

    public String getClusterInstanceId() {
        return this.clusterInstanceId;
    }

    public int getInFlightRequestCount(String clusterId) {
        for (Service service : this.topologyProvider.getTopology().getServices()) {
            for (Cluster cluster : service.getClusters()) {
                if (!cluster.getClusterId().equals(clusterId)) continue;
                int totalWeight = 0;
                if (service.getPorts() == null || service.getPorts().size() == 0) {
                    throw new RuntimeException(String.format("No ports found in service: %s", service.getServiceName()));
                }
                for (Port port : service.getPorts()) {
                    for (String hostname : cluster.getHostNames()) {
                        String backendId = hostname + "-http-members";
                        for (Member member : cluster.getMembers()) {
                            String command = String.format("%s/get-weight.sh %s %s %s", this.scriptsPath, backendId, member.getMemberId(), this.statsSocketFilePath);
                            try {
                                String[] array;
                                String output = CommandUtils.executeCommand((String)command);
                                if (output == null || output.length() <= 0 || (array = output.split(" ")) == null || array.length <= 0) continue;
                                int weight = Integer.parseInt(array[0]);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)String.format("Member weight found: [cluster] %s [member] %s [weight] %d", member.getClusterId(), member.getMemberId(), weight));
                                }
                                totalWeight += weight;
                            }
                            catch (IOException e) {
                                if (!log.isErrorEnabled()) continue;
                                log.error((Object)e);
                            }
                        }
                    }
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Cluster weight found: [cluster] %s [weight] %d", cluster.getClusterId(), totalWeight));
                }
                return totalWeight;
            }
        }
        return 0;
    }
}

