/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.binding;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.compass.core.Property;
import org.compass.core.config.CommonMetaDataLookup;
import org.compass.core.config.CompassConfigurable;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.binding.AbstractXmlMappingBinding;
import org.compass.core.converter.mapping.osem.MetaDataFormatDelegateConverter;
import org.compass.core.engine.naming.StaticPropertyPath;
import org.compass.core.engine.subindex.ConstantSubIndexHash;
import org.compass.core.engine.subindex.SubIndexHash;
import org.compass.core.mapping.AbstractResourceMapping;
import org.compass.core.mapping.AliasMapping;
import org.compass.core.mapping.CascadeMapping;
import org.compass.core.mapping.CompassMapping;
import org.compass.core.mapping.ContractMapping;
import org.compass.core.mapping.Mapping;
import org.compass.core.mapping.MappingException;
import org.compass.core.mapping.ResourcePropertyMapping;
import org.compass.core.mapping.SpellCheckType;
import org.compass.core.mapping.internal.DefaultAllMapping;
import org.compass.core.mapping.internal.InternalResourceMapping;
import org.compass.core.mapping.internal.InternalResourcePropertyMapping;
import org.compass.core.mapping.osem.ClassBoostPropertyMapping;
import org.compass.core.mapping.osem.ClassIdPropertyMapping;
import org.compass.core.mapping.osem.ClassMapping;
import org.compass.core.mapping.osem.ClassPropertyAnalyzerController;
import org.compass.core.mapping.osem.ClassPropertyMapping;
import org.compass.core.mapping.osem.ClassPropertyMetaDataMapping;
import org.compass.core.mapping.osem.ComponentMapping;
import org.compass.core.mapping.osem.ConstantMetaDataMapping;
import org.compass.core.mapping.osem.DynamicMetaDataMapping;
import org.compass.core.mapping.osem.IdComponentMapping;
import org.compass.core.mapping.osem.ParentMapping;
import org.compass.core.mapping.osem.PlainCascadeMapping;
import org.compass.core.mapping.osem.ReferenceMapping;
import org.compass.core.mapping.rsem.RawBoostPropertyMapping;
import org.compass.core.mapping.rsem.RawResourceMapping;
import org.compass.core.mapping.rsem.RawResourcePropertyAnalyzerController;
import org.compass.core.mapping.rsem.RawResourcePropertyIdMapping;
import org.compass.core.mapping.rsem.RawResourcePropertyMapping;
import org.compass.core.mapping.xsem.XmlBoostPropertyMapping;
import org.compass.core.mapping.xsem.XmlContentMapping;
import org.compass.core.mapping.xsem.XmlIdMapping;
import org.compass.core.mapping.xsem.XmlObjectMapping;
import org.compass.core.mapping.xsem.XmlPropertyAnalyzerController;
import org.compass.core.mapping.xsem.XmlPropertyMapping;
import org.compass.core.metadata.Alias;
import org.compass.core.metadata.CompassMetaData;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.DTDEntityResolver;
import org.compass.core.util.StringUtils;
import org.compass.core.util.config.ConfigurationHelper;
import org.xml.sax.EntityResolver;

public class XmlMappingBinding
extends AbstractXmlMappingBinding {
    public static final Log log = LogFactory.getLog(XmlMappingBinding.class);
    private CommonMetaDataLookup valueLookup;

    public void setUpBinding(CompassMapping mapping, CompassMetaData metaData, CompassSettings settings) {
        super.setUpBinding(mapping, metaData, settings);
        this.valueLookup = new CommonMetaDataLookup(metaData);
    }

    protected EntityResolver doGetEntityResolver() {
        return new DTDEntityResolver();
    }

    public String[] getSuffixes() {
        return new String[]{".cpm.xml"};
    }

    protected boolean doAddConfiguration(ConfigurationHelper doc) throws ConfigurationException, MappingException {
        ConfigurationHelper[] xmlObjectArr;
        ConfigurationHelper[] resourceArr;
        ConfigurationHelper[] classArr;
        ConfigurationHelper[] resourceContractArr;
        ConfigurationHelper[] contractArr;
        if (!doc.getName().equals("compass-core-mapping")) {
            return false;
        }
        String defaultPackage = doc.getAttribute("package", null);
        defaultPackage = defaultPackage != null ? defaultPackage + "." : "";
        for (ConfigurationHelper aContractArr : contractArr = doc.getChildren("contract")) {
            ContractMapping contractMapping = new ContractMapping();
            this.bindContract(aContractArr, contractMapping);
            this.mapping.addMapping(contractMapping);
        }
        for (ConfigurationHelper aResourceContractArr : resourceContractArr = doc.getChildren("resource-contract")) {
            ContractMapping contractMapping = new ContractMapping();
            this.bindResourceContract(aResourceContractArr, contractMapping);
            this.mapping.addMapping(contractMapping);
        }
        for (ConfigurationHelper classConf : classArr = doc.getChildren("class")) {
            ClassMapping classMapping;
            String alias = classConf.getAttribute("alias");
            boolean newClassMapping = false;
            AliasMapping aliasMapping = this.mapping.getAliasMapping(alias);
            if (aliasMapping != null) {
                if (!(aliasMapping instanceof ClassMapping)) {
                    throw new MappingException("Defined searchable annotation on a class with alias [" + alias + "] but it" + " not of type class mapping");
                }
                classMapping = (ClassMapping)aliasMapping;
            } else {
                classMapping = new ClassMapping();
                newClassMapping = true;
            }
            this.bindClass(classConf, classMapping, defaultPackage);
            if (!newClassMapping) continue;
            this.mapping.addMapping(classMapping);
        }
        for (ConfigurationHelper aResourceArr : resourceArr = doc.getChildren("resource")) {
            RawResourceMapping rawResourceMapping = new RawResourceMapping();
            this.bindResource(aResourceArr, rawResourceMapping);
            this.mapping.addMapping(rawResourceMapping);
        }
        for (ConfigurationHelper aXmlObjectArr : xmlObjectArr = doc.getChildren("xml-object")) {
            XmlObjectMapping xmlObjectMapping = new XmlObjectMapping();
            this.bindXmlObject(aXmlObjectArr, xmlObjectMapping);
            this.mapping.addMapping(xmlObjectMapping);
        }
        return true;
    }

    private void bindXmlObject(ConfigurationHelper xmlObjectConf, XmlObjectMapping xmlObjectMapping) throws ConfigurationException {
        String aliasValue = xmlObjectConf.getAttribute("alias");
        Alias alias = this.valueLookup.lookupAlias(aliasValue);
        if (alias == null) {
            xmlObjectMapping.setAlias(aliasValue);
        } else {
            xmlObjectMapping.setAlias(alias.getName());
        }
        this.bindSubIndexHash(xmlObjectConf, xmlObjectMapping);
        this.bindExtends(xmlObjectConf, xmlObjectMapping);
        this.bindAll(xmlObjectConf, xmlObjectMapping);
        this.bindSpellCheck(xmlObjectConf, xmlObjectMapping);
        String analyzer = xmlObjectConf.getAttribute("analyzer", null);
        xmlObjectMapping.setAnalyzer(analyzer);
        xmlObjectMapping.setRoot(true);
        xmlObjectMapping.setBoost(XmlMappingBinding.getBoost(xmlObjectConf));
        xmlObjectMapping.setXPath(xmlObjectConf.getAttribute("xpath", null));
        this.bindConverter(xmlObjectConf, xmlObjectMapping);
        this.bindXmlObjectChildren(xmlObjectConf, xmlObjectMapping);
    }

    private void bindXmlObjectChildren(ConfigurationHelper resourceConf, AliasMapping resourceMapping) {
        ConfigurationHelper boostConf;
        ConfigurationHelper analyzerConf;
        ConfigurationHelper[] properties;
        ConfigurationHelper[] ids;
        for (ConfigurationHelper id : ids = resourceConf.getChildren("xml-id")) {
            XmlIdMapping xmlIdMapping = new XmlIdMapping();
            this.bindXmlProperty(id, xmlIdMapping, resourceMapping);
            resourceMapping.addMapping(xmlIdMapping);
        }
        for (ConfigurationHelper property : properties = resourceConf.getChildren("xml-property")) {
            XmlPropertyMapping xmlPropertyMapping = new XmlPropertyMapping();
            this.bindXmlProperty(property, xmlPropertyMapping, resourceMapping);
            resourceMapping.addMapping(xmlPropertyMapping);
        }
        ConfigurationHelper xmlContentConf = resourceConf.getChild("xml-content", false);
        if (xmlContentConf != null) {
            XmlContentMapping xmlContentMapping = new XmlContentMapping();
            this.bindXmlContent(xmlContentConf, xmlContentMapping);
            resourceMapping.addMapping(xmlContentMapping);
        }
        if ((analyzerConf = resourceConf.getChild("xml-analyzer", false)) != null) {
            XmlPropertyAnalyzerController analyzerController = new XmlPropertyAnalyzerController();
            this.bindXmlProperty(analyzerConf, analyzerController, resourceMapping);
            analyzerController.setNullAnalyzer(analyzerConf.getAttribute("null-analyzer", null));
            resourceMapping.addMapping(analyzerController);
        }
        if ((boostConf = resourceConf.getChild("xml-boost", false)) != null) {
            XmlBoostPropertyMapping boostPropertyMapping = new XmlBoostPropertyMapping();
            this.bindXmlProperty(boostConf, boostPropertyMapping, resourceMapping);
            String defaultBoost = boostConf.getAttribute("default", null);
            if (defaultBoost != null) {
                boostPropertyMapping.setDefaultBoost(Float.parseFloat(defaultBoost));
            }
            resourceMapping.addMapping(boostPropertyMapping);
        }
    }

    private void bindXmlContent(ConfigurationHelper xmlContentConf, XmlContentMapping xmlContentMapping) {
        String name = xmlContentConf.getAttribute("name", null);
        if (name != null) {
            name = this.valueLookup.lookupMetaDataName(name);
        }
        xmlContentMapping.setName(name);
        xmlContentMapping.setPath(new StaticPropertyPath(name));
        this.bindConverter(xmlContentConf, xmlContentMapping);
        String storeType = xmlContentConf.getAttribute("store", null);
        xmlContentMapping.setStore(Property.Store.fromString(storeType));
        xmlContentMapping.setInternal(true);
    }

    private void bindXmlProperty(ConfigurationHelper xmlPropConf, XmlPropertyMapping xmlPropertyMapping, AliasMapping aliasMapping) {
        String name = xmlPropConf.getAttribute("name", null);
        if (name != null) {
            name = this.valueLookup.lookupMetaDataName(name);
        }
        xmlPropertyMapping.setBoost(XmlMappingBinding.getBoost(xmlPropConf));
        xmlPropertyMapping.setName(name);
        xmlPropertyMapping.setPath(name == null ? null : new StaticPropertyPath(name));
        this.bindConverter(xmlPropConf, xmlPropertyMapping);
        this.bindResourcePropertyMapping(xmlPropConf, xmlPropertyMapping, aliasMapping);
        boolean override = xmlPropConf.getAttributeAsBoolean("override", true);
        xmlPropertyMapping.setOverrideByName(override);
        xmlPropertyMapping.setXPath(xmlPropConf.getAttribute("xpath"));
        xmlPropertyMapping.setValueConverterName(xmlPropConf.getAttribute("value-converter", null));
        this.bindSpellCheck(xmlPropConf, xmlPropertyMapping);
    }

    private void bindResourceContract(ConfigurationHelper contractConf, ContractMapping contractMapping) throws ConfigurationException {
        String aliasValue = contractConf.getAttribute("alias");
        Alias alias = this.valueLookup.lookupAlias(aliasValue);
        if (alias == null) {
            contractMapping.setAlias(aliasValue);
        } else {
            contractMapping.setAlias(alias.getName());
        }
        this.bindExtends(contractConf, contractMapping);
        this.bindResourceMappingChildren(contractConf, contractMapping);
    }

    private void bindResource(ConfigurationHelper resourceConf, RawResourceMapping rawResourceMapping) throws ConfigurationException {
        String aliasValue = resourceConf.getAttribute("alias");
        Alias alias = this.valueLookup.lookupAlias(aliasValue);
        if (alias == null) {
            rawResourceMapping.setAlias(aliasValue);
        } else {
            rawResourceMapping.setAlias(alias.getName());
        }
        this.bindSubIndexHash(resourceConf, rawResourceMapping);
        this.bindExtends(resourceConf, rawResourceMapping);
        String analyzer = resourceConf.getAttribute("analyzer", null);
        rawResourceMapping.setAnalyzer(analyzer);
        this.bindAll(resourceConf, rawResourceMapping);
        this.bindSpellCheck(resourceConf, rawResourceMapping);
        rawResourceMapping.setRoot(true);
        rawResourceMapping.setBoost(XmlMappingBinding.getBoost(resourceConf));
        this.bindResourceMappingChildren(resourceConf, rawResourceMapping);
    }

    private void bindResourceMappingChildren(ConfigurationHelper resourceConf, AliasMapping resourceMapping) {
        ConfigurationHelper boostConf;
        ConfigurationHelper[] properties;
        ConfigurationHelper[] ids;
        for (ConfigurationHelper id : ids = resourceConf.getChildren("resource-id")) {
            RawResourcePropertyIdMapping rawIdPropertyMapping = new RawResourcePropertyIdMapping();
            this.bindResourceProperty(id, rawIdPropertyMapping, resourceMapping);
            resourceMapping.addMapping(rawIdPropertyMapping);
        }
        for (ConfigurationHelper property : properties = resourceConf.getChildren("resource-property")) {
            RawResourcePropertyMapping rawPropertyMapping = new RawResourcePropertyMapping();
            this.bindResourceProperty(property, rawPropertyMapping, resourceMapping);
            resourceMapping.addMapping(rawPropertyMapping);
        }
        ConfigurationHelper analyzerConf = resourceConf.getChild("resource-analyzer", false);
        if (analyzerConf != null) {
            RawResourcePropertyAnalyzerController analyzerController = new RawResourcePropertyAnalyzerController();
            this.bindResourceProperty(analyzerConf, analyzerController, resourceMapping);
            analyzerController.setNullAnalyzer(analyzerConf.getAttribute("null-analyzer", null));
            resourceMapping.addMapping(analyzerController);
        }
        if ((boostConf = resourceConf.getChild("resource-boost", false)) != null) {
            RawBoostPropertyMapping boostPropertyMapping = new RawBoostPropertyMapping();
            this.bindResourceProperty(boostConf, boostPropertyMapping, resourceMapping);
            String defaultBoost = boostConf.getAttribute("default", null);
            if (defaultBoost != null) {
                boostPropertyMapping.setDefaultBoost(Float.parseFloat(defaultBoost));
            }
            resourceMapping.addMapping(boostPropertyMapping);
        }
    }

    private void bindResourceProperty(ConfigurationHelper resourcePropConf, RawResourcePropertyMapping propertyMapping, AliasMapping aliasMapping) {
        String name = this.valueLookup.lookupMetaDataName(resourcePropConf.getAttribute("name"));
        propertyMapping.setBoost(XmlMappingBinding.getBoost(resourcePropConf));
        propertyMapping.setName(name);
        propertyMapping.setPath(new StaticPropertyPath(name));
        this.bindConverter(resourcePropConf, propertyMapping);
        boolean override = resourcePropConf.getAttributeAsBoolean("override", true);
        propertyMapping.setOverrideByName(override);
        this.bindResourcePropertyMapping(resourcePropConf, propertyMapping, aliasMapping);
        this.bindSpellCheck(resourcePropConf, propertyMapping);
    }

    private void bindContract(ConfigurationHelper contractConf, ContractMapping contractMapping) throws ConfigurationException {
        String aliasValue = contractConf.getAttribute("alias");
        Alias alias = this.valueLookup.lookupAlias(aliasValue);
        if (alias == null) {
            contractMapping.setAlias(aliasValue);
        } else {
            contractMapping.setAlias(alias.getName());
        }
        this.bindExtends(contractConf, contractMapping);
        this.bindClassMappingChildren(contractConf, contractMapping);
    }

    private void bindClass(ConfigurationHelper classConf, ClassMapping classMapping, String defaultPackage) throws ConfigurationException {
        String polyClassName;
        String className = classConf.getAttribute("name");
        classMapping.setName(defaultPackage + className);
        try {
            Class clazz = ClassUtils.forName(classMapping.getName(), this.settings.getClassLoader());
            classMapping.setClazz(clazz);
        }
        catch (ClassNotFoundException e) {
            throw new ConfigurationException("Failed to find class [" + classMapping.getName() + "] and class loader [" + this.settings.getClassLoader() + "]");
        }
        String aliasValue = classConf.getAttribute("alias");
        Alias alias = this.valueLookup.lookupAlias(aliasValue);
        if (alias == null) {
            classMapping.setAlias(aliasValue);
        } else {
            classMapping.setAlias(alias.getName());
        }
        this.bindExtends(classConf, classMapping);
        this.bindSubIndexHash(classConf, classMapping);
        String analyzer = classConf.getAttribute("analyzer", null);
        classMapping.setAnalyzer(analyzer);
        this.bindAll(classConf, classMapping);
        this.bindSpellCheck(classConf, classMapping);
        boolean poly = classConf.getAttributeAsBoolean("poly", false);
        classMapping.setPoly(poly);
        String managedId = classConf.getAttribute("managed-id", null);
        if (managedId != null) {
            classMapping.setManagedId(ClassPropertyMapping.ManagedId.fromString(managedId));
        }
        if ((polyClassName = classConf.getAttribute("poly-class", null)) != null) {
            try {
                classMapping.setPolyClass(ClassUtils.forName(polyClassName, this.settings.getClassLoader()));
            }
            catch (ClassNotFoundException e) {
                throw new ConfigurationException("Failed to load polyClass [" + polyClassName + "]", e);
            }
        }
        boolean root = classConf.getAttributeAsBoolean("root", true);
        classMapping.setRoot(root);
        classMapping.setBoost(XmlMappingBinding.getBoost(classConf));
        String supportUnmarshall = classConf.getAttribute("support-unmarshall", null);
        if (supportUnmarshall != null) {
            if (supportUnmarshall.equalsIgnoreCase("true")) {
                classMapping.setSupportUnmarshall(true);
            } else {
                classMapping.setSupportUnmarshall(false);
            }
        }
        this.bindConverter(classConf, classMapping);
        this.bindClassMappingChildren(classConf, classMapping);
    }

    private void bindClassMappingChildren(ConfigurationHelper classConf, AliasMapping classMapping) {
        ConfigurationHelper[] cascadeConfs;
        ConfigurationHelper[] dynamicConfs;
        ConfigurationHelper boostConf;
        ConfigurationHelper analyzerConf;
        ConfigurationHelper[] constants;
        ConfigurationHelper[] references;
        ConfigurationHelper[] components;
        ConfigurationHelper[] properties;
        ConfigurationHelper[] idComponents;
        ConfigurationHelper[] ids;
        for (ConfigurationHelper id : ids = classConf.getChildren("id")) {
            ClassIdPropertyMapping idMapping = new ClassIdPropertyMapping();
            this.bindClassProperty(id, classMapping, idMapping);
            classMapping.addMapping(idMapping);
        }
        for (ConfigurationHelper idComponent : idComponents = classConf.getChildren("id-component")) {
            IdComponentMapping idMapping = new IdComponentMapping();
            this.bindComponent(idComponent, classMapping, idMapping);
            classMapping.addMapping(idMapping);
        }
        for (ConfigurationHelper property : properties = classConf.getChildren("property")) {
            ClassPropertyMapping classPropertyMapping = new ClassPropertyMapping();
            this.bindClassProperty(property, classMapping, classPropertyMapping);
            classMapping.addMapping(classPropertyMapping);
        }
        for (ConfigurationHelper component : components = classConf.getChildren("component")) {
            ComponentMapping compMapping = new ComponentMapping();
            this.bindComponent(component, classMapping, compMapping);
            classMapping.addMapping(compMapping);
        }
        for (ConfigurationHelper reference : references = classConf.getChildren("reference")) {
            ReferenceMapping referenceMapping = new ReferenceMapping();
            this.bindReference(reference, classMapping, referenceMapping);
            classMapping.addMapping(referenceMapping);
        }
        for (ConfigurationHelper constant : constants = classConf.getChildren("constant")) {
            ConstantMetaDataMapping constantMapping = new ConstantMetaDataMapping();
            this.bindConstant(constant, classMapping, constantMapping);
            classMapping.addMapping(constantMapping);
        }
        ConfigurationHelper parentConf = classConf.getChild("parent", false);
        if (parentConf != null) {
            ParentMapping parentMapping = new ParentMapping();
            this.bindParent(parentConf, classMapping, parentMapping);
            classMapping.addMapping(parentMapping);
        }
        if ((analyzerConf = classConf.getChild("analyzer", false)) != null) {
            ClassPropertyAnalyzerController analyzerController = new ClassPropertyAnalyzerController();
            this.bindClassProperty(analyzerConf, classMapping, analyzerController);
            analyzerController.setNullAnalyzer(analyzerConf.getAttribute("null-analyzer", null));
            classMapping.addMapping(analyzerController);
        }
        if ((boostConf = classConf.getChild("boost", false)) != null) {
            ClassBoostPropertyMapping boostPropertyMapping = new ClassBoostPropertyMapping();
            this.bindClassProperty(boostConf, classMapping, boostPropertyMapping);
            String defaultBoost = boostConf.getAttribute("default", null);
            if (defaultBoost != null) {
                boostPropertyMapping.setDefaultBoost(Float.parseFloat(defaultBoost));
            }
            classMapping.addMapping(boostPropertyMapping);
        }
        for (ConfigurationHelper dynamicConf : dynamicConfs = classConf.getChildren("dynamic-meta-data")) {
            DynamicMetaDataMapping dynamicMetaDataMapping = new DynamicMetaDataMapping();
            this.bindDynamicMetaData(dynamicConf, classMapping, dynamicMetaDataMapping);
            classMapping.addMapping(dynamicMetaDataMapping);
        }
        for (ConfigurationHelper cascadeConf : cascadeConfs = classConf.getChildren("cascade")) {
            PlainCascadeMapping cascadeMapping = new PlainCascadeMapping();
            this.bindPlainCascading(cascadeConf, cascadeMapping);
            classMapping.addMapping(cascadeMapping);
        }
    }

    private void bindPlainCascading(ConfigurationHelper conf, PlainCascadeMapping cascadeMapping) {
        String name = conf.getAttribute("name");
        cascadeMapping.setName(name);
        cascadeMapping.setAccessor(conf.getAttribute("accessor", null));
        cascadeMapping.setPropertyName(name);
        this.bindConverter(conf, cascadeMapping);
        this.bindCascade(conf, cascadeMapping, "all");
    }

    private void bindDynamicMetaData(ConfigurationHelper dynamicConf, AliasMapping aliasMapping, DynamicMetaDataMapping dynamicMetaDataMapping) {
        String name = this.valueLookup.lookupMetaDataName(dynamicConf.getAttribute("name"));
        dynamicMetaDataMapping.setBoost(XmlMappingBinding.getBoost(dynamicConf));
        dynamicMetaDataMapping.setName(name);
        dynamicMetaDataMapping.setPath(new StaticPropertyPath(name));
        dynamicMetaDataMapping.setExpression(dynamicConf.getValue().trim());
        dynamicMetaDataMapping.setFormat(dynamicConf.getAttribute("format", null));
        String type = dynamicConf.getAttribute("type", null);
        if (type != null) {
            try {
                dynamicMetaDataMapping.setType(ClassUtils.forName(type, this.settings.getClassLoader()));
            }
            catch (ClassNotFoundException e) {
                throw new MappingException("Failed to find class [" + type + "]", e);
            }
        }
        this.bindConverter(dynamicConf, dynamicMetaDataMapping);
        this.bindSpellCheck(dynamicConf, dynamicMetaDataMapping);
        this.bindResourcePropertyMapping(dynamicConf, dynamicMetaDataMapping, aliasMapping);
        boolean override = dynamicConf.getAttributeAsBoolean("override", true);
        dynamicMetaDataMapping.setOverrideByName(override);
    }

    private void bindReference(ConfigurationHelper referenceConf, AliasMapping aliasMapping, ReferenceMapping referenceMapping) {
        String name = referenceConf.getAttribute("name");
        referenceMapping.setName(name);
        String refAlias = referenceConf.getAttribute("ref-alias", null);
        referenceMapping.setRefAliases(this.getAliases(refAlias));
        referenceMapping.setDefinedInAlias(aliasMapping.getAlias());
        String refCompAlias = referenceConf.getAttribute("ref-comp-alias", null);
        if (refCompAlias != null) {
            referenceMapping.setRefCompAlias(this.valueLookup.lookupAliasName(refCompAlias));
        }
        this.bindConverter(referenceConf, referenceMapping);
        referenceMapping.setAccessor(referenceConf.getAttribute("accessor", null));
        referenceMapping.setPropertyName(name);
        this.bindCascade(referenceConf, referenceMapping, null);
    }

    private void bindComponent(ConfigurationHelper componentConf, AliasMapping aliasMapping, ComponentMapping compMapping) {
        String name = componentConf.getAttribute("name");
        compMapping.setName(name);
        String refAlias = componentConf.getAttribute("ref-alias", null);
        compMapping.setRefAliases(this.getAliases(refAlias));
        compMapping.setDefinedInAlias(aliasMapping.getAlias());
        int maxDepth = componentConf.getAttributeAsInteger("max-depth", 1);
        compMapping.setMaxDepth(maxDepth);
        this.bindConverter(componentConf, compMapping);
        compMapping.setAccessor(componentConf.getAttribute("accessor", null));
        compMapping.setPropertyName(name);
        boolean override = componentConf.getAttributeAsBoolean("override", true);
        compMapping.setOverrideByName(override);
        this.bindCascade(componentConf, compMapping, null);
    }

    private void bindCascade(ConfigurationHelper refConf, CascadeMapping cascadeMapping, String defaultValue) {
        String commaSeparatedCascades = refConf.getAttribute("cascade", defaultValue);
        if (commaSeparatedCascades == null) {
            return;
        }
        if ("none".equals(commaSeparatedCascades)) {
            return;
        }
        ArrayList<CascadeMapping.Cascade> cascades = new ArrayList<CascadeMapping.Cascade>();
        StringTokenizer st = new StringTokenizer(commaSeparatedCascades, ",");
        while (st.hasMoreTokens()) {
            String cascade = st.nextToken().trim();
            cascades.add(CascadeMapping.Cascade.fromString(cascade));
        }
        if (cascades.size() > 0) {
            cascadeMapping.setCascades(cascades.toArray(new CascadeMapping.Cascade[cascades.size()]));
        }
    }

    private void bindParent(ConfigurationHelper parentConf, AliasMapping aliasMapping, ParentMapping parentMapping) {
        String name = parentConf.getAttribute("name");
        parentMapping.setName(name);
        this.bindConverter(parentConf, parentMapping);
        parentMapping.setAccessor(parentConf.getAttribute("accessor", null));
        parentMapping.setPropertyName(name);
        parentMapping.setDefinedInAlias(aliasMapping.getAlias());
        this.bindCascade(parentConf, parentMapping, null);
    }

    private void bindClassProperty(ConfigurationHelper classPropertyConf, AliasMapping aliasMapping, ClassPropertyMapping classPropertyMapping) {
        ConfigurationHelper[] metadatas;
        String managedIdIndex;
        String name = classPropertyConf.getAttribute("name");
        classPropertyMapping.setName(name);
        String sClass = classPropertyConf.getAttribute("class", null);
        classPropertyMapping.setClassName(sClass);
        classPropertyMapping.setDefinedInAlias(aliasMapping.getAlias());
        classPropertyMapping.setBoost(XmlMappingBinding.getBoost(classPropertyConf));
        classPropertyMapping.setColClassName(classPropertyConf.getAttribute("col-class", null));
        classPropertyMapping.setAccessor(classPropertyConf.getAttribute("accessor", null));
        classPropertyMapping.setPropertyName(name);
        classPropertyMapping.setAnalyzer(classPropertyConf.getAttribute("analyzer", aliasMapping.getAnalyzer()));
        String excludeFromAll = classPropertyConf.getAttribute("exclude-from-all", "no");
        classPropertyMapping.setExcludeFromAll(ResourcePropertyMapping.ExcludeFromAllType.fromString(excludeFromAll));
        String managedId = classPropertyConf.getAttribute("managed-id", null);
        if (managedId != null) {
            classPropertyMapping.setManagedId(ClassPropertyMapping.ManagedId.fromString(managedId));
        }
        if ((managedIdIndex = classPropertyConf.getAttribute("managed-id-index", null)) != null) {
            classPropertyMapping.setManagedIdIndex(Property.Index.fromString(managedIdIndex));
        }
        classPropertyMapping.setManagedIdConverterName(classPropertyConf.getAttribute("managed-id-converter", null));
        boolean override = classPropertyConf.getAttributeAsBoolean("override", true);
        classPropertyMapping.setOverrideByName(override);
        this.bindConverter(classPropertyConf, classPropertyMapping);
        for (ConfigurationHelper metadata : metadatas = classPropertyConf.getChildren("meta-data")) {
            ClassPropertyMetaDataMapping mdMapping = new ClassPropertyMetaDataMapping();
            this.bindMetaData(metadata, aliasMapping, classPropertyMapping, mdMapping);
            classPropertyMapping.addMapping(mdMapping);
        }
    }

    private void bindConstant(ConfigurationHelper constantConf, AliasMapping classMapping, ConstantMetaDataMapping constantMapping) {
        ConfigurationHelper[] values;
        ConfigurationHelper metadataConf = constantConf.getChild("meta-data");
        if (!StringUtils.hasText(metadataConf.getValue())) {
            throw new MappingException("Alias mapping [" + classMapping.getAlias() + "] has a constant mapping with an empty meta-data value");
        }
        String metaDataValue = metadataConf.getValue().trim();
        constantMapping.setName(this.valueLookup.lookupMetaDataName(metaDataValue));
        String excludeFromAll = constantConf.getAttribute("exclude-from-all", "no");
        constantMapping.setExcludeFromAll(ResourcePropertyMapping.ExcludeFromAllType.fromString(excludeFromAll));
        this.bindResourcePropertyMapping(metadataConf, constantMapping, classMapping, 1.0f, constantMapping.getExcludeFromAll(), classMapping.getAnalyzer());
        this.bindSpellCheck(constantConf, constantMapping);
        boolean override = constantConf.getAttributeAsBoolean("override", true);
        constantMapping.setOverrideByName(override);
        for (ConfigurationHelper value : values = constantConf.getChildren("meta-data-value")) {
            String metaDataValueValue = value.getValue().trim();
            constantMapping.addMetaDataValue(this.valueLookup.lookupMetaDataValue(metaDataValueValue));
        }
    }

    private void bindMetaData(ConfigurationHelper metadataConf, AliasMapping aliasMapping, ClassPropertyMapping classPropertyMapping, ClassPropertyMetaDataMapping mdMapping) {
        if (!StringUtils.hasText(metadataConf.getValue())) {
            throw new MappingException("Alias mapping [" + aliasMapping.getAlias() + "] and property [" + classPropertyMapping.getName() + "] has a meta-data mapping with no value");
        }
        String name = this.valueLookup.lookupMetaDataName(metadataConf.getValue().trim());
        mdMapping.setName(name);
        mdMapping.setPath(new StaticPropertyPath(name));
        mdMapping.setAccessor(classPropertyMapping.getAccessor());
        mdMapping.setPropertyName(classPropertyMapping.getPropertyName());
        this.bindConverter(metadataConf, mdMapping);
        String format = metadataConf.getAttribute("format", null);
        if (mdMapping.getConverter() == null) {
            if (format == null) {
                format = this.valueLookup.lookupMetaDataFormat(metadataConf.getValue().trim());
            }
            if (format != null) {
                mdMapping.setConverter(new MetaDataFormatDelegateConverter(format));
            }
        } else if (format != null) {
            throw new ConfigurationException("Both converter and format are set for property [" + classPropertyMapping.getName() + "], you should choose one or the other (since converter will" + "not use the format defined)");
        }
        this.bindResourcePropertyMapping(metadataConf, mdMapping, aliasMapping, classPropertyMapping.getBoost(), classPropertyMapping.getExcludeFromAll(), classPropertyMapping.getAnalyzer());
        this.bindSpellCheck(metadataConf, mdMapping);
    }

    private void bindExtends(ConfigurationHelper conf, AliasMapping mapping) throws ConfigurationException {
        String extendsAliases = conf.getAttribute("extends", null);
        if (extendsAliases != null) {
            mapping.setExtendedAliases(this.getAliases(extendsAliases));
        }
    }

    private String[] getAliases(String commaSeparatedAliases) {
        if (commaSeparatedAliases == null) {
            return null;
        }
        ArrayList<String> aliases = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(commaSeparatedAliases, ",");
        while (st.hasMoreTokens()) {
            String extendedAlias = st.nextToken().trim();
            Alias alias = this.valueLookup.lookupAlias(extendedAlias);
            if (alias == null) {
                aliases.add(extendedAlias);
                continue;
            }
            aliases.add(alias.getName());
        }
        return aliases.toArray(new String[aliases.size()]);
    }

    private void bindConverter(ConfigurationHelper conf, Mapping mapping) {
        String converterName = conf.getAttribute("converter", null);
        mapping.setConverterName(converterName);
    }

    private void bindAll(ConfigurationHelper conf, AbstractResourceMapping resourceMapping) {
        ConfigurationHelper allConf = conf.getChild("all", false);
        DefaultAllMapping allMapping = new DefaultAllMapping();
        if (allConf != null) {
            String sExcludeAlias;
            String sOmitNorms;
            String termVectorType;
            String sAllSupported = allConf.getAttribute("enable", null);
            if (sAllSupported != null) {
                allMapping.setSupported(sAllSupported.equalsIgnoreCase("true"));
            }
            if ((termVectorType = allConf.getAttribute("term-vector", null)) != null) {
                allMapping.setTermVector(Property.TermVector.fromString(termVectorType));
            }
            if ((sOmitNorms = allConf.getAttribute("omit-norms", null)) != null) {
                allMapping.setOmitNorms(sOmitNorms.equalsIgnoreCase("true"));
            }
            if ((sExcludeAlias = allConf.getAttribute("exclude-alias", null)) != null) {
                allMapping.setExcludeAlias(sExcludeAlias.equalsIgnoreCase("true"));
            }
            allMapping.setProperty(allConf.getAttribute("name", null));
            allMapping.setSpellCheck(SpellCheckType.fromString(allConf.getAttribute("spell-check", "na")));
        }
        resourceMapping.setAllMapping(allMapping);
    }

    private void bindSpellCheck(ConfigurationHelper conf, InternalResourcePropertyMapping mapping) {
        mapping.setSpellCheck(SpellCheckType.fromString(conf.getAttribute("spell-check", "na")));
    }

    private void bindSpellCheck(ConfigurationHelper conf, InternalResourceMapping mapping) {
        mapping.setSpellCheck(SpellCheckType.fromString(conf.getAttribute("spell-check", "na")));
    }

    private void bindSubIndexHash(ConfigurationHelper conf, AbstractResourceMapping resourceMapping) {
        SubIndexHash subIndexHash;
        ConfigurationHelper subIndexHashConf = conf.getChild("sub-index-hash", false);
        if (subIndexHashConf == null) {
            String subIndex = conf.getAttribute("sub-index", resourceMapping.getAlias());
            resourceMapping.setSubIndexHash(new ConstantSubIndexHash(subIndex));
            if (log.isTraceEnabled()) {
                log.trace((Object)("Alias [" + resourceMapping.getAlias() + "] is mapped to sub index hash [" + resourceMapping.getSubIndexHash() + "]"));
            }
            return;
        }
        String type = subIndexHashConf.getAttribute("type", null);
        try {
            subIndexHash = (SubIndexHash)ClassUtils.forName(type, this.settings.getClassLoader()).newInstance();
        }
        catch (Exception e) {
            throw new ConfigurationException("Failed to create sub index hash of type [" + type + "]", e);
        }
        CompassSettings settings = this.settings.copy().clear();
        ConfigurationHelper[] settingsConf = subIndexHashConf.getChildren("setting");
        if (subIndexHash instanceof CompassConfigurable) {
            for (ConfigurationHelper aSettingsConf : settingsConf) {
                settings.setSetting(aSettingsConf.getAttribute("name"), aSettingsConf.getAttribute("value"));
            }
            ((CompassConfigurable)((Object)subIndexHash)).configure(settings);
        } else if (settingsConf.length < 0) {
            throw new ConfigurationException("Sub index hash [" + subIndexHash + "] does not implement " + "CompassConfigurable, but settings have been set for it");
        }
        resourceMapping.setSubIndexHash(subIndexHash);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Alias [" + resourceMapping.getAlias() + "] is mapped to sub index hash [" + resourceMapping.getSubIndexHash() + "]"));
        }
    }

    private void bindResourcePropertyMapping(ConfigurationHelper conf, InternalResourcePropertyMapping mapping, AliasMapping aliasMapping) {
        this.bindResourcePropertyMapping(conf, mapping, aliasMapping, 1.0f, ResourcePropertyMapping.ExcludeFromAllType.NO, aliasMapping.getAnalyzer());
    }

    private void bindResourcePropertyMapping(ConfigurationHelper conf, InternalResourcePropertyMapping mapping, AliasMapping aliasMapping, float defaultBoost, ResourcePropertyMapping.ExcludeFromAllType excludeFromAllType, String analyzer) {
        mapping.setBoost(XmlMappingBinding.getBoost(conf, defaultBoost));
        String storeType = conf.getAttribute("store", null);
        mapping.setStore(Property.Store.fromString(storeType));
        String indexType = conf.getAttribute("index", null);
        mapping.setIndex(Property.Index.fromString(indexType));
        String termVectorType = conf.getAttribute("term-vector", null);
        mapping.setTermVector(Property.TermVector.fromString(termVectorType));
        String omitNorms = conf.getAttribute("omit-norms", null);
        if (omitNorms != null) {
            mapping.setOmitNorms(Boolean.valueOf(omitNorms));
        }
        String reverseType = conf.getAttribute("reverse", "no");
        mapping.setReverse(ResourcePropertyMapping.ReverseType.fromString(reverseType));
        mapping.setAnalyzer(conf.getAttribute("analyzer", analyzer));
        mapping.setNullValue(conf.getAttribute("null-value", null));
        String excludeFromAll = conf.getAttribute("exclude-from-all", ResourcePropertyMapping.ExcludeFromAllType.toString(excludeFromAllType));
        mapping.setExcludeFromAll(ResourcePropertyMapping.ExcludeFromAllType.fromString(excludeFromAll));
        mapping.setInternal(false);
    }

    private static float getBoost(ConfigurationHelper conf) {
        return XmlMappingBinding.getBoost(conf, 1.0f);
    }

    private static float getBoost(ConfigurationHelper conf, float defaultBoost) {
        return conf.getAttributeAsFloat("boost", defaultBoost);
    }
}

