/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.Component;
import org.apache.stratos.common.services.ComponentActivationEventListener;
import org.apache.stratos.common.services.ComponentStartUpEventListener;
import org.apache.stratos.common.services.ComponentStartUpSynchronizer;
import org.apache.stratos.common.services.DistributedObjectProvider;
import org.wso2.carbon.core.CarbonConfigurationContextFactory;

public class ComponentStartUpSynchronizerImpl
implements ComponentStartUpSynchronizer {
    private static final Log log = LogFactory.getLog(ComponentStartUpSynchronizerImpl.class);
    private static final String COMPONENT_STATUS_MAP = "stratos.component.status.map";
    private static final String COMPONENT_STARTUP_SYNCHRONIZER_ENABLED = "stratos.component.startup.synchronizer.enabled";
    private static final String COMPONENT_ACTIVATION_CHECK_INTERVAL = "stratos.component.activation.check.interval";
    private static final String COMPONENT_ACTIVATION_TIMEOUT = "stratos.component.activation.timeout";
    private static final long DEFAULT_COMPONENT_ACTIVATION_CHECK_INTERVAL = 1000L;
    private static final long DEFAULT_COMPONENT_ACTIVATION_TIMEOUT = 600000L;
    private Map<Component, Boolean> componentStatusMap;
    private List<ComponentStartUpEventListener> eventListeners;
    private boolean componentStartUpSynchronizerEnabled;
    private long componentActivationCheckInterval;
    private long componentActivationTimeout;

    ComponentStartUpSynchronizerImpl(DistributedObjectProvider distributedObjectProvider) {
        this.componentStatusMap = distributedObjectProvider.getMap(COMPONENT_STATUS_MAP);
        this.eventListeners = new ArrayList<ComponentStartUpEventListener>();
        this.componentStartUpSynchronizerEnabled = Boolean.getBoolean(COMPONENT_STARTUP_SYNCHRONIZER_ENABLED);
        log.info((Object)("Component startup synchronizer enabled: " + this.componentStartUpSynchronizerEnabled));
        this.componentActivationCheckInterval = Long.getLong(COMPONENT_ACTIVATION_CHECK_INTERVAL, 1000L);
        log.info((Object)String.format("Component activation check interval: %s seconds", this.componentActivationCheckInterval / 1000L));
        this.componentActivationTimeout = Long.getLong(COMPONENT_ACTIVATION_TIMEOUT, 600000L);
        log.info((Object)String.format("Component activation timeout: %s seconds", this.componentActivationTimeout / 1000L));
    }

    @Override
    public boolean isEnabled() {
        return this.componentStartUpSynchronizerEnabled;
    }

    @Override
    public void setComponentStatus(Component component, boolean active) {
        this.componentStatusMap.put(component, active);
        if (active) {
            this.notifyComponentActivationEventListeners(component);
            log.info((Object)String.format("%s activated", new Object[]{component}));
        } else {
            log.info((Object)String.format("%s inactivated", new Object[]{component}));
        }
    }

    private void notifyComponentActivationEventListeners(Component component) {
        for (ComponentStartUpEventListener eventListener : this.eventListeners) {
            if (!(eventListener instanceof ComponentActivationEventListener)) continue;
            try {
                ComponentActivationEventListener componentActivationEventListener = (ComponentActivationEventListener)eventListener;
                componentActivationEventListener.activated(component);
            }
            catch (Exception e) {
                log.error((Object)"An error occurred while notifying component activation event listener", (Throwable)e);
            }
        }
    }

    @Override
    public boolean isComponentActive(Component component) {
        if (this.componentStatusMap.containsKey((Object)component)) {
            return this.componentStatusMap.get((Object)component);
        }
        return false;
    }

    @Override
    public void waitForComponentActivation(Component owner, Component component) {
        if (!this.componentStartUpSynchronizerEnabled) {
            log.debug((Object)String.format("Component activation check is disabled, %s did not wait for %s to be activated", new Object[]{owner, component}));
            return;
        }
        long startTime = System.currentTimeMillis();
        boolean logged = false;
        while (!this.isComponentActive(component)) {
            if (!logged) {
                log.info((Object)String.format("%s is waiting for %s to be activated...", new Object[]{owner, component}));
                logged = true;
            }
            try {
                Thread.sleep(this.componentActivationCheckInterval);
            }
            catch (InterruptedException ignore) {
                throw new RuntimeException(String.format("Thread interrupted, %s could not wait for %s to be activated", new Object[]{owner, component}));
            }
            long currentTime = System.currentTimeMillis();
            if (currentTime - startTime <= this.componentActivationTimeout) continue;
            throw new RuntimeException(String.format("%s did not activated within %d seconds ", new Object[]{component, this.componentActivationTimeout / 1000L}));
        }
    }

    @Override
    public void waitForWebServiceActivation(String serviceName) throws AxisFault {
        if (!this.componentStartUpSynchronizerEnabled) {
            log.debug((Object)String.format("Component activation check is disabled, did not wait for %s to be activated", serviceName));
            return;
        }
        AxisConfiguration axisConfiguration = CarbonConfigurationContextFactory.getConfigurationContext().getAxisConfiguration();
        AxisService cloudControllerService = axisConfiguration.getService(serviceName);
        if (!cloudControllerService.isActive()) {
            while (!cloudControllerService.isActive()) {
                log.info((Object)String.format("Waiting for %s web service to be activated...", serviceName));
                try {
                    Thread.sleep(this.componentActivationCheckInterval);
                }
                catch (InterruptedException ignore) {
                    return;
                }
            }
            log.info((Object)String.format("%s web service activated", serviceName));
        }
    }

    @Override
    public void addEventListener(ComponentStartUpEventListener eventListener) {
        this.eventListeners.add(eventListener);
    }
}

