/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.application.signup;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.common.concurrent.locks.ReadWriteLock;
import org.apache.stratos.messaging.domain.application.signup.ApplicationSignUp;

public class ApplicationSignUpManager {
    private static final Log log = LogFactory.getLog(ApplicationSignUpManager.class);
    private Map<String, Map<Integer, ApplicationSignUp>> applicationIdToApplicationSignUpsMap = new HashMap<String, Map<Integer, ApplicationSignUp>>();
    private static volatile ApplicationSignUpManager instance;
    private static volatile ReadWriteLock lock;
    private boolean initialized;

    private ApplicationSignUpManager() {
    }

    public static void acquireReadLock() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Read lock acquired");
        }
        lock.acquireReadLock();
    }

    public static void releaseReadLock() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Read lock released");
        }
        lock.releaseReadLock();
    }

    public static void acquireWriteLock() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Write lock acquired");
        }
        lock.acquireWriteLock();
    }

    public static void releaseWriteLock() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Write lock released");
        }
        lock.releaseWriteLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ApplicationSignUpManager getInstance() {
        if (instance != null) return instance;
        Class<ApplicationSignUpManager> clazz = ApplicationSignUpManager.class;
        synchronized (ApplicationSignUpManager.class) {
            if (instance != null) return instance;
            instance = new ApplicationSignUpManager();
            if (!log.isDebugEnabled()) return instance;
            log.debug((Object)"Application signup manager instance created");
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void addApplicationSignUp(ApplicationSignUp applicationSignUp) {
        int tenantId;
        String applicationId = applicationSignUp.getApplicationId();
        Map<Integer, ApplicationSignUp> applicationSignUpMap = this.applicationIdToApplicationSignUpsMap.get(applicationId);
        if (applicationSignUpMap == null) {
            applicationSignUpMap = new HashMap<Integer, ApplicationSignUp>();
            this.applicationIdToApplicationSignUpsMap.put(applicationId, applicationSignUpMap);
        }
        if (applicationSignUpMap.get(tenantId = applicationSignUp.getTenantId()) == null) {
            applicationSignUpMap.put(tenantId, applicationSignUp);
        }
    }

    public Collection<ApplicationSignUp> getApplicationSignUps(String applicationId) {
        Map<Integer, ApplicationSignUp> applicationSignUpMap = this.applicationIdToApplicationSignUpsMap.get(applicationId);
        if (applicationSignUpMap != null) {
            return applicationSignUpMap.values();
        }
        return null;
    }

    public ApplicationSignUp getApplicationSignUp(String applicationId, int tenantId) {
        Map<Integer, ApplicationSignUp> applicationSignUpMap = this.applicationIdToApplicationSignUpsMap.get(applicationId);
        if (applicationSignUpMap != null && applicationSignUpMap.containsKey(tenantId)) {
            return applicationSignUpMap.get(tenantId);
        }
        return null;
    }

    public void removeApplicationSignUp(String applicationId, int tenantId) {
        Map<Integer, ApplicationSignUp> applicationSignUpMap = this.applicationIdToApplicationSignUpsMap.get(applicationId);
        if (applicationSignUpMap != null && applicationSignUpMap.containsKey(tenantId)) {
            applicationSignUpMap.remove(tenantId);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void setInitialized(boolean initialized) {
        this.initialized = initialized;
    }

    static {
        lock = new ReadWriteLock("application-signup-manager");
    }
}

