/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.broker.connect.mqtt;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.connect.TopicSubscriber;
import org.apache.stratos.messaging.broker.connect.mqtt.MqttTopicConnector;
import org.apache.stratos.messaging.broker.subscribe.MessageListener;
import org.apache.stratos.messaging.domain.Message;
import org.apache.stratos.messaging.domain.exception.MessagingException;
import org.apache.stratos.messaging.util.MessagingUtil;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class MqttTopicSubscriber
extends MqttTopicConnector
implements TopicSubscriber {
    protected static final Log log = LogFactory.getLog(MqttTopicSubscriber.class);
    private final MessageListener messageListener;
    private String topicName;

    public MqttTopicSubscriber(MessageListener messageListener, String topicName) {
        this.messageListener = messageListener;
        this.topicName = topicName;
        this.create();
    }

    @Override
    public void subscribe() {
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Subscribing to topic " + this.topicName));
            }
            if (this.mqttClient == null) {
                String error = "Could not subscribe to topic, MQTT client has not been initialized";
                if (log.isErrorEnabled()) {
                    log.error((Object)error);
                }
                throw new MessagingException(error);
            }
            this.mqttClient.setCallback((MqttCallback)new MQTTSubscriberCallback());
            this.mqttClient.subscribe(this.topicName, 2);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Subscribed to topic " + this.topicName));
            }
        }
        catch (Exception e) {
            String errorMsg = "Error in subscribing to topic " + this.topicName;
            log.error((Object)errorMsg, (Throwable)e);
            throw new MessagingException(errorMsg, e);
        }
    }

    private class MQTTSubscriberCallback
    implements MqttCallback {
        private MQTTSubscriberCallback() {
        }

        public synchronized void connectionLost(Throwable cause) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("MQTT Connection is lost, topic: " + MqttTopicSubscriber.this.topicName), cause);
            }
            if (MqttTopicSubscriber.this.mqttClient.isConnected()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"MQTT client is already re-connected");
                }
                return;
            }
            this.reconnect();
        }

        private void reconnect() {
            boolean reconnected = false;
            while (!reconnected) {
                try {
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Will try to subscribe again in " + MessagingUtil.getSubscriberFailoverInterval() / 1000 + " sec"));
                    }
                    try {
                        Thread.sleep(MessagingUtil.getSubscriberFailoverInterval());
                    }
                    catch (InterruptedException ignore) {
                        // empty catch block
                    }
                    if (log.isInfoEnabled()) {
                        log.info((Object)("Reconnection initiated for topic " + MqttTopicSubscriber.this.topicName));
                    }
                    MqttTopicSubscriber.this.create();
                    MqttTopicSubscriber.this.connect();
                    MqttTopicSubscriber.this.subscribe();
                    reconnected = true;
                }
                catch (Exception e) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)"Could not reconnect", (Throwable)e);
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Re-connected and subscribed to topic " + MqttTopicSubscriber.this.topicName));
            }
        }

        public void messageArrived(String topic, MqttMessage message) throws Exception {
            String messageText = new String(message.getPayload());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Message received: %s", messageText));
            }
            MqttTopicSubscriber.this.messageListener.messageReceived(new Message(topic, messageText));
        }

        public void deliveryComplete(IMqttDeliveryToken deliveryToken) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Message delivery is complete: %s", deliveryToken != null ? deliveryToken.toString() : ""));
            }
        }
    }
}

