/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.util.Iterator;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.types.ArchiveScanner;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;

public abstract class ArchiveFileSet
extends FileSet {
    private static final int BASE_OCTAL = 8;
    public static final int DEFAULT_DIR_MODE = 16877;
    public static final int DEFAULT_FILE_MODE = 33188;
    private Resource src = null;
    private String prefix = "";
    private String fullpath = "";
    private boolean hasDir = false;
    private int fileMode = 33188;
    private int dirMode = 16877;
    private boolean fileModeHasBeenSet = false;
    private boolean dirModeHasBeenSet = false;

    public ArchiveFileSet() {
    }

    protected ArchiveFileSet(FileSet fileset) {
        super(fileset);
    }

    protected ArchiveFileSet(ArchiveFileSet fileset) {
        super(fileset);
        this.src = fileset.src;
        this.prefix = fileset.prefix;
        this.fullpath = fileset.fullpath;
        this.hasDir = fileset.hasDir;
        this.fileMode = fileset.fileMode;
        this.dirMode = fileset.dirMode;
        this.fileModeHasBeenSet = fileset.fileModeHasBeenSet;
        this.dirModeHasBeenSet = fileset.dirModeHasBeenSet;
    }

    public void setDir(File dir) throws BuildException {
        this.checkAttributesAllowed();
        if (this.src != null) {
            throw new BuildException("Cannot set both dir and src attributes");
        }
        super.setDir(dir);
        this.hasDir = true;
    }

    public void addConfigured(ResourceCollection a) {
        this.checkChildrenAllowed();
        if (a.size() != 1) {
            throw new BuildException("only single argument resource collections are supported as archives");
        }
        this.setSrcResource((Resource)a.iterator().next());
    }

    public void setSrc(File srcFile) {
        this.setSrcResource(new FileResource(srcFile));
    }

    public void setSrcResource(Resource src) {
        this.checkArchiveAttributesAllowed();
        if (this.hasDir) {
            throw new BuildException("Cannot set both dir and src attributes");
        }
        this.src = src;
    }

    public File getSrc(Project p) {
        if (this.isReference()) {
            return ((ArchiveFileSet)this.getRef(p)).getSrc(p);
        }
        return this.getSrc();
    }

    public File getSrc() {
        if (this.src instanceof FileResource) {
            return ((FileResource)this.src).getFile();
        }
        return null;
    }

    public void setPrefix(String prefix) {
        this.checkArchiveAttributesAllowed();
        if (!prefix.equals("") && !this.fullpath.equals("")) {
            throw new BuildException("Cannot set both fullpath and prefix attributes");
        }
        this.prefix = prefix;
    }

    public String getPrefix(Project p) {
        if (this.isReference()) {
            return ((ArchiveFileSet)this.getRef(p)).getPrefix(p);
        }
        return this.prefix;
    }

    public void setFullpath(String fullpath) {
        this.checkArchiveAttributesAllowed();
        if (!this.prefix.equals("") && !fullpath.equals("")) {
            throw new BuildException("Cannot set both fullpath and prefix attributes");
        }
        this.fullpath = fullpath;
    }

    public String getFullpath(Project p) {
        if (this.isReference()) {
            return ((ArchiveFileSet)this.getRef(p)).getFullpath(p);
        }
        return this.fullpath;
    }

    protected abstract ArchiveScanner newArchiveScanner();

    public DirectoryScanner getDirectoryScanner(Project p) {
        if (this.isReference()) {
            return this.getRef(p).getDirectoryScanner(p);
        }
        if (this.src == null) {
            return super.getDirectoryScanner(p);
        }
        if (!this.src.isExists()) {
            throw new BuildException("the archive doesn't exist");
        }
        if (this.src.isDirectory()) {
            throw new BuildException("the archive can't be a directory");
        }
        ArchiveScanner as = this.newArchiveScanner();
        as.setSrc(this.src);
        super.setDir(p.getBaseDir());
        this.setupDirectoryScanner(as, p);
        as.init();
        return as;
    }

    public Iterator iterator() {
        if (this.isReference()) {
            return ((ResourceCollection)((Object)this.getRef(this.getProject()))).iterator();
        }
        if (this.src == null) {
            return super.iterator();
        }
        ArchiveScanner as = (ArchiveScanner)this.getDirectoryScanner(this.getProject());
        return as.getResourceFiles();
    }

    public int size() {
        if (this.isReference()) {
            return ((ResourceCollection)((Object)this.getRef(this.getProject()))).size();
        }
        if (this.src == null) {
            return super.size();
        }
        ArchiveScanner as = (ArchiveScanner)this.getDirectoryScanner(this.getProject());
        return as.getIncludedFilesCount();
    }

    public boolean isFilesystemOnly() {
        return this.src == null;
    }

    public void setFileMode(String octalString) {
        this.checkArchiveAttributesAllowed();
        this.integerSetFileMode(Integer.parseInt(octalString, 8));
    }

    public void integerSetFileMode(int mode) {
        this.fileModeHasBeenSet = true;
        this.fileMode = 0x8000 | mode;
    }

    public int getFileMode(Project p) {
        if (this.isReference()) {
            return ((ArchiveFileSet)this.getRef(p)).getFileMode(p);
        }
        return this.fileMode;
    }

    public boolean hasFileModeBeenSet() {
        if (this.isReference()) {
            return ((ArchiveFileSet)this.getRef(this.getProject())).hasFileModeBeenSet();
        }
        return this.fileModeHasBeenSet;
    }

    public void setDirMode(String octalString) {
        this.checkArchiveAttributesAllowed();
        this.integerSetDirMode(Integer.parseInt(octalString, 8));
    }

    public void integerSetDirMode(int mode) {
        this.dirModeHasBeenSet = true;
        this.dirMode = 0x4000 | mode;
    }

    public int getDirMode(Project p) {
        if (this.isReference()) {
            return ((ArchiveFileSet)this.getRef(p)).getDirMode(p);
        }
        return this.dirMode;
    }

    public boolean hasDirModeBeenSet() {
        if (this.isReference()) {
            return ((ArchiveFileSet)this.getRef(this.getProject())).hasDirModeBeenSet();
        }
        return this.dirModeHasBeenSet;
    }

    protected void configureFileSet(ArchiveFileSet zfs) {
        zfs.setPrefix(this.prefix);
        zfs.setFullpath(this.fullpath);
        zfs.fileModeHasBeenSet = this.fileModeHasBeenSet;
        zfs.fileMode = this.fileMode;
        zfs.dirModeHasBeenSet = this.dirModeHasBeenSet;
        zfs.dirMode = this.dirMode;
    }

    public Object clone() {
        if (this.isReference()) {
            return ((ArchiveFileSet)this.getRef(this.getProject())).clone();
        }
        return super.clone();
    }

    public String toString() {
        if (this.hasDir && this.getProject() != null) {
            return super.toString();
        }
        if (this.src != null) {
            return this.src.getName();
        }
        return null;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getFullpath() {
        return this.fullpath;
    }

    public int getFileMode() {
        return this.fileMode;
    }

    public int getDirMode() {
        return this.dirMode;
    }

    private void checkArchiveAttributesAllowed() {
        if (this.getProject() == null || this.isReference() && this.getRefid().getReferencedObject(this.getProject()) instanceof ArchiveFileSet) {
            this.checkAttributesAllowed();
        }
    }
}

