/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.message.receiver.cluster.status;

import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.messaging.broker.subscribe.EventSubscriber;
import org.apache.stratos.messaging.listener.EventListener;
import org.apache.stratos.messaging.message.receiver.cluster.status.ClusterStatusEventMessageDelegator;
import org.apache.stratos.messaging.message.receiver.cluster.status.ClusterStatusEventMessageListener;
import org.apache.stratos.messaging.message.receiver.cluster.status.ClusterStatusEventMessageQueue;
import org.apache.stratos.messaging.util.MessagingUtil;

public class ClusterStatusEventReceiver {
    private static final Log log = LogFactory.getLog(ClusterStatusEventReceiver.class);
    private final ClusterStatusEventMessageDelegator messageDelegator;
    private final ClusterStatusEventMessageListener messageListener;
    private EventSubscriber eventSubscriber;
    private boolean terminated;
    private ExecutorService executorService;

    public ClusterStatusEventReceiver() {
        ClusterStatusEventMessageQueue messageQueue = new ClusterStatusEventMessageQueue();
        this.messageDelegator = new ClusterStatusEventMessageDelegator(messageQueue);
        this.messageListener = new ClusterStatusEventMessageListener(messageQueue);
    }

    public void addEventListener(EventListener eventListener) {
        this.messageDelegator.addEventListener(eventListener);
    }

    public void execute() {
        block4: {
            try {
                this.eventSubscriber = new EventSubscriber(MessagingUtil.Topics.CLUSTER_STATUS_TOPIC.getTopicName(), this.messageListener);
                this.executorService.execute(this.eventSubscriber);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"InstanceNotifier event message receiver thread started");
                }
                this.executorService.execute(this.messageDelegator);
                if (log.isDebugEnabled()) {
                    log.debug((Object)"InstanceNotifier event message delegator thread started");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)"InstanceNotifier receiver failed", (Throwable)e);
            }
        }
    }

    public boolean isSubscribed() {
        return this.eventSubscriber != null && this.eventSubscriber.isSubscribed();
    }

    public void terminate() {
        this.eventSubscriber.terminate();
        this.messageDelegator.terminate();
        this.terminated = true;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }
}

