/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.messaging.event.topology;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.stratos.messaging.domain.topology.Port;
import org.apache.stratos.messaging.domain.topology.ServiceType;
import org.apache.stratos.messaging.event.topology.TopologyEvent;

public class ServiceCreatedEvent
extends TopologyEvent
implements Serializable {
    private static final long serialVersionUID = 3480876570877127669L;
    private final String serviceName;
    private final ServiceType serviceType;
    private final Map<Integer, Port> portMap;
    private Properties properties;

    public ServiceCreatedEvent(String serviceName, ServiceType serviceType) {
        this.serviceName = serviceName;
        this.serviceType = serviceType;
        this.portMap = new HashMap<Integer, Port>();
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public Collection<Port> getPorts() {
        return Collections.unmodifiableCollection(this.portMap.values());
    }

    public Port getPort(int proxy) {
        if (this.portMap.containsKey(proxy)) {
            return this.portMap.get(proxy);
        }
        return null;
    }

    public void addPort(Port port) {
        this.portMap.put(port.getProxy(), port);
    }

    public void addPorts(Collection<Port> ports) {
        for (Port port : ports) {
            this.addPort(port);
        }
    }

    public void removePort(Port port) {
        this.portMap.remove(port.getProxy());
    }

    public boolean portExists(Port port) {
        return this.portMap.containsKey(port.getProxy());
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }
}

