/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.common.beans.cartridge;

import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.stratos.common.beans.PropertyBean;
import org.apache.stratos.common.beans.cartridge.NetworkInterfaceBean;

@XmlRootElement(name="iaasProvider")
public class IaasProviderBean {
    private String type;
    private String name;
    private String className;
    private String imageId;
    private String provider;
    private String identity;
    private String credential;
    private List<PropertyBean> property;
    private List<NetworkInterfaceBean> networkInterfaces;

    public List<NetworkInterfaceBean> getNetworkInterfaces() {
        return this.networkInterfaces;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public String getIdentity() {
        return this.identity;
    }

    public void setIdentity(String identity) {
        this.identity = identity;
    }

    public String getCredential() {
        return this.credential;
    }

    public void setCredential(String credential) {
        this.credential = credential;
    }

    public List<PropertyBean> getProperty() {
        return this.property;
    }

    public void setProperty(List<PropertyBean> property) {
        this.property = property;
    }

    public void setNetworkInterfaces(List<NetworkInterfaceBean> networkInterfaces) {
        this.networkInterfaces = networkInterfaces;
    }

    private String getIaasPropertiesString() {
        StringBuilder iaasPropertyBuilder = new StringBuilder();
        if (this.getProperty() != null) {
            for (PropertyBean propertyBean : this.getProperty()) {
                iaasPropertyBuilder.append(propertyBean.getName() + " : " + propertyBean.getValue() + " | ");
            }
        }
        return iaasPropertyBuilder.toString();
    }

    private String getNetworkInterfacesString() {
        StringBuilder sb = new StringBuilder();
        if (this.getNetworkInterfaces() != null) {
            sb.append('[');
            String delimeter = "";
            for (NetworkInterfaceBean nib : this.getNetworkInterfaces()) {
                sb.append(delimeter).append(nib);
                delimeter = ", ";
            }
            sb.append(']');
        }
        return sb.toString();
    }

    public String toString() {
        return " [ Type: " + this.getType() + ", Name: " + this.getName() + ", Class Name: " + this.getClassName() + ", Image Id: " + this.getImageId() + ", Provider: " + this.getProvider() + ", Identity: " + this.getIdentity() + ", Credentials: " + this.getCredential() + ", Properties: " + this.getIaasPropertiesString() + ", Network Interfaces: " + this.getNetworkInterfacesString() + " ] ";
    }
}

