/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.base;

import java.util.Stack;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CarbonApplicationContextHolderBase {
    private String applicationName;
    private static final Log log = LogFactory.getLog(CarbonApplicationContextHolderBase.class);
    private static ThreadLocal<CarbonApplicationContextHolderBase> currentAppContextHolderBase = new ThreadLocal<CarbonApplicationContextHolderBase>(){

        @Override
        protected CarbonApplicationContextHolderBase initialValue() {
            return new CarbonApplicationContextHolderBase();
        }
    };
    private static ThreadLocal<Stack<CarbonApplicationContextHolderBase>> parentAppContextHolderBaseStack = new ThreadLocal<Stack<CarbonApplicationContextHolderBase>>(){

        @Override
        protected Stack<CarbonApplicationContextHolderBase> initialValue() {
            return new Stack<CarbonApplicationContextHolderBase>();
        }
    };

    private CarbonApplicationContextHolderBase() {
        this.applicationName = "";
    }

    public static CarbonApplicationContextHolderBase getCurrentCarbonAppContextHolderBase() {
        return currentAppContextHolderBase.get();
    }

    public void startApplicationFlow() {
        log.trace((Object)"Starting Application flow.");
        parentAppContextHolderBaseStack.get().push(new CarbonApplicationContextHolderBase(this));
        this.restore(null);
    }

    public void endApplicationFlow() {
        log.trace((Object)"Stopping Application flow.");
        this.restore(parentAppContextHolderBaseStack.get().pop());
    }

    public CarbonApplicationContextHolderBase(CarbonApplicationContextHolderBase carbonAppContextHolder) {
        this.applicationName = carbonAppContextHolder.applicationName;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public static void destroyCurrentCarbonaAppContextHolder() {
        currentAppContextHolderBase.remove();
        parentAppContextHolderBaseStack.remove();
    }

    private void restore(CarbonApplicationContextHolderBase carbonAppContextHolder) {
        this.applicationName = carbonAppContextHolder != null ? carbonAppContextHolder.applicationName : "";
    }
}

