/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.paho.client.mqttv3.internal.wire;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.internal.wire.CountingInputStream;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttPersistableWireMessage;
import org.eclipse.paho.client.mqttv3.internal.wire.MqttReceivedMessage;

public class MqttPublish
extends MqttPersistableWireMessage {
    private MqttMessage message;
    private String topicName;
    private byte[] encodedPayload = null;

    public MqttPublish(String name, MqttMessage message) {
        super((byte)3);
        this.topicName = name;
        this.message = message;
    }

    public MqttPublish(byte info, byte[] data) throws MqttException, IOException {
        super((byte)3);
        this.message = new MqttReceivedMessage();
        this.message.setQos(info >> 1 & 3);
        if ((info & 1) == 1) {
            this.message.setRetained(true);
        }
        if ((info & 8) == 8) {
            ((MqttReceivedMessage)this.message).setDuplicate(true);
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        CountingInputStream counter = new CountingInputStream(bais);
        DataInputStream dis = new DataInputStream(counter);
        this.topicName = this.decodeUTF8(dis);
        if (this.message.getQos() > 0) {
            this.msgId = dis.readUnsignedShort();
        }
        byte[] payload = new byte[data.length - counter.getCounter()];
        dis.readFully(payload);
        dis.close();
        this.message.setPayload(payload);
    }

    @Override
    public String toString() {
        StringBuffer hex = new StringBuffer();
        byte[] payload = this.message.getPayload();
        int limit = Math.min(payload.length, 20);
        for (int i = 0; i < limit; ++i) {
            byte b = payload[i];
            String ch = Integer.toHexString(b);
            if (ch.length() == 1) {
                ch = "0" + ch;
            }
            hex.append(ch);
        }
        String string = null;
        try {
            string = new String(payload, 0, limit, "UTF-8");
        }
        catch (Exception e) {
            string = "?";
        }
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append(" qos:" + this.message.getQos());
        if (this.message.getQos() > 0) {
            sb.append(" msgId:" + this.msgId);
        }
        sb.append(" retained:" + this.message.isRetained());
        sb.append(" dup:" + this.duplicate);
        sb.append(" topic:\"" + this.topicName + "\"");
        sb.append(" payload:[hex:" + hex);
        sb.append(" utf8:\"" + string + "\"");
        sb.append(" length:" + payload.length + "]");
        return sb.toString();
    }

    @Override
    protected byte getMessageInfo() {
        byte info = (byte)(this.message.getQos() << 1);
        if (this.message.isRetained()) {
            info = (byte)(info | 1);
        }
        if (this.message.isDuplicate() || this.duplicate) {
            info = (byte)(info | 8);
        }
        return info;
    }

    public String getTopicName() {
        return this.topicName;
    }

    public MqttMessage getMessage() {
        return this.message;
    }

    protected static byte[] encodePayload(MqttMessage message) {
        return message.getPayload();
    }

    @Override
    public byte[] getPayload() throws MqttException {
        if (this.encodedPayload == null) {
            this.encodedPayload = MqttPublish.encodePayload(this.message);
        }
        return this.encodedPayload;
    }

    @Override
    public int getPayloadLength() {
        int length = 0;
        try {
            length = this.getPayload().length;
        }
        catch (MqttException mqttException) {
            // empty catch block
        }
        return length;
    }

    @Override
    public void setMessageId(int msgId) {
        super.setMessageId(msgId);
        if (this.message instanceof MqttReceivedMessage) {
            ((MqttReceivedMessage)this.message).setMessageId(msgId);
        }
    }

    @Override
    protected byte[] getVariableHeader() throws MqttException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream dos = new DataOutputStream(baos);
            this.encodeUTF8(dos, this.topicName);
            if (this.message.getQos() > 0) {
                dos.writeShort(this.msgId);
            }
            dos.flush();
            return baos.toByteArray();
        }
        catch (IOException ex) {
            throw new MqttException(ex);
        }
    }

    @Override
    public boolean isMessageIdRequired() {
        return true;
    }
}

