/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport.network.io;

import java.net.Socket;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wso2.andes.transport.Receiver;
import org.wso2.andes.transport.Sender;
import org.wso2.andes.transport.network.NetworkConnection;
import org.wso2.andes.transport.network.io.IoReceiver;
import org.wso2.andes.transport.network.io.IoSender;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IoNetworkConnection
implements NetworkConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(IoNetworkConnection.class);
    private final Socket _socket;
    private final long _timeout;
    private final IoSender _ioSender;
    private final IoReceiver _ioReceiver;

    public IoNetworkConnection(Socket socket, Receiver<ByteBuffer> delegate, int sendBufferSize, int receiveBufferSize, long timeout) {
        this._socket = socket;
        this._timeout = timeout;
        this._ioReceiver = new IoReceiver(this._socket, delegate, receiveBufferSize, this._timeout);
        this._ioSender = new IoSender(this._socket, 2 * sendBufferSize, this._timeout);
        this._ioSender.registerCloseListener(this._ioReceiver);
        this._ioReceiver.initiate();
        this._ioSender.initiate();
    }

    @Override
    public Sender<ByteBuffer> getSender() {
        return this._ioSender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this._ioSender.close();
        }
        finally {
            this._ioReceiver.close(false);
        }
    }

    @Override
    public SocketAddress getRemoteAddress() {
        return this._socket.getRemoteSocketAddress();
    }

    @Override
    public SocketAddress getLocalAddress() {
        return this._socket.getLocalSocketAddress();
    }

    @Override
    public void setMaxWriteIdle(int sec) {
    }

    @Override
    public void setMaxReadIdle(int sec) {
    }
}

