/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.user.mgt;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.wso2.carbon.context.CarbonContext;
import org.wso2.carbon.registry.api.Registry;
import org.wso2.carbon.registry.api.RegistryException;
import org.wso2.carbon.registry.api.Resource;
import org.wso2.carbon.registry.core.Collection;
import org.wso2.carbon.registry.core.session.UserRegistry;
import org.wso2.carbon.user.api.Claim;
import org.wso2.carbon.user.api.ClaimMapping;
import org.wso2.carbon.user.api.RealmConfiguration;
import org.wso2.carbon.user.core.AuthorizationManager;
import org.wso2.carbon.user.core.UserRealm;
import org.wso2.carbon.user.core.UserStoreException;
import org.wso2.carbon.user.core.UserStoreManager;
import org.wso2.carbon.user.core.common.AbstractUserStoreManager;
import org.wso2.carbon.user.core.util.UserCoreUtil;
import org.wso2.carbon.user.mgt.bulkimport.BulkImportConfig;
import org.wso2.carbon.user.mgt.bulkimport.CSVUserBulkImport;
import org.wso2.carbon.user.mgt.bulkimport.ExcelUserBulkImport;
import org.wso2.carbon.user.mgt.common.ClaimValue;
import org.wso2.carbon.user.mgt.common.FlaggedName;
import org.wso2.carbon.user.mgt.common.UIPermissionNode;
import org.wso2.carbon.user.mgt.common.UserAdminException;
import org.wso2.carbon.user.mgt.common.UserRealmInfo;
import org.wso2.carbon.user.mgt.common.UserStoreInfo;
import org.wso2.carbon.user.mgt.internal.UserMgtDSComponent;
import org.wso2.carbon.user.mgt.permission.ManagementPermissionUtil;
import org.wso2.carbon.utils.multitenancy.MultitenantUtils;

public class UserRealmProxy {
    private static Log log = LogFactory.getLog(UserRealmProxy.class);
    private UserRealm realm = null;

    public UserRealmProxy(UserRealm userRealm) {
        this.realm = userRealm;
    }

    public String[] listUsers(String filter, int maxLimit) throws UserAdminException {
        try {
            return this.realm.getUserStoreManager().listUsers(filter, maxLimit);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public FlaggedName[] listUsers(ClaimValue claimValue, String filter, int maxLimit) throws UserAdminException {
        try {
            Object[] usersWithClaim = null;
            ArrayList<FlaggedName> users = new ArrayList<FlaggedName>();
            if (claimValue.getClaimURI() != null && claimValue.getValue() != null) {
                usersWithClaim = this.realm.getUserStoreManager().getUserList(claimValue.getClaimURI(), claimValue.getValue(), null);
            }
            FlaggedName[] allUsers = this.listAllUsers(filter, maxLimit);
            if (usersWithClaim != null) {
                Arrays.sort(usersWithClaim);
                for (FlaggedName name : allUsers) {
                    if (Arrays.binarySearch(usersWithClaim, name.getItemName()) <= -1) continue;
                    users.add(name);
                }
                return users.toArray(new FlaggedName[users.size()]);
            }
            return allUsers;
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public FlaggedName[] listAllUsers(String filter, int maxLimit) throws UserAdminException {
        FlaggedName[] flaggedNames = null;
        HashMap<String, Integer> userCount = new HashMap<String, Integer>();
        try {
            UserStoreManager userStoreManager = this.realm.getUserStoreManager();
            String[] users = userStoreManager.listUsers(filter, maxLimit);
            flaggedNames = new FlaggedName[users.length + 1];
            int i = 0;
            for (String user : users) {
                String domain;
                flaggedNames[i] = new FlaggedName();
                int index = user.indexOf("|");
                if (index > 0) {
                    flaggedNames[i].setItemName(user.substring(0, index));
                    flaggedNames[i].setItemDisplayName(user.substring(index + 1));
                } else {
                    flaggedNames[i].setItemName(user);
                    flaggedNames[i].setItemDisplayName(user);
                }
                int index1 = flaggedNames[i].getItemName() != null ? flaggedNames[i].getItemName().indexOf("/") : -1;
                boolean domainProvided = index1 > 0;
                String string = domain = domainProvided ? flaggedNames[i].getItemName().substring(0, index1) : null;
                if (domain != null && !"Internal".equalsIgnoreCase(domain)) {
                    UserStoreManager secondaryUM = this.realm.getUserStoreManager().getSecondaryUserStoreManager(domain);
                    if (secondaryUM != null && secondaryUM.isReadOnly()) {
                        flaggedNames[i].setEditable(false);
                    } else {
                        flaggedNames[i].setEditable(true);
                    }
                } else if (this.realm.getUserStoreManager().isReadOnly()) {
                    flaggedNames[i].setEditable(false);
                } else {
                    flaggedNames[i].setEditable(true);
                }
                if (domain != null) {
                    if (userCount.containsKey(domain)) {
                        userCount.put(domain, (Integer)userCount.get(domain) + 1);
                    } else {
                        userCount.put(domain, 1);
                    }
                } else if (userCount.containsKey("PRIMARY")) {
                    userCount.put("PRIMARY", (Integer)userCount.get("PRIMARY") + 1);
                } else {
                    userCount.put("PRIMARY", 1);
                }
                ++i;
            }
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        Arrays.sort(flaggedNames, new Comparator<FlaggedName>(){

            @Override
            public int compare(FlaggedName o1, FlaggedName o2) {
                if (o1 == null || o2 == null) {
                    return 0;
                }
                return o1.getItemName().toLowerCase().compareTo(o2.getItemName().toLowerCase());
            }
        });
        String exceededDomains = "";
        boolean isPrimaryExceeding = false;
        try {
            Map maxUserListCount = ((AbstractUserStoreManager)this.realm.getUserStoreManager()).getMaxListCount("MaxUserNameListLength");
            String[] domains = userCount.keySet().toArray(new String[userCount.keySet().size()]);
            for (int i = 0; i < domains.length; ++i) {
                if ("PRIMARY".equalsIgnoreCase(domains[i])) {
                    if (((Integer)userCount.get("PRIMARY")).intValue() != ((Integer)maxUserListCount.get("PRIMARY")).intValue()) continue;
                    isPrimaryExceeding = true;
                    continue;
                }
                if (!((Integer)userCount.get(domains[i])).equals(maxUserListCount.get(domains[i].toUpperCase()))) continue;
                exceededDomains = exceededDomains + domains[i];
                if (i == domains.length - 1) continue;
                exceededDomains = exceededDomains + ":";
            }
            FlaggedName flaggedName = new FlaggedName();
            if (isPrimaryExceeding) {
                flaggedName.setItemName("true");
            } else {
                flaggedName.setItemName("false");
            }
            flaggedName.setItemDisplayName(exceededDomains);
            flaggedNames[flaggedNames.length - 1] = flaggedName;
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        return flaggedNames;
    }

    public FlaggedName[] getAllSharedRoleNames(String filter, int maxLimit) throws UserAdminException {
        try {
            UserStoreManager userStoreMan = this.realm.getUserStoreManager();
            if (!(userStoreMan instanceof AbstractUserStoreManager)) {
                throw new UserAdminException("Initialized User Store Manager is not capable of getting the shared roles");
            }
            String[] externalRoles = ((AbstractUserStoreManager)userStoreMan).getSharedRoleNames(filter, maxLimit);
            ArrayList<FlaggedName> flaggedNames = new ArrayList<FlaggedName>();
            HashMap<String, Integer> userCount = new HashMap<String, Integer>();
            for (String externalRole : externalRoles) {
                FlaggedName fName = new FlaggedName();
                this.mapEntityName(externalRole, fName, userStoreMan);
                fName.setRoleType("External");
                int index = externalRole != null ? externalRole.indexOf("/") : -1;
                boolean domainProvided = index > 0;
                String domain = domainProvided ? externalRole.substring(0, index) : null;
                UserStoreManager secManager = this.realm.getUserStoreManager().getSecondaryUserStoreManager(domain);
                if (domain != null && !"Internal".equalsIgnoreCase(domain)) {
                    if (secManager != null && (secManager.isReadOnly() || secManager.getRealmConfiguration().getUserStoreProperty("WriteGroups") != null && secManager.getRealmConfiguration().getUserStoreProperty("WriteGroups").equals("false"))) {
                        fName.setEditable(false);
                    } else {
                        fName.setEditable(true);
                    }
                }
                if (domain != null) {
                    if (userCount.containsKey(domain)) {
                        userCount.put(domain, (Integer)userCount.get(domain) + 1);
                    } else {
                        userCount.put(domain, 1);
                    }
                } else if (userCount.containsKey("PRIMARY")) {
                    userCount.put("PRIMARY", (Integer)userCount.get("PRIMARY") + 1);
                } else {
                    userCount.put("PRIMARY", 1);
                }
                flaggedNames.add(fName);
            }
            String exceededDomains = "";
            boolean isPrimaryExceeding = false;
            Map maxUserListCount = ((AbstractUserStoreManager)this.realm.getUserStoreManager()).getMaxListCount("MaxRoleNameListLength");
            String[] domains = userCount.keySet().toArray(new String[userCount.keySet().size()]);
            for (int i = 0; i < domains.length; ++i) {
                if ("PRIMARY".equals(domains[i])) {
                    if (!((Integer)userCount.get("PRIMARY")).equals(maxUserListCount.get("PRIMARY"))) continue;
                    isPrimaryExceeding = true;
                    continue;
                }
                if (!((Integer)userCount.get(domains[i])).equals(maxUserListCount.get(domains[i].toUpperCase()))) continue;
                exceededDomains = exceededDomains + domains[i];
                if (i == domains.length - 1) continue;
                exceededDomains = exceededDomains + ":";
            }
            FlaggedName[] roleNames = flaggedNames.toArray(new FlaggedName[flaggedNames.size() + 1]);
            Arrays.sort(roleNames, new Comparator<FlaggedName>(){

                @Override
                public int compare(FlaggedName o1, FlaggedName o2) {
                    if (o1 == null || o2 == null) {
                        return 0;
                    }
                    return o1.getItemName().toLowerCase().compareTo(o2.getItemName().toLowerCase());
                }
            });
            FlaggedName flaggedName = new FlaggedName();
            if (isPrimaryExceeding) {
                flaggedName.setItemName("true");
            } else {
                flaggedName.setItemName("false");
            }
            flaggedName.setItemDisplayName(exceededDomains);
            roleNames[roleNames.length - 1] = flaggedName;
            return roleNames;
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public FlaggedName[] getAllRolesNames(String filter, int maxLimit) throws UserAdminException {
        try {
            String[] hybridRoles;
            UserStoreManager userStoreMan = this.realm.getUserStoreManager();
            String[] externalRoles = userStoreMan instanceof AbstractUserStoreManager ? ((AbstractUserStoreManager)userStoreMan).getRoleNames(filter, maxLimit, true, true, true) : userStoreMan.getRoleNames();
            ArrayList<FlaggedName> flaggedNames = new ArrayList<FlaggedName>();
            HashMap<String, Integer> userCount = new HashMap<String, Integer>();
            for (String externalRole : externalRoles) {
                FlaggedName fName = new FlaggedName();
                this.mapEntityName(externalRole, fName, userStoreMan);
                fName.setRoleType("External");
                int index = externalRole != null ? externalRole.indexOf("/") : -1;
                boolean domainProvided = index > 0;
                String domain = domainProvided ? externalRole.substring(0, index) : null;
                UserStoreManager secManager = this.realm.getUserStoreManager().getSecondaryUserStoreManager(domain);
                if (domain != null && !"Internal".equalsIgnoreCase(domain)) {
                    if (secManager != null && (secManager.isReadOnly() || "false".equals(secManager.getRealmConfiguration().getUserStoreProperty("WriteGroups")))) {
                        fName.setEditable(false);
                    } else {
                        fName.setEditable(true);
                    }
                } else if (this.realm.getUserStoreManager().isReadOnly() || "false".equals(this.realm.getUserStoreManager().getRealmConfiguration().getUserStoreProperty("WriteGroups"))) {
                    fName.setEditable(false);
                } else {
                    fName.setEditable(true);
                }
                if (domain != null) {
                    if (userCount.containsKey(domain)) {
                        userCount.put(domain, (Integer)userCount.get(domain) + 1);
                    } else {
                        userCount.put(domain, 1);
                    }
                } else if (userCount.containsKey("PRIMARY")) {
                    userCount.put("PRIMARY", (Integer)userCount.get("PRIMARY") + 1);
                } else {
                    userCount.put("PRIMARY", 1);
                }
                flaggedNames.add(fName);
            }
            if (filter.startsWith("Internal/")) {
                filter = filter.substring(filter.indexOf("/") + 1);
            }
            for (String hybridRole : hybridRoles = ((AbstractUserStoreManager)userStoreMan).getHybridRoles(filter)) {
                FlaggedName fName = new FlaggedName();
                fName.setItemName(hybridRole);
                fName.setRoleType("Internal");
                fName.setEditable(true);
                flaggedNames.add(fName);
            }
            String exceededDomains = "";
            boolean isPrimaryExceeding = false;
            Map maxUserListCount = ((AbstractUserStoreManager)this.realm.getUserStoreManager()).getMaxListCount("MaxRoleNameListLength");
            String[] domains = userCount.keySet().toArray(new String[userCount.keySet().size()]);
            for (int i = 0; i < domains.length; ++i) {
                if ("PRIMARY".equals(domains[i])) {
                    if (!((Integer)userCount.get("PRIMARY")).equals(maxUserListCount.get("PRIMARY"))) continue;
                    isPrimaryExceeding = true;
                    continue;
                }
                if (!((Integer)userCount.get(domains[i])).equals(maxUserListCount.get(domains[i].toUpperCase()))) continue;
                exceededDomains = exceededDomains + domains[i];
                if (i == domains.length - 1) continue;
                exceededDomains = exceededDomains + ":";
            }
            FlaggedName[] roleNames = flaggedNames.toArray(new FlaggedName[flaggedNames.size() + 1]);
            Arrays.sort(roleNames, new Comparator<FlaggedName>(){

                @Override
                public int compare(FlaggedName o1, FlaggedName o2) {
                    if (o1 == null || o2 == null) {
                        return 0;
                    }
                    return o1.getItemName().toLowerCase().compareTo(o2.getItemName().toLowerCase());
                }
            });
            FlaggedName flaggedName = new FlaggedName();
            if (isPrimaryExceeding) {
                flaggedName.setItemName("true");
            } else {
                flaggedName.setItemName("false");
            }
            flaggedName.setItemDisplayName(exceededDomains);
            roleNames[roleNames.length - 1] = flaggedName;
            return roleNames;
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public UserRealmInfo getUserRealmInfo() throws UserAdminException {
        UserRealmInfo userRealmInfo = new UserRealmInfo();
        String userName = CarbonContext.getCurrentContext().getUsername();
        try {
            RealmConfiguration realmConfig = this.realm.getRealmConfiguration();
            if (this.realm.getAuthorizationManager().isUserAuthorized(userName, "/permission/admin/configure/security", "ui.execute") || this.realm.getAuthorizationManager().isUserAuthorized(userName, "/permission/admin/configure/security/usermgt/users", "ui.execute") || this.realm.getAuthorizationManager().isUserAuthorized(userName, "/permission/admin/configure/security/usermgt/passwords", "ui.execute") || this.realm.getAuthorizationManager().isUserAuthorized(userName, "/permission/admin/configure/security/usermgt/profiles", "ui.execute")) {
                userRealmInfo.setAdminRole(realmConfig.getAdminRoleName());
                userRealmInfo.setAdminUser(realmConfig.getAdminUserName());
                userRealmInfo.setEveryOneRole(realmConfig.getEveryOneRoleName());
                ClaimMapping[] defaultClaims = this.realm.getClaimManager().getAllClaimMappings("http://wso2.org/claims");
                ArrayList<String> defaultClaimList = new ArrayList<String>();
                ArrayList<String> requiredClaimsList = new ArrayList<String>();
                for (ClaimMapping claimMapping : defaultClaims) {
                    Claim claim = claimMapping.getClaim();
                    defaultClaimList.add(claim.getClaimUri());
                    if (!claim.isRequired()) continue;
                    requiredClaimsList.add(claim.getClaimUri());
                }
                userRealmInfo.setUserClaims(defaultClaimList.toArray(new String[defaultClaimList.size()]));
                userRealmInfo.setRequiredUserClaims(requiredClaimsList.toArray(new String[requiredClaimsList.size()]));
            }
            ArrayList<UserStoreInfo> storeInfoList = new ArrayList<UserStoreInfo>();
            ArrayList<String> domainNames = new ArrayList<String>();
            RealmConfiguration secondaryConfig = realmConfig;
            UserStoreManager secondaryManager = this.realm.getUserStoreManager();
            do {
                secondaryConfig = secondaryManager.getRealmConfiguration();
                UserStoreInfo userStoreInfo = this.getUserStoreInfo(secondaryConfig, secondaryManager);
                if (secondaryConfig.isPrimary()) {
                    userRealmInfo.setPrimaryUserStoreInfo(userStoreInfo);
                }
                storeInfoList.add(userStoreInfo);
                userRealmInfo.setBulkImportSupported(secondaryManager.isBulkImportSupported());
                String domainName = secondaryConfig.getUserStoreProperty("DomainName");
                if (domainName == null || domainName.trim().length() <= 0) continue;
                domainNames.add(domainName.toUpperCase());
            } while ((secondaryManager = secondaryManager.getSecondaryUserStoreManager()) != null);
            if (storeInfoList.size() > 1) {
                userRealmInfo.setMultipleUserStore(true);
            }
            userRealmInfo.setUserStoresInfo(storeInfoList.toArray(new UserStoreInfo[storeInfoList.size()]));
            userRealmInfo.setDomainNames(domainNames.toArray(new String[domainNames.size()]));
            String itemsPerPageString = realmConfig.getRealmProperty("MaxItemsPerUserMgtUIPage");
            int itemsPerPage = 15;
            try {
                itemsPerPage = Integer.parseInt(itemsPerPageString);
            }
            catch (Exception e) {
                // empty catch block
            }
            userRealmInfo.setMaxItemsPerUIPage(itemsPerPage);
            String maxPageInCacheString = realmConfig.getRealmProperty("MaxUserMgtUIPagesInCache");
            int maxPagesInCache = 6;
            try {
                maxPagesInCache = Integer.parseInt(maxPageInCacheString);
            }
            catch (Exception e) {
                // empty catch block
            }
            userRealmInfo.setMaxUIPagesInCache(maxPagesInCache);
            String enableUIPageCacheString = realmConfig.getRealmProperty("EnableUserMgtUIPageCache");
            boolean enableUIPageCache = true;
            if ("false".equals(enableUIPageCacheString)) {
                enableUIPageCache = false;
            }
            userRealmInfo.setEnableUIPageCache(enableUIPageCache);
        }
        catch (Exception e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        return userRealmInfo;
    }

    private UserStoreInfo getUserStoreInfo(RealmConfiguration realmConfig, UserStoreManager manager) throws UserAdminException {
        try {
            UserStoreInfo info = new UserStoreInfo();
            info.setReadOnly(manager.isReadOnly());
            info.setPasswordsExternallyManaged(realmConfig.isPasswordsExternallyManaged());
            info.setPasswordRegEx(realmConfig.getUserStoreProperty("PasswordJavaScriptRegEx"));
            info.setUserNameRegEx(realmConfig.getUserStoreProperty("UsernameJavaScriptRegEx"));
            if (MultitenantUtils.isEmailUserName()) {
                String regEx = null;
                regEx = realmConfig.getUserStoreProperty("UsernameWithEmailJavaScriptRegEx");
                if (regEx != null) {
                    info.setUserNameRegEx(regEx);
                } else {
                    info.setUserNameRegEx("^([a-zA-Z0-9_\\.\\-])+\\@(([a-zA-Z0-9\\-])+\\.)+([a-zA-Z0-9]{2,4})+$");
                }
            }
            info.setRoleNameRegEx(realmConfig.getUserStoreProperty("RolenameJavaScriptRegEx"));
            info.setExternalIdP(realmConfig.getUserStoreProperty("ExternalIdP"));
            info.setBulkImportSupported(this.isBulkImportSupported());
            info.setDomainName(realmConfig.getUserStoreProperty("DomainName"));
            return info;
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    private boolean isBulkImportSupported() throws UserAdminException {
        try {
            UserStoreManager userStoreManager = this.realm.getUserStoreManager();
            if (userStoreManager != null) {
                return userStoreManager.isBulkImportSupported();
            }
            throw new UserAdminException("Unable to retrieve user store manager from realm.");
        }
        catch (UserStoreException e) {
            throw new UserAdminException("An error occurred while retrieving user store from realm.", e);
        }
    }

    public void addUser(String userName, String password, String[] roles, ClaimValue[] claims, String profileName) throws UserAdminException {
        try {
            RealmConfiguration realmConfig = this.realm.getRealmConfiguration();
            if (realmConfig.getUserStoreProperty("ExternalIdP") != null) {
                throw new UserAdminException("Please contact your external Identity Provider to add users");
            }
            if (roles != null && roles.length > 0) {
                String loggedInUserName = this.getLoggedInUser();
                Arrays.sort(roles);
                boolean isRoleHasAdminPermission = false;
                for (String role : roles) {
                    isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(role, "/permission", "ui.execute");
                    if (!isRoleHasAdminPermission) {
                        isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(role, "/permission/admin", "ui.execute");
                    }
                    if (isRoleHasAdminPermission) break;
                }
                if (isRoleHasAdminPermission && !realmConfig.getAdminUserName().equalsIgnoreCase(loggedInUserName)) {
                    log.warn((Object)("An attempt to assign user " + userName + " " + "to Admin permission role by user : " + loggedInUserName));
                    throw new UserStoreException("You have not privilege to assign user to Admin permission role");
                }
            }
            UserStoreManager admin = this.realm.getUserStoreManager();
            HashMap<String, String> claimMap = new HashMap<String, String>();
            if (claims != null) {
                for (ClaimValue claimValue : claims) {
                    claimMap.put(claimValue.getClaimURI(), claimValue.getValue());
                }
            }
            admin.addUser(userName, (Object)password, roles, claimMap, profileName, false);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void changePassword(String userName, String newPassword) throws UserAdminException {
        try {
            String loggedInUserName = this.getLoggedInUser();
            if (loggedInUserName != null && loggedInUserName.equalsIgnoreCase(userName)) {
                log.warn((Object)("An attempt to change password with out providing old password : " + loggedInUserName));
                throw new UserStoreException("An attempt to change password with out providing old password");
            }
            RealmConfiguration realmConfig = this.realm.getRealmConfiguration();
            if (realmConfig.getAdminUserName().equalsIgnoreCase(userName) && !realmConfig.getAdminUserName().equalsIgnoreCase(loggedInUserName)) {
                log.warn((Object)("An attempt to change password of Admin user by user : " + loggedInUserName));
                throw new UserStoreException("You have not privilege to change password of Admin user");
            }
            if (userName != null) {
                boolean isUserHadAdminPermission = this.realm.getAuthorizationManager().isUserAuthorized(userName, "/permission", "ui.execute");
                if (!isUserHadAdminPermission) {
                    isUserHadAdminPermission = this.realm.getAuthorizationManager().isUserAuthorized(userName, "/permission/admin", "ui.execute");
                }
                if (isUserHadAdminPermission && !realmConfig.getAdminUserName().equalsIgnoreCase(loggedInUserName)) {
                    log.warn((Object)("An attempt to change password of user has admin permission by user : " + loggedInUserName));
                    throw new UserStoreException("You have not privilege to change password of user has admin permission");
                }
            }
            this.realm.getUserStoreManager().updateCredentialByAdmin(userName, (Object)newPassword);
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void deleteUser(String userName, Registry registry) throws UserAdminException {
        try {
            String loggedInUserName = this.getLoggedInUser();
            RealmConfiguration realmConfig = this.realm.getRealmConfiguration();
            if (realmConfig.getAdminUserName().equalsIgnoreCase(userName) && !realmConfig.getAdminUserName().equalsIgnoreCase(loggedInUserName)) {
                log.warn((Object)("An attempt to delete Admin user by user : " + loggedInUserName));
                throw new UserStoreException("You have not privilege to delete Admin user");
            }
            if (userName != null) {
                boolean isUserHadAdminPermission = this.realm.getAuthorizationManager().isUserAuthorized(userName, "/permission", "ui.execute");
                if (!isUserHadAdminPermission) {
                    isUserHadAdminPermission = this.realm.getAuthorizationManager().isUserAuthorized(userName, "/permission/admin", "ui.execute");
                }
                if (isUserHadAdminPermission && !realmConfig.getAdminUserName().equalsIgnoreCase(loggedInUserName)) {
                    log.warn((Object)("An attempt to delete user user has Admin permission by user : " + loggedInUserName));
                    throw new UserStoreException("You have not privilege to delete user has Admin permission");
                }
            }
            this.realm.getUserStoreManager().deleteUser(userName);
            String path = "/users/" + userName;
            if (registry.resourceExists(path)) {
                registry.delete(path);
            }
        }
        catch (RegistryException e) {
            String msg = "Error deleting user from registry " + e.getMessage();
            log.error((Object)msg, (Throwable)e);
            throw new UserAdminException(msg, e);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void addRole(String roleName, String[] userList, String[] permissions, boolean isSharedRole) throws UserAdminException {
        try {
            String loggedInUserName = this.getLoggedInUser();
            if (permissions != null && !this.realm.getRealmConfiguration().getAdminUserName().equalsIgnoreCase(loggedInUserName)) {
                Arrays.sort(permissions);
                if (Arrays.binarySearch(permissions, "/permission/admin") > -1 || Arrays.binarySearch(permissions, "/permission/admin/") > -1 || Arrays.binarySearch(permissions, "/permission") > -1 || Arrays.binarySearch(permissions, "/permission/") > -1 || Arrays.binarySearch(permissions, "/permission/protected") > -1 || Arrays.binarySearch(permissions, "/permission/protected/") > -1) {
                    log.warn((Object)("An attempt to create role with admin permission by user " + loggedInUserName));
                    throw new UserStoreException("You have not privilege to create a role with Admin permission");
                }
            }
            UserStoreManager usAdmin = this.realm.getUserStoreManager();
            UserStoreManager secManager = null;
            secManager = roleName.contains("/") ? usAdmin.getSecondaryUserStoreManager(roleName.substring(0, roleName.indexOf("/"))) : usAdmin;
            if (secManager == null) {
                throw new UserAdminException("Invalid Domain");
            }
            if (secManager.isReadOnly() || "false".equals(secManager.getRealmConfiguration().getUserStoreProperty("WriteGroups"))) {
                throw new UserAdminException("Read only user store or Role creation is disabled");
            }
            usAdmin.addRole(roleName, userList, ManagementPermissionUtil.getRoleUIPermissions(roleName, permissions), isSharedRole);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void addInternalRole(String roleName, String[] userList, String[] permissions) throws UserAdminException {
        try {
            UserStoreManager usAdmin;
            String loggedInUserName = this.getLoggedInUser();
            if (permissions != null && !this.realm.getRealmConfiguration().getAdminUserName().equalsIgnoreCase(loggedInUserName)) {
                Arrays.sort(permissions);
                if (Arrays.binarySearch(permissions, "/permission/admin") > -1 || Arrays.binarySearch(permissions, "/permission/admin/") > -1 || Arrays.binarySearch(permissions, "/permission") > -1 || Arrays.binarySearch(permissions, "/permission/") > -1 || Arrays.binarySearch(permissions, "/permission/protected") > -1 || Arrays.binarySearch(permissions, "/permission/protected/") > -1) {
                    log.warn((Object)("An attempt to create role with admin permission by user " + loggedInUserName));
                    throw new UserStoreException("You have not privilege to create a role with Admin permission");
                }
            }
            if (!((usAdmin = this.realm.getUserStoreManager()) instanceof AbstractUserStoreManager)) {
                throw new UserStoreException("Internal role can not be created");
            }
            ((AbstractUserStoreManager)usAdmin).addRole("Internal/" + roleName, userList, null, false);
            ManagementPermissionUtil.updateRoleUIPermission("Internal/" + roleName, permissions);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void updateRoleName(String roleName, String newRoleName) throws UserAdminException {
        try {
            String loggedInUserName = this.getLoggedInUser();
            String roleWithoutDN = roleName.split("@")[0];
            boolean isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleWithoutDN, "/permission", "ui.execute");
            if (!isRoleHasAdminPermission) {
                isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleWithoutDN, "/permission/admin", "ui.execute");
            }
            if (isRoleHasAdminPermission && !this.realm.getRealmConfiguration().getAdminUserName().equalsIgnoreCase(loggedInUserName)) {
                log.warn((Object)("An attempt to rename role with admin permission by user " + loggedInUserName));
                throw new UserStoreException("You have not privilege to rename a role with Admin permission");
            }
            UserStoreManager usAdmin = this.realm.getUserStoreManager();
            usAdmin.updateRoleName(roleName, newRoleName);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void deleteRole(String roleName) throws UserAdminException {
        try {
            String loggedInUserName = this.getLoggedInUser();
            boolean isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleName, "/permission", "ui.execute");
            if (!isRoleHasAdminPermission) {
                isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleName, "/permission/admin", "ui.execute");
            }
            if (isRoleHasAdminPermission && !this.realm.getRealmConfiguration().getAdminUserName().equalsIgnoreCase(loggedInUserName)) {
                log.warn((Object)("An attempt to delete role with admin permission by user " + loggedInUserName));
                throw new UserStoreException("You have not privilege to delete a role with Admin permission");
            }
            this.realm.getUserStoreManager().deleteRole(roleName);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public FlaggedName[] getUsersOfRole(String roleName, String filter, int limit) throws UserAdminException {
        try {
            String domain;
            int index = roleName != null ? roleName.indexOf("/") : -1;
            boolean domainProvided = index > 0;
            String string = domain = domainProvided ? roleName.substring(0, index) : null;
            if (domain != null && filter != null && !filter.toLowerCase().startsWith(domain.toLowerCase()) && !"Internal".equalsIgnoreCase(domain)) {
                filter = domain + "/" + filter;
            }
            if (domain == null && limit != 0) {
                filter = filter != null ? "/" + filter : "/*";
            }
            UserStoreManager usMan = this.realm.getUserStoreManager();
            Object[] usersOfRole = usMan.getUserListOfRole(roleName);
            Arrays.sort(usersOfRole);
            HashMap<String, Integer> userCount = new HashMap<String, Integer>();
            if (limit == 0) {
                filter = filter.replace("*", ".*");
                Pattern pattern = Pattern.compile(filter, 2);
                ArrayList<FlaggedName> flaggedNames = new ArrayList<FlaggedName>();
                for (Object anUsersOfRole : usersOfRole) {
                    int combinerIndex = ((String)anUsersOfRole).indexOf("|");
                    Matcher matcher = combinerIndex > 0 ? pattern.matcher(((String)anUsersOfRole).substring(combinerIndex + 1)) : pattern.matcher((CharSequence)anUsersOfRole);
                    if (!matcher.matches()) continue;
                    FlaggedName fName = new FlaggedName();
                    fName.setSelected(true);
                    if (combinerIndex > 0) {
                        fName.setItemName(((String)anUsersOfRole).substring(0, combinerIndex));
                        fName.setItemDisplayName(((String)anUsersOfRole).substring(combinerIndex + 1));
                    } else {
                        fName.setItemName((String)anUsersOfRole);
                        fName.setItemDisplayName((String)anUsersOfRole);
                    }
                    if (domain != null && !"Internal".equalsIgnoreCase(domain)) {
                        if (usMan.getSecondaryUserStoreManager(domain) != null && (usMan.getSecondaryUserStoreManager(domain).isReadOnly() || "false".equals(usMan.getSecondaryUserStoreManager(domain).getRealmConfiguration().getUserStoreProperty("WriteGroups")))) {
                            fName.setEditable(false);
                        } else {
                            fName.setEditable(true);
                        }
                    } else if (usMan.isReadOnly() || usMan.getSecondaryUserStoreManager(domain) != null && "false".equals(usMan.getRealmConfiguration().getUserStoreProperty("WriteGroups"))) {
                        fName.setEditable(false);
                    } else {
                        fName.setEditable(true);
                    }
                    if (domain != null) {
                        if (userCount.containsKey(domain)) {
                            userCount.put(domain, (Integer)userCount.get(domain) + 1);
                        } else {
                            userCount.put(domain, 1);
                        }
                    } else if (userCount.containsKey("PRIMARY")) {
                        userCount.put("PRIMARY", (Integer)userCount.get("PRIMARY") + 1);
                    } else {
                        userCount.put("PRIMARY", 1);
                    }
                    flaggedNames.add(fName);
                }
                String exceededDomains = "";
                boolean isPrimaryExceeding = false;
                Map maxUserListCount = ((AbstractUserStoreManager)this.realm.getUserStoreManager()).getMaxListCount("MaxUserNameListLength");
                String[] domains = userCount.keySet().toArray(new String[userCount.keySet().size()]);
                for (int i = 0; i < domains.length; ++i) {
                    if ("PRIMARY".equals(domains[i])) {
                        if (!((Integer)userCount.get("PRIMARY")).equals(maxUserListCount.get("PRIMARY"))) continue;
                        isPrimaryExceeding = true;
                        continue;
                    }
                    if (!((Integer)userCount.get(domains[i])).equals(maxUserListCount.get(domains[i].toUpperCase()))) continue;
                    exceededDomains = exceededDomains + domains[i];
                    if (i == domains.length - 1) continue;
                    exceededDomains = exceededDomains + ":";
                }
                FlaggedName flaggedName = new FlaggedName();
                if (isPrimaryExceeding) {
                    flaggedName.setItemName("true");
                } else {
                    flaggedName.setItemName("false");
                }
                flaggedName.setItemDisplayName(exceededDomains);
                flaggedNames.add(flaggedName);
                return flaggedNames.toArray(new FlaggedName[flaggedNames.size()]);
            }
            String[] userNames = usMan.listUsers(filter, limit);
            FlaggedName[] flaggedNames = new FlaggedName[userNames.length + 1];
            for (int i = 0; i < userNames.length; ++i) {
                int combinerIndex;
                FlaggedName fName = new FlaggedName();
                fName.setItemName(userNames[i]);
                if (Arrays.binarySearch(usersOfRole, userNames[i]) > -1) {
                    fName.setSelected(true);
                }
                if ((combinerIndex = userNames[i].indexOf("|")) > 0) {
                    fName.setItemName(userNames[i].substring(0, combinerIndex));
                    fName.setItemDisplayName(userNames[i].substring(combinerIndex + 1));
                } else {
                    fName.setItemName(userNames[i]);
                }
                if (domain != null && !"Internal".equalsIgnoreCase(domain)) {
                    if (usMan.getSecondaryUserStoreManager(domain) != null && (usMan.getSecondaryUserStoreManager(domain).isReadOnly() || "false".equals(usMan.getSecondaryUserStoreManager(domain).getRealmConfiguration().getUserStoreProperty("WriteGroups")))) {
                        fName.setEditable(false);
                    } else {
                        fName.setEditable(true);
                    }
                } else if (usMan.isReadOnly() || usMan.getSecondaryUserStoreManager(domain) != null && "false".equals(usMan.getRealmConfiguration().getUserStoreProperty("WriteGroups"))) {
                    fName.setEditable(false);
                } else {
                    fName.setEditable(true);
                }
                if (domain != null) {
                    if (userCount.containsKey(domain)) {
                        userCount.put(domain, (Integer)userCount.get(domain) + 1);
                    } else {
                        userCount.put(domain, 1);
                    }
                } else if (userCount.containsKey("PRIMARY")) {
                    userCount.put("PRIMARY", (Integer)userCount.get("PRIMARY") + 1);
                } else {
                    userCount.put("PRIMARY", 1);
                }
                flaggedNames[i] = fName;
            }
            String exceededDomains = "";
            boolean isPrimaryExceeding = false;
            Map maxUserListCount = ((AbstractUserStoreManager)this.realm.getUserStoreManager()).getMaxListCount("MaxUserNameListLength");
            String[] domains = userCount.keySet().toArray(new String[userCount.keySet().size()]);
            for (int i = 0; i < domains.length; ++i) {
                if ("PRIMARY".equals(domains[i])) {
                    if (!((Integer)userCount.get("PRIMARY")).equals(maxUserListCount.get("PRIMARY"))) continue;
                    isPrimaryExceeding = true;
                    continue;
                }
                if (!((Integer)userCount.get(domains[i])).equals(maxUserListCount.get(domains[i].toUpperCase()))) continue;
                exceededDomains = exceededDomains + domains[i];
                if (i == domains.length - 1) continue;
                exceededDomains = exceededDomains + ":";
            }
            FlaggedName flaggedName = new FlaggedName();
            if (isPrimaryExceeding) {
                flaggedName.setItemName("true");
            } else {
                flaggedName.setItemName("false");
            }
            flaggedName.setItemDisplayName(exceededDomains);
            flaggedNames[flaggedNames.length - 1] = flaggedName;
            return flaggedNames;
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public FlaggedName[] getRolesOfUser(String userName, String filter, int limit) throws UserAdminException {
        try {
            FlaggedName fname;
            String domain;
            int index = userName != null ? userName.indexOf("/") : -1;
            boolean domainProvided = index > 0;
            String string = domain = domainProvided ? userName.substring(0, index) : null;
            if (filter == null) {
                filter = "*";
            }
            UserStoreManager admin = this.realm.getUserStoreManager();
            Object[] userRoles = ((AbstractUserStoreManager)admin).getRoleListOfUser(userName);
            HashMap<String, Integer> userCount = new HashMap<String, Integer>();
            if (limit == 0) {
                Object[] hybridRoles;
                String modifiedFilter = filter;
                if (filter.contains("/")) {
                    modifiedFilter = filter.substring(filter.indexOf("/") + 1);
                }
                if ((hybridRoles = ((AbstractUserStoreManager)admin).getHybridRoles(modifiedFilter)) != null) {
                    Arrays.sort(hybridRoles);
                }
                modifiedFilter = modifiedFilter.replace("*", ".*");
                Pattern pattern = Pattern.compile(modifiedFilter, 2);
                ArrayList<FlaggedName> flaggedNames = new ArrayList<FlaggedName>();
                Object[] arr$ = userRoles;
                int len$ = arr$.length;
                for (int i$ = 0; i$ < len$; ++i$) {
                    Matcher matcher;
                    Object role;
                    Object matchingRole = role = arr$[i$];
                    String roleDomain = null;
                    if (((String)matchingRole).contains("/")) {
                        matchingRole = ((String)matchingRole).substring(((String)matchingRole).indexOf("/") + 1);
                        if (filter.contains("/")) {
                            roleDomain = ((String)role).substring(0, ((String)role).indexOf("/") + 1);
                        }
                    }
                    if (hybridRoles != null && Arrays.binarySearch(hybridRoles, role) > -1 ? !(matcher = pattern.matcher((CharSequence)matchingRole)).matches() || roleDomain != null && !filter.toLowerCase().startsWith(roleDomain.toLowerCase()) : !(matcher = pattern.matcher((CharSequence)matchingRole)).matches() || roleDomain != null && !filter.toLowerCase().startsWith(roleDomain.toLowerCase())) continue;
                    FlaggedName fName = new FlaggedName();
                    this.mapEntityName((String)role, fName, admin);
                    fName.setSelected(true);
                    if (domain != null && !"Internal".equalsIgnoreCase(domain)) {
                        if ((admin.getSecondaryUserStoreManager(domain).isReadOnly() || admin.getSecondaryUserStoreManager(domain).getRealmConfiguration().getUserStoreProperty("WriteGroups") != null && admin.getSecondaryUserStoreManager(domain).getRealmConfiguration().getUserStoreProperty("WriteGroups").equals("false")) && hybridRoles != null && Arrays.binarySearch(hybridRoles, role) < 0) {
                            fName.setEditable(false);
                        } else {
                            fName.setEditable(true);
                        }
                    } else if ((admin.isReadOnly() || admin.getRealmConfiguration().getUserStoreProperty("WriteGroups") != null && admin.getRealmConfiguration().getUserStoreProperty("WriteGroups").equals("false")) && hybridRoles != null && Arrays.binarySearch(hybridRoles, role) < 0) {
                        fName.setEditable(false);
                    } else {
                        fName.setEditable(true);
                    }
                    if (domain != null) {
                        if (userCount.containsKey(domain)) {
                            userCount.put(domain, (Integer)userCount.get(domain) + 1);
                        } else {
                            userCount.put(domain, 1);
                        }
                    } else if (userCount.containsKey("PRIMARY")) {
                        userCount.put("PRIMARY", (Integer)userCount.get("PRIMARY") + 1);
                    } else {
                        userCount.put("PRIMARY", 1);
                    }
                    flaggedNames.add(fName);
                }
                String exceededDomains = "";
                boolean isPrimaryExceeding = false;
                Map maxUserListCount = ((AbstractUserStoreManager)this.realm.getUserStoreManager()).getMaxListCount("MaxRoleNameListLength");
                String[] domains = userCount.keySet().toArray(new String[userCount.keySet().size()]);
                for (int i = 0; i < domains.length; ++i) {
                    if ("PRIMARY".equals(domains[i])) {
                        if (!((Integer)userCount.get("PRIMARY")).equals(maxUserListCount.get("PRIMARY"))) continue;
                        isPrimaryExceeding = true;
                        continue;
                    }
                    if (!((Integer)userCount.get(domains[i])).equals(maxUserListCount.get(domains[i].toUpperCase()))) continue;
                    exceededDomains = exceededDomains + domains[i];
                    if (i == domains.length - 1) continue;
                    exceededDomains = exceededDomains + ":";
                }
                FlaggedName flaggedName = new FlaggedName();
                if (isPrimaryExceeding) {
                    flaggedName.setItemName("true");
                } else {
                    flaggedName.setItemName("false");
                }
                flaggedName.setItemDisplayName(exceededDomains);
                flaggedNames.add(flaggedName);
                return flaggedNames.toArray(new FlaggedName[flaggedNames.size()]);
            }
            String[] internalRoles = null;
            String[] externalRoles = null;
            if (filter.toLowerCase().startsWith("Internal".toLowerCase())) {
                if (admin instanceof AbstractUserStoreManager) {
                    filter = filter.substring(filter.indexOf("/") + 1);
                    internalRoles = ((AbstractUserStoreManager)admin).getHybridRoles(filter);
                } else {
                    internalRoles = admin.getHybridRoles();
                }
            } else if (domain != null && filter.toLowerCase().startsWith(domain.toLowerCase() + "/")) {
                externalRoles = admin instanceof AbstractUserStoreManager ? ((AbstractUserStoreManager)admin).getRoleNames(filter, limit, true, true, true) : admin.getRoleNames();
            } else {
                internalRoles = admin instanceof AbstractUserStoreManager ? ((AbstractUserStoreManager)admin).getHybridRoles(filter) : admin.getHybridRoles();
                filter = domain == null ? "/" + filter : domain + "/" + filter;
                externalRoles = admin instanceof AbstractUserStoreManager ? ((AbstractUserStoreManager)admin).getRoleNames(filter, limit, true, true, true) : admin.getRoleNames();
            }
            ArrayList<FlaggedName> flaggedNames = new ArrayList<FlaggedName>();
            Arrays.sort(userRoles);
            if (externalRoles != null) {
                for (String externalRole : externalRoles) {
                    fname = new FlaggedName();
                    this.mapEntityName(externalRole, fname, admin);
                    fname.setDomainName(domain);
                    if (Arrays.binarySearch(userRoles, externalRole) > -1) {
                        fname.setSelected(true);
                    }
                    if (domain != null) {
                        UserStoreManager secManager = admin.getSecondaryUserStoreManager(domain);
                        if (secManager.isReadOnly() || "false".equals(secManager.getRealmConfiguration().getUserStoreProperty("WriteGroups"))) {
                            fname.setEditable(false);
                        } else {
                            fname.setEditable(true);
                        }
                    } else if (admin.isReadOnly() || "false".equals(admin.getRealmConfiguration().getUserStoreProperty("WriteGroups"))) {
                        fname.setEditable(false);
                    } else {
                        fname.setEditable(true);
                    }
                    if (domain != null) {
                        if (userCount.containsKey(domain)) {
                            userCount.put(domain, (Integer)userCount.get(domain) + 1);
                        } else {
                            userCount.put(domain, 1);
                        }
                    } else if (userCount.containsKey("PRIMARY")) {
                        userCount.put("PRIMARY", (Integer)userCount.get("PRIMARY") + 1);
                    } else {
                        userCount.put("PRIMARY", 1);
                    }
                    flaggedNames.add(fname);
                }
            }
            if (internalRoles != null) {
                for (String internalRole : internalRoles) {
                    fname = new FlaggedName();
                    fname.setItemName(internalRole);
                    fname.setDomainName("Internal");
                    if (Arrays.binarySearch(userRoles, internalRole) > -1) {
                        fname.setSelected(true);
                    }
                    fname.setEditable(true);
                    flaggedNames.add(fname);
                }
            }
            String exceededDomains = "";
            boolean isPrimaryExceeding = false;
            Map maxUserListCount = ((AbstractUserStoreManager)this.realm.getUserStoreManager()).getMaxListCount("MaxRoleNameListLength");
            String[] domains = userCount.keySet().toArray(new String[userCount.keySet().size()]);
            for (int i = 0; i < domains.length; ++i) {
                if ("PRIMARY".equals(domains[i])) {
                    if (!((Integer)userCount.get("PRIMARY")).equals(maxUserListCount.get("PRIMARY"))) continue;
                    isPrimaryExceeding = true;
                    continue;
                }
                if (!((Integer)userCount.get(domains[i])).equals(maxUserListCount.get(domains[i].toUpperCase()))) continue;
                exceededDomains = exceededDomains + domains[i];
                if (i == domains.length - 1) continue;
                exceededDomains = exceededDomains + ":";
            }
            FlaggedName flaggedName = new FlaggedName();
            if (isPrimaryExceeding) {
                flaggedName.setItemName("true");
            } else {
                flaggedName.setItemName("false");
            }
            flaggedName.setItemDisplayName(exceededDomains);
            flaggedNames.add(flaggedName);
            return flaggedNames.toArray(new FlaggedName[flaggedNames.size()]);
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void updateUsersOfRole(String roleName, FlaggedName[] userList) throws UserAdminException {
        try {
            if ("system/wso2.anonymous.role".equalsIgnoreCase(roleName)) {
                log.error((Object)"Security Alert! Carbon anonymous role is being manipulated");
                throw new UserStoreException("Invalid data");
            }
            if (this.realm.getRealmConfiguration().getEveryOneRoleName().equalsIgnoreCase(roleName)) {
                log.error((Object)"Security Alert! Carbon Everyone role is being manipulated");
                throw new UserStoreException("Invalid data");
            }
            UserStoreManager admin = this.realm.getUserStoreManager();
            Object[] oldUserList = admin.getUserListOfRole(roleName);
            ArrayList<Object> list = new ArrayList<Object>();
            if (oldUserList != null) {
                for (Object value : oldUserList) {
                    int combinerIndex = ((String)value).indexOf("|");
                    if (combinerIndex > 0) {
                        list.add(((String)value).substring(0, combinerIndex));
                        continue;
                    }
                    list.add(value);
                }
                oldUserList = list.toArray(new String[list.size()]);
            }
            Arrays.sort(oldUserList);
            ArrayList<String> delUsers = new ArrayList<String>();
            ArrayList<String> addUsers = new ArrayList<String>();
            for (FlaggedName fName : userList) {
                boolean isSelected = fName.isSelected();
                String userName = fName.getItemName();
                if ("wso2.anonymous.user".equalsIgnoreCase(userName)) {
                    log.error((Object)"Security Alert! Carbon anonymous user is being manipulated");
                    return;
                }
                int oldindex = Arrays.binarySearch(oldUserList, userName);
                if (oldindex > -1 && !isSelected) {
                    delUsers.add(userName);
                    continue;
                }
                if (oldindex >= 0 || !isSelected) continue;
                addUsers.add(userName);
            }
            String loggedInUserName = this.getLoggedInUser();
            RealmConfiguration realmConfig = this.realm.getRealmConfiguration();
            boolean isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleName, "/permission/", "ui.execute");
            if (!isRoleHasAdminPermission) {
                isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleName, "/permission/admin/", "ui.execute");
            }
            if ((realmConfig.getAdminRoleName().equalsIgnoreCase(roleName) || isRoleHasAdminPermission) && !realmConfig.getAdminUserName().equalsIgnoreCase(loggedInUserName)) {
                log.warn((Object)("An attempt to add or remove users from Admin role by user : " + loggedInUserName));
                throw new UserStoreException("Can not add or remove user from Admin permission role");
            }
            Object[] delUsersArray = null;
            String[] addUsersArray = null;
            Object[] users = this.realm.getUserStoreManager().getUserListOfRole(roleName);
            if (users == null) {
                Arrays.sort(users);
            }
            if (delUsers != null && users != null) {
                delUsersArray = delUsers.toArray(new String[delUsers.size()]);
                Arrays.sort(delUsersArray);
                if (Arrays.binarySearch(delUsersArray, loggedInUserName) > -1 && Arrays.binarySearch(users, loggedInUserName) > -1 && !realmConfig.getAdminUserName().equalsIgnoreCase(loggedInUserName)) {
                    log.warn((Object)("An attempt to remove from role : " + roleName + " by user :" + loggedInUserName));
                    throw new UserStoreException("Can not remove yourself from role : " + roleName);
                }
            }
            if (addUsers != null) {
                addUsersArray = addUsers.toArray(new String[addUsers.size()]);
            }
            admin.updateUserListOfRole(roleName, delUsersArray, addUsersArray);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void updateRolesOfUser(String userName, String[] roleList) throws UserAdminException {
        try {
            if ("wso2.anonymous.user".equalsIgnoreCase(userName)) {
                log.error((Object)"Security Alert! Carbon anonymous user is being manipulated");
                throw new UserAdminException("Invalid data");
            }
            if (roleList != null) {
                String loggedInUserName = this.getLoggedInUser();
                RealmConfiguration realmConfig = this.realm.getRealmConfiguration();
                Arrays.sort(roleList);
                Object[] roles = this.realm.getUserStoreManager().getRoleListOfUser(userName);
                if (roles != null) {
                    Arrays.sort(roles);
                }
                boolean isUserHasAdminPermission = false;
                String adminPermissionRole = null;
                for (Object role : roles) {
                    isUserHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized((String)role, "/permission", "ui.execute");
                    if (!isUserHasAdminPermission) {
                        isUserHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized((String)role, "/permission/admin", "ui.execute");
                    }
                    if (isUserHasAdminPermission) break;
                }
                for (String roleName : roleList) {
                    boolean isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleName, "/permission", "ui.execute");
                    if (!isRoleHasAdminPermission) {
                        isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleName, "/permission/admin", "ui.execute");
                    }
                    if (!isRoleHasAdminPermission) continue;
                    adminPermissionRole = roleName;
                    break;
                }
                if (roles == null || Arrays.binarySearch(roles, realmConfig.getAdminRoleName()) < 0) {
                    if ((Arrays.binarySearch(roleList, realmConfig.getAdminRoleName()) > -1 || !isUserHasAdminPermission && adminPermissionRole != null) && !realmConfig.getAdminUserName().equalsIgnoreCase(loggedInUserName)) {
                        log.warn((Object)("An attempt to add users to Admin permission role by user : " + loggedInUserName));
                        throw new UserStoreException("Can not add users to Admin permission role");
                    }
                } else if (Arrays.binarySearch(roleList, realmConfig.getAdminRoleName()) < 0 && !realmConfig.getAdminUserName().equalsIgnoreCase(loggedInUserName)) {
                    log.warn((Object)("An attempt to remove users from Admin role by user : " + loggedInUserName));
                    throw new UserStoreException("Can not remove users from Admin role");
                }
            }
            UserStoreManager admin = this.realm.getUserStoreManager();
            Object[] oldRoleList = admin.getRoleListOfUser(userName);
            Arrays.sort(roleList);
            Arrays.sort(oldRoleList);
            ArrayList<Object> delRoles = new ArrayList<Object>();
            ArrayList<String> addRoles = new ArrayList<String>();
            for (String name : roleList) {
                int oldindex = Arrays.binarySearch(oldRoleList, name);
                if (oldindex >= 0) continue;
                addRoles.add(name);
            }
            for (Object name : oldRoleList) {
                int newindex = Arrays.binarySearch(roleList, name);
                if (newindex >= 0) continue;
                if (this.realm.getRealmConfiguration().getEveryOneRoleName().equalsIgnoreCase((String)name)) {
                    log.error((Object)"Security Alert! Carbon everyone role is being manipulated");
                    throw new UserAdminException("Invalid data");
                }
                delRoles.add(name);
            }
            admin.updateRoleListOfUser(userName, delRoles.toArray(new String[delRoles.size()]), addRoles.toArray(new String[addRoles.size()]));
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void updateUsersOfRole(String roleName, String[] newUsers, String[] deleteUsers) throws UserAdminException {
        try {
            RealmConfiguration realmConfig;
            String loggedInUserName = this.getLoggedInUser();
            if ("system/wso2.anonymous.role".equalsIgnoreCase(roleName)) {
                log.error((Object)("Security Alert! Carbon anonymous role is being manipulated by user " + loggedInUserName));
                throw new UserStoreException("Invalid data");
            }
            if (this.realm.getRealmConfiguration().getEveryOneRoleName().equalsIgnoreCase(roleName)) {
                log.error((Object)("Security Alert! Carbon Everyone role is being manipulated by user " + loggedInUserName));
                throw new UserStoreException("Invalid data");
            }
            boolean isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleName, "/permission/", "ui.execute");
            if (!isRoleHasAdminPermission) {
                isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleName, "/permission/admin/", "ui.execute");
            }
            if (((realmConfig = this.realm.getRealmConfiguration()).getAdminRoleName().equalsIgnoreCase(roleName) || isRoleHasAdminPermission) && !realmConfig.getAdminUserName().equalsIgnoreCase(loggedInUserName)) {
                log.warn((Object)("An attempt to add or remove users from Admin role by user : " + loggedInUserName));
                throw new UserStoreException("You have not privilege to add or remove user from Admin permission role");
            }
            if (deleteUsers != null) {
                Arrays.sort(deleteUsers);
                if (realmConfig.getAdminRoleName().equalsIgnoreCase(roleName) && Arrays.binarySearch(deleteUsers, realmConfig.getAdminUserName()) > -1) {
                    log.warn((Object)("An attempt to remove Admin user from Admin role by user : " + loggedInUserName));
                    throw new UserStoreException("Can not remove Admin user from Admin role");
                }
            }
            UserStoreManager admin = this.realm.getUserStoreManager();
            Object[] oldUserList = admin.getUserListOfRole(roleName);
            ArrayList<String> list = new ArrayList<String>();
            if (oldUserList != null) {
                for (String string : oldUserList) {
                    int combinerIndex = string.indexOf("|");
                    if (combinerIndex > 0) {
                        list.add(string.substring(0, combinerIndex));
                        continue;
                    }
                    list.add(string);
                }
                oldUserList = list.toArray(new String[list.size()]);
                Arrays.sort(oldUserList);
            }
            ArrayList<String> delUser = new ArrayList<String>();
            ArrayList<String> addUsers = new ArrayList<String>();
            if (oldUserList != null) {
                if (newUsers != null) {
                    String[] arr$ = newUsers;
                    int n = arr$.length;
                    for (int i$ = 0; i$ < n; ++i$) {
                        String name = arr$[i$];
                        if (Arrays.binarySearch(oldUserList, name) >= 0) continue;
                        addUsers.add(name);
                    }
                    newUsers = addUsers.toArray(new String[addUsers.size()]);
                }
                if (deleteUsers != null) {
                    for (String name : deleteUsers) {
                        if (Arrays.binarySearch(oldUserList, name) <= -1) continue;
                        delUser.add(name);
                    }
                    deleteUsers = delUser.toArray(new String[delUser.size()]);
                }
            } else {
                deleteUsers = null;
            }
            admin.updateUserListOfRole(roleName, deleteUsers, newUsers);
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void updateRolesOfUser(String userName, String[] newRoles, String[] deletedRoles) throws UserAdminException {
        try {
            RealmConfiguration realmConfig;
            String loggedInUserName = this.getLoggedInUser();
            if ("wso2.anonymous.user".equalsIgnoreCase(userName)) {
                log.error((Object)("Security Alert! Carbon anonymous user is being manipulated by user " + loggedInUserName));
                throw new UserAdminException("Invalid data");
            }
            if (deletedRoles != null) {
                for (String name : deletedRoles) {
                    if (this.realm.getRealmConfiguration().getEveryOneRoleName().equalsIgnoreCase(name)) {
                        log.error((Object)("Security Alert! Carbon everyone role is being manipulated by user " + loggedInUserName));
                        throw new UserAdminException("Invalid data");
                    }
                    if (!this.realm.getRealmConfiguration().getAdminRoleName().equalsIgnoreCase(name) || !this.realm.getRealmConfiguration().getAdminUserName().equalsIgnoreCase(userName)) continue;
                    log.error((Object)("Can not remove admin user from admin role " + loggedInUserName));
                    throw new UserAdminException("Can not remove admin user from admin role");
                }
            }
            if (!(realmConfig = this.realm.getRealmConfiguration()).getAdminUserName().equalsIgnoreCase(loggedInUserName)) {
                boolean isUserHadAdminPermission = this.realm.getAuthorizationManager().isUserAuthorized(userName, "/permission", "ui.execute");
                if (!isUserHadAdminPermission) {
                    isUserHadAdminPermission = this.realm.getAuthorizationManager().isUserAuthorized(userName, "/permission/admin", "ui.execute");
                }
                if (newRoles != null) {
                    boolean isRoleHasAdminPermission = false;
                    for (String roleName : newRoles) {
                        if (roleName.equalsIgnoreCase(realmConfig.getAdminRoleName())) {
                            log.warn((Object)("An attempt to add users to Admin permission role by user : " + loggedInUserName));
                            throw new UserStoreException("Can not add users to Admin permission role");
                        }
                        isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleName, "/permission", "ui.execute");
                        if (!isRoleHasAdminPermission) {
                            isRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleName, "/permission/admin", "ui.execute");
                        }
                        if (isRoleHasAdminPermission) break;
                    }
                    if (!isUserHadAdminPermission && isRoleHasAdminPermission) {
                        log.warn((Object)("An attempt to add users to Admin permission role by user : " + loggedInUserName));
                        throw new UserStoreException("Can not add users to Admin permission role");
                    }
                }
                if (deletedRoles != null) {
                    boolean isRemoveRoleHasAdminPermission = false;
                    for (String roleName : deletedRoles) {
                        isRemoveRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleName, "/permission", "ui.execute");
                        if (!isRemoveRoleHasAdminPermission) {
                            isRemoveRoleHasAdminPermission = this.realm.getAuthorizationManager().isRoleAuthorized(roleName, "/permission/admin", "ui.execute");
                        }
                        if (isRemoveRoleHasAdminPermission) break;
                    }
                    if (isUserHadAdminPermission && isRemoveRoleHasAdminPermission) {
                        log.warn((Object)("An attempt to remove users from Admin role by user : " + loggedInUserName));
                        throw new UserStoreException("Can not remove users from Admin role");
                    }
                }
            }
            this.realm.getUserStoreManager().updateRoleListOfUser(userName, deletedRoles, newRoles);
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public UIPermissionNode getAllUIPermissions(int tenantId) throws UserAdminException {
        try {
            UIPermissionNode nodeRoot;
            Collection regRoot;
            UserRegistry registry = UserMgtDSComponent.getRegistryService().getGovernanceSystemRegistry();
            if (tenantId == -1234) {
                if (CarbonContext.getCurrentContext().getTenantId() != -1234) {
                    log.error((Object)"Illegal access attempt");
                    throw new UserStoreException("Illegal access attempt");
                }
                regRoot = (Collection)registry.get("/permission/");
                String displayName = regRoot.getProperty("name");
                nodeRoot = new UIPermissionNode("/permission/", displayName);
            } else {
                regRoot = (Collection)registry.get("/permission/admin/");
                String displayName = regRoot.getProperty("name");
                nodeRoot = new UIPermissionNode("/permission/admin/", displayName);
            }
            this.buildUIPermissionNode(regRoot, nodeRoot, (Registry)registry, null, null, null);
            return nodeRoot;
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public UIPermissionNode getRolePermissions(String roleName, int tenantId) throws UserAdminException {
        try {
            UIPermissionNode nodeRoot;
            Collection regRoot;
            UserRegistry registry = UserMgtDSComponent.getRegistryService().getGovernanceSystemRegistry();
            if (tenantId == -1234) {
                regRoot = (Collection)registry.get("/permission/");
                String displayName = regRoot.getProperty("name");
                nodeRoot = new UIPermissionNode("/permission/", displayName);
            } else {
                regRoot = (Collection)registry.get("/permission/admin/");
                String displayName = regRoot.getProperty("name");
                nodeRoot = new UIPermissionNode("/permission/admin/", displayName);
            }
            this.buildUIPermissionNode(regRoot, nodeRoot, (Registry)registry, this.realm.getAuthorizationManager(), roleName, null);
            return nodeRoot;
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void setRoleUIPermission(String roleName, String[] rawResources) throws UserAdminException {
        try {
            if (((AbstractUserStoreManager)this.realm.getUserStoreManager()).isOthersSharedRole(roleName)) {
                throw new UserAdminException("Logged in user is not authorized to assign permissions to a role belong to another tenant");
            }
            if (this.realm.getRealmConfiguration().getAdminRoleName().equalsIgnoreCase(roleName)) {
                String msg = "UI permissions of Admin is not allowed to change";
                log.error((Object)msg);
                throw new UserAdminException(msg);
            }
            String loggedInUserName = this.getLoggedInUser();
            if (rawResources != null && !this.realm.getRealmConfiguration().getAdminUserName().equalsIgnoreCase(loggedInUserName)) {
                Arrays.sort(rawResources);
                if (Arrays.binarySearch(rawResources, "/permission/admin") > -1 || Arrays.binarySearch(rawResources, "/permission/protected") > -1 || Arrays.binarySearch(rawResources, "/permission") > -1) {
                    log.warn((Object)("An attempt to Assign admin permission for role by user : " + loggedInUserName));
                    throw new UserStoreException("Can not assign Admin for permission role");
                }
            }
            String[] optimizedList = UserCoreUtil.optimizePermissions((String[])rawResources);
            AuthorizationManager authMan = this.realm.getAuthorizationManager();
            authMan.clearRoleActionOnAllResources(roleName, "ui.execute");
            for (String path : optimizedList) {
                authMan.authorizeRole(roleName, path, "ui.execute");
            }
        }
        catch (UserStoreException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public void bulkImportUsers(String fileName, InputStream inStream, String defaultPassword) throws UserAdminException {
        block5: {
            try {
                BulkImportConfig config = new BulkImportConfig(inStream, fileName);
                if (defaultPassword != null && defaultPassword.trim().length() > 0) {
                    config.setDefaultPassword(defaultPassword.trim());
                }
                UserStoreManager userStore = this.realm.getUserStoreManager();
                if (fileName.endsWith("csv")) {
                    CSVUserBulkImport csvAdder = new CSVUserBulkImport(config);
                    csvAdder.addUserList(userStore);
                    break block5;
                }
                if (fileName.endsWith("xls") || fileName.endsWith("xlsx")) {
                    ExcelUserBulkImport excelAdder = new ExcelUserBulkImport(config);
                    excelAdder.addUserList(userStore);
                    break block5;
                }
                throw new UserAdminException("Unsupported format");
            }
            catch (UserStoreException e) {
                throw new UserAdminException(e.getMessage(), e);
            }
        }
    }

    public void changePasswordByUser(String oldPassword, String newPassword) throws UserAdminException {
        try {
            String domainName;
            UserStoreManager userStore = this.realm.getUserStoreManager();
            HttpServletRequest request = (HttpServletRequest)MessageContext.getCurrentMessageContext().getProperty(HTTPConstants.MC_HTTP_SERVLETREQUEST);
            HttpSession httpSession = request.getSession(false);
            String userName = (String)httpSession.getAttribute("wso2carbon.admin.logged.in");
            int indexOne = userName.indexOf("/");
            if (indexOne < 0 && (domainName = (String)httpSession.getAttribute("logged_in_domain")) != null) {
                userName = domainName + "/" + userName;
            }
            userStore.updateCredential(userName, (Object)newPassword, (Object)oldPassword);
        }
        catch (UserStoreException e) {
            throw new UserAdminException(e.getMessage(), e);
        }
    }

    public boolean hasMultipleUserStores() throws UserAdminException {
        try {
            return this.realm.getUserStoreManager().getSecondaryUserStoreManager() != null;
        }
        catch (UserStoreException e) {
            log.error((Object)e);
            throw new UserAdminException("Unable to check for multiple user stores");
        }
    }

    private void buildUIPermissionNode(Collection parent, UIPermissionNode parentNode, Registry registry, AuthorizationManager authMan, String roleName, String userName) throws RegistryException, UserStoreException {
        boolean isSelected = false;
        if (roleName != null) {
            isSelected = authMan.isRoleAuthorized(roleName, parentNode.getResourcePath(), "ui.execute");
        } else if (userName != null) {
            isSelected = authMan.isUserAuthorized(userName, parentNode.getResourcePath(), "ui.execute");
        }
        if (isSelected) {
            this.buildUIPermissionNodeAllSelected(parent, parentNode, registry);
            parentNode.setSelected(true);
        } else {
            this.buildUIPermissionNodeNotAllSelected(parent, parentNode, registry, authMan, roleName, userName);
        }
    }

    private void buildUIPermissionNodeAllSelected(Collection parent, UIPermissionNode parentNode, Registry registry) throws RegistryException, UserStoreException {
        String[] children = parent.getChildren();
        UIPermissionNode[] childNodes = new UIPermissionNode[children.length];
        for (int i = 0; i < children.length; ++i) {
            String child = children[i];
            Resource resource = registry.get(child);
            childNodes[i] = this.getUIPermissionNode(resource, registry, true);
            if (!(resource instanceof Collection)) continue;
            this.buildUIPermissionNodeAllSelected((Collection)resource, childNodes[i], registry);
        }
        parentNode.setNodeList(childNodes);
    }

    private void buildUIPermissionNodeNotAllSelected(Collection parent, UIPermissionNode parentNode, Registry registry, AuthorizationManager authMan, String roleName, String userName) throws RegistryException, UserStoreException {
        String[] children = parent.getChildren();
        UIPermissionNode[] childNodes = new UIPermissionNode[children.length];
        for (int i = 0; i < children.length; ++i) {
            String child = children[i];
            Resource resource = registry.get(child);
            boolean isSelected = false;
            if (roleName != null) {
                isSelected = authMan.isRoleAuthorized(roleName, child, "ui.execute");
            } else if (userName != null) {
                isSelected = authMan.isUserAuthorized(userName, child, "ui.execute");
            }
            childNodes[i] = this.getUIPermissionNode(resource, registry, isSelected);
            if (!(resource instanceof Collection)) continue;
            this.buildUIPermissionNodeNotAllSelected((Collection)resource, childNodes[i], registry, authMan, roleName, userName);
        }
        parentNode.setNodeList(childNodes);
    }

    private UIPermissionNode getUIPermissionNode(Resource resource, Registry registry, boolean isSelected) throws RegistryException {
        String displayName = resource.getProperty("name");
        return new UIPermissionNode(resource.getPath(), displayName, isSelected);
    }

    private String getLoggedInUser() {
        return CarbonContext.getCurrentContext().getUsername();
    }

    private void mapEntityName(String entityName, FlaggedName fName, UserStoreManager userStoreManager) {
        if (entityName.contains("@")) {
            String[] nameAndDn = entityName.split("@");
            fName.setItemName(nameAndDn[0]);
            fName.setDn(nameAndDn[1]);
            fName.setShared(((AbstractUserStoreManager)userStoreManager).isOthersSharedRole(entityName));
            if (fName.isShared()) {
                fName.setItemDisplayName("@" + fName.getItemName());
            }
        } else {
            fName.setItemName(entityName);
        }
    }

    public boolean isSharedRolesEnabled() throws UserAdminException {
        try {
            UserStoreManager userManager = this.realm.getUserStoreManager();
            return ((AbstractUserStoreManager)userManager).isSharedGroupEnabled();
        }
        catch (UserStoreException e) {
            log.error((Object)e);
            throw new UserAdminException("Unable to check shared role enabled", e);
        }
    }
}

