/*
 * Decompiled with CFR 0.152.
 */
package org.compass.core.config.builder;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.compass.core.config.CompassConfiguration;
import org.compass.core.config.CompassSettings;
import org.compass.core.config.ConfigurationException;
import org.compass.core.config.builder.AbstractXmlConfigurationBuilder;
import org.compass.core.util.ClassUtils;
import org.compass.core.util.DomUtils;
import org.compass.core.util.SystemPropertyUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class SchemaConfigurationBuilder
extends AbstractXmlConfigurationBuilder {
    protected void doProcess(Document doc, CompassConfiguration config) throws ConfigurationException {
        Element root = doc.getDocumentElement();
        NodeList nl = root.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element) || !"compass".equals(node.getLocalName())) continue;
            this.processCompass((Element)node, config);
        }
    }

    public void processCompass(Element compassElement, CompassConfiguration config) {
        config.getSettings().setSetting("compass.name", DomUtils.getElementAttribute(compassElement, "name"));
        NodeList nl = compassElement.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Method method;
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element ele = (Element)node;
            String nodeName = ele.getLocalName();
            String methodName = "bind" + Character.toUpperCase(nodeName.charAt(0)) + nodeName.substring(1, nodeName.length());
            try {
                method = SchemaConfigurationBuilder.class.getMethod(methodName, Element.class, CompassConfiguration.class);
            }
            catch (NoSuchMethodException e) {
                throw new ConfigurationException("Compass failed to process node [" + nodeName + "], this is " + "either a mailformed xml configuration (not validated against the xsd), or an internal" + " bug in compass");
            }
            try {
                method.invoke((Object)this, ele, config);
                continue;
            }
            catch (InvocationTargetException e) {
                throw new ConfigurationException("Failed to invoke binding metod for node [" + nodeName + "]", e.getTargetException());
            }
            catch (IllegalAccessException e) {
                throw new ConfigurationException("Failed to access binding metod for node [" + nodeName + "]", e);
            }
        }
    }

    private String getElementAttribute(Element ele, String name) {
        return SystemPropertyUtils.resolvePlaceholders(DomUtils.getElementAttribute(ele, name));
    }

    private String getElementAttribute(Element ele, String name, String defaultValue) {
        return SystemPropertyUtils.resolvePlaceholders(DomUtils.getElementAttribute(ele, name, defaultValue));
    }

    private boolean getElementAttributeAsBoolean(Element ele, String name, boolean defaultValue) {
        String sValue = this.getElementAttribute(ele, name);
        if (sValue == null) {
            return defaultValue;
        }
        return Boolean.valueOf(sValue);
    }

    public void bindOsem(Element ele, CompassConfiguration config) {
        CompassSettings settings = config.getSettings();
        settings.setSetting("compass.osem.managedId.index", this.getElementAttribute(ele, "managedIdIndex"));
        settings.setSetting("compass.osem.supportUnmarshall", this.getElementAttribute(ele, "supportUnmarshall"));
    }

    public void bindConverters(Element ele, CompassConfiguration config) {
        CompassSettings settings = config.getSettings();
        List convertersEle = DomUtils.getChildElementsByTagName(ele, "converter", true);
        for (Element converterEle : convertersEle) {
            SettingsHolder settingsHolder = this.processSettings(converterEle);
            settingsHolder.names.add("type");
            settingsHolder.values.add(this.getElementAttribute(converterEle, "type"));
            settings.setGroupSettings("compass.converter", this.getElementAttribute(converterEle, "name"), settingsHolder.names(), settingsHolder.values());
        }
    }

    public void bindPropertyAccessors(Element ele, CompassConfiguration config) {
        CompassSettings settings = config.getSettings();
        List propertyAccessorsEle = DomUtils.getChildElementsByTagName(ele, "propertyAccessor", true);
        for (Element propertyAccessorEle : propertyAccessorsEle) {
            SettingsHolder settingsHolder = this.processSettings(propertyAccessorEle);
            settingsHolder.names.add("type");
            settingsHolder.values.add(this.getElementAttribute(propertyAccessorEle, "type"));
            settings.setGroupSettings("compass.propertyAccessor", this.getElementAttribute(propertyAccessorEle, "name"), settingsHolder.names(), settingsHolder.values());
        }
    }

    public void bindPropertyNamingStrategy(Element ele, CompassConfiguration config) {
        CompassSettings settings = config.getSettings();
        String type = this.getElementAttribute(ele, "type");
        if (type == null) {
            type = this.getElementAttribute(ele, "typeClass");
        }
        settings.setSetting("compass.property.naming", type);
    }

    public void bindSearchEngine(Element ele, CompassConfiguration config) {
        SettingsHolder settingsHolder;
        SettingsHolder settingsHolder2;
        CompassSettings settings = config.getSettings();
        settings.setSetting("compass.engine.useCompoundFile", this.getElementAttribute(ele, "useCompoundFile"));
        settings.setSetting("compass.engine.maxFieldLength", this.getElementAttribute(ele, "maxFieldLength"));
        settings.setSetting("compass.engine.cacheIntervalInvalidation", this.getElementAttribute(ele, "cacheInvalidationInterval"));
        settings.setSetting("compass.engine.indexManagerScheduleInterval", this.getElementAttribute(ele, "indexManagerScheduleInterval"));
        settings.setSetting("compass.engine.waitForCacheInvalidationOnIndexOperation", this.getElementAttribute(ele, "waitForCacheInvalidationOnIndexOperation"));
        settings.setSetting("compass.engine.defaultsearch", this.getElementAttribute(ele, "defaultSearch"));
        List child = DomUtils.getChildElementsByTagName(ele, "aliasProperty", true);
        if (child.size() == 1) {
            Element aliasPropertyEle = (Element)child.get(0);
            settings.setSetting("compass.property.alias", this.getElementAttribute(aliasPropertyEle, "name"));
        }
        if ((child = DomUtils.getChildElementsByTagName(ele, "allProperty", true)).size() == 1) {
            Element allPropertyEle = (Element)child.get(0);
            settings.setSetting("compass.property.all", this.getElementAttribute(allPropertyEle, "name"));
            settings.setSetting("compass.property.all.termVector", this.getElementAttribute(allPropertyEle, "termVector"));
            settings.setSetting("compass.property.all.enabled", this.getElementAttribute(allPropertyEle, "enabled"));
            settings.setSetting("compass.property.all.boostSupport", this.getElementAttribute(allPropertyEle, "boostSupport"));
        }
        if ((child = DomUtils.getChildElementsByTagName(ele, "optimizer", true)).size() == 1) {
            Element optimizerEle = (Element)child.get(0);
            settings.setSetting("compass.engine.optimizer.type", this.getElementAttribute(optimizerEle, "type"));
            settings.setSetting("compass.engine.optimizer.schedule", this.getElementAttribute(optimizerEle, "schedule"));
            settings.setSetting("compass.engine.optimizer.schedule.period", this.getElementAttribute(optimizerEle, "scheduleInterval"));
            settings.setSetting("compass.engine.optimizer.adaptive.mergeFactor", this.getElementAttribute(optimizerEle, "mergeFactor"));
            settings.setSetting("compass.engine.optimizer.aggressive.mergeFactor", this.getElementAttribute(optimizerEle, "mergeFactor"));
        }
        child = DomUtils.getChildElementsByTagName(ele, "highlighter", true);
        for (Element highlighterEle : child) {
            Element formatterEle;
            List formatterList;
            List encoderList;
            String highlighterName = this.getElementAttribute(highlighterEle, "name");
            settingsHolder2 = this.processSettings(highlighterEle);
            settingsHolder2.names.add("textTokenizer");
            settingsHolder2.values.add(this.getElementAttribute(highlighterEle, "textTokenizer"));
            settingsHolder2.names.add("rewriteQuery");
            settingsHolder2.values.add(this.getElementAttribute(highlighterEle, "rewriteQuery"));
            settingsHolder2.names.add("computeIdf");
            settingsHolder2.values.add(this.getElementAttribute(highlighterEle, "computeIdf"));
            settingsHolder2.names.add("maxNumFragments");
            settingsHolder2.values.add(this.getElementAttribute(highlighterEle, "maxNumFragments"));
            settingsHolder2.names.add("separator");
            settingsHolder2.values.add(this.getElementAttribute(highlighterEle, "separator"));
            settingsHolder2.names.add("maxBytesToAnalyze");
            settingsHolder2.values.add(this.getElementAttribute(highlighterEle, "maxBytesToAnalyze"));
            List fragmenterList = DomUtils.getChildElementsByTagName(highlighterEle, "fragmenter", true);
            if (fragmenterList.size() == 1) {
                Element fragmenterEle = (Element)fragmenterList.get(0);
                String type = this.getElementAttribute(fragmenterEle, "type");
                if ("custom".equals(type)) {
                    type = this.getElementAttribute(fragmenterEle, "class");
                }
                settingsHolder2.names.add("fragmenter.type");
                settingsHolder2.values.add(type);
                settingsHolder2.names.add("fragmenter.simple.size");
                settingsHolder2.values.add(this.getElementAttribute(fragmenterEle, "size"));
            }
            if ((encoderList = DomUtils.getChildElementsByTagName(highlighterEle, "encoder", true)).size() == 1) {
                Element encoderEle = (Element)encoderList.get(0);
                String type = this.getElementAttribute(encoderEle, "type");
                if ("custom".equals(type)) {
                    type = this.getElementAttribute(encoderEle, "class");
                }
                settingsHolder2.names.add("encoder.type");
                settingsHolder2.values.add(type);
            }
            if ((formatterList = DomUtils.getChildElementsByTagName(highlighterEle, "simpleFormatter", true)).size() == 1) {
                formatterEle = (Element)formatterList.get(0);
                settingsHolder2.names.add("formatter.type");
                settingsHolder2.values.add("simple");
                settingsHolder2.names.add("formatter.simple.pre");
                settingsHolder2.values.add(this.getElementAttribute(formatterEle, "pre"));
                settingsHolder2.names.add("formatter.simple.post");
                settingsHolder2.values.add(this.getElementAttribute(formatterEle, "post"));
            }
            if ((formatterList = DomUtils.getChildElementsByTagName(highlighterEle, "htmlSpanGradientFormatter", true)).size() == 1) {
                formatterEle = (Element)formatterList.get(0);
                settingsHolder2.names.add("formatter.type");
                settingsHolder2.values.add("htmlSpanGradient");
                settingsHolder2.names.add("formatter.htmlSpanGradient.maxScore");
                settingsHolder2.values.add(this.getElementAttribute(formatterEle, "maxScore"));
                settingsHolder2.names.add("formatter.htmlSpanGradient.minForegroundColor");
                settingsHolder2.values.add(this.getElementAttribute(formatterEle, "minForegroundColor"));
                settingsHolder2.names.add("formatter.htmlSpanGradient.maxForegroundColor");
                settingsHolder2.values.add(this.getElementAttribute(formatterEle, "maxForegroundColor"));
                settingsHolder2.names.add("formatter.htmlSpanGradient.minBackgroundColor");
                settingsHolder2.values.add(this.getElementAttribute(formatterEle, "minBackgroundColor"));
                settingsHolder2.names.add("formatter.htmlSpanGradient.maxBackgroundColor");
                settingsHolder2.values.add(this.getElementAttribute(formatterEle, "maxBackgroundColor"));
            }
            if ((formatterList = DomUtils.getChildElementsByTagName(highlighterEle, "customFormatter", true)).size() == 1) {
                formatterEle = (Element)formatterList.get(0);
                settingsHolder2.names.add("formatter.type");
                settingsHolder2.values.add(this.getElementAttribute(formatterEle, "class"));
            }
            settings.setGroupSettings("compass.engine.highlighter", highlighterName, settingsHolder2.names(), settingsHolder2.values());
        }
        child = DomUtils.getChildElementsByTagName(ele, "analyzer", true);
        for (Element analyzerEle : child) {
            String analyzerName = this.getElementAttribute(analyzerEle, "name");
            settingsHolder2 = this.processSettings(analyzerEle);
            String analyzerType = this.getElementAttribute(analyzerEle, "type");
            if (analyzerType != null) {
                if (analyzerType.equals("CustomAnalyzer") && (analyzerType = this.getElementAttribute(analyzerEle, "analyzerClass")) == null) {
                    throw new ConfigurationException("Analyzer [" + analyzerName + "] has " + "type of [CustomAnalyzer] but does not set analyzerClass");
                }
                settingsHolder2.names.add("type");
                settingsHolder2.values.add(analyzerType);
                if (analyzerType.equals("Snowball")) {
                    settingsHolder2.names.add("name");
                    settingsHolder2.values.add(this.getElementAttribute(analyzerEle, "snowballType"));
                }
            }
            settingsHolder2.names.add("filters");
            settingsHolder2.values.add(this.getElementAttribute(analyzerEle, "filters"));
            List stopWordsList = DomUtils.getChildElementsByTagName(analyzerEle, "stopWords", true);
            if (stopWordsList.size() == 1) {
                Element stopWordsEle = (Element)stopWordsList.get(0);
                StringBuffer sb = new StringBuffer();
                boolean replace = this.getElementAttributeAsBoolean(stopWordsEle, "replace", false);
                if (!replace) {
                    sb.append("+");
                }
                List stopWords = DomUtils.getChildElementsByTagName(stopWordsEle, "stopWord", true);
                for (Element stopWordEle : stopWords) {
                    sb.append(this.getElementAttribute(stopWordEle, "value")).append(",");
                }
                settingsHolder2.names.add("stopwords");
                settingsHolder2.values.add(sb.toString());
            }
            settings.setGroupSettings("compass.engine.analyzer", analyzerName, settingsHolder2.names(), settingsHolder2.values());
        }
        child = DomUtils.getChildElementsByTagName(ele, "analyzerFilter", true);
        for (Element analyzerFilterEle : child) {
            settingsHolder = this.processSettings(analyzerFilterEle);
            settingsHolder.names.add("type");
            settingsHolder.values.add(this.getElementAttribute(analyzerFilterEle, "type"));
            settings.setGroupSettings("compass.engine.analyzerfilter", this.getElementAttribute(analyzerFilterEle, "name"), settingsHolder.names(), settingsHolder.values());
        }
        child = DomUtils.getChildElementsByTagName(ele, "queryParser", true);
        for (Element queryParserEle : child) {
            settingsHolder = this.processSettings(queryParserEle);
            settingsHolder.names.add("type");
            settingsHolder.values.add(this.getElementAttribute(queryParserEle, "type"));
            settings.setGroupSettings("compass.engine.queryParser", this.getElementAttribute(queryParserEle, "name"), settingsHolder.names(), settingsHolder.values());
        }
        child = DomUtils.getChildElementsByTagName(ele, "indexDeletionPolicy", true);
        if (child.size() == 1) {
            Element indexDeletionPolicyEle = (Element)child.get(0);
            if ((child = DomUtils.getChildElementsByTagName(indexDeletionPolicyEle, "keepLastCommit", true)).size() == 1) {
                settings.setSetting("compass.engine.store.indexDeletionPolicy.type", "keeplastcommit");
            }
            if ((child = DomUtils.getChildElementsByTagName(indexDeletionPolicyEle, "keepAll", true)).size() == 1) {
                settings.setSetting("compass.engine.store.indexDeletionPolicy.type", "keepall");
            }
            if ((child = DomUtils.getChildElementsByTagName(indexDeletionPolicyEle, "keepLastN", true)).size() == 1) {
                settings.setSetting("compass.engine.store.indexDeletionPolicy.type", "keeplastn");
                settings.setSetting("compass.engine.store.indexDeletionPolicy.numToKeep", ((Element)child.get(0)).getAttribute("numToKeep"));
            }
            if ((child = DomUtils.getChildElementsByTagName(indexDeletionPolicyEle, "keepNoneOnInit", true)).size() == 1) {
                settings.setSetting("compass.engine.store.indexDeletionPolicy.type", "keepnoneoninit");
            }
            if ((child = DomUtils.getChildElementsByTagName(indexDeletionPolicyEle, "expirationTime", true)).size() == 1) {
                settings.setSetting("compass.engine.store.indexDeletionPolicy.type", "expirationtime");
                settings.setSetting("compass.engine.store.indexDeletionPolicy.expirationTimeInSeconds", ((Element)child.get(0)).getAttribute("expirationTimeSeconds"));
            }
            if ((child = DomUtils.getChildElementsByTagName(indexDeletionPolicyEle, "custom", true)).size() == 1) {
                Element customEle = (Element)child.get(0);
                settings.setSetting("compass.engine.store.indexDeletionPolicy.type", customEle.getAttribute("type"));
                this.bindSettings(customEle, config);
            }
        }
    }

    public void bindCache(Element ele, CompassConfiguration config) {
        CompassSettings settings = config.getSettings();
        List child = DomUtils.getChildElementsByTagName(ele, "firstLevel", true);
        if (child.size() == 1) {
            Element firstLevelCacheEle = (Element)child.get(0);
            settings.setSetting("compass.cache.first", this.getElementAttribute(firstLevelCacheEle, "type"));
        }
    }

    public void bindTransaction(Element ele, CompassConfiguration config) {
        CompassSettings settings = config.getSettings();
        settings.setSetting("compass.transaction.isolation", this.getElementAttribute(ele, "isolation"));
        settings.setSetting("compass.transaction.factory", this.getElementAttribute(ele, "factory"));
        settings.setSetting("compass.transaction.commitBeforeCompletion", this.getElementAttribute(ele, "commitBeforeCompletion"));
        settings.setSetting("compass.transaction.lockTimeout", this.getElementAttribute(ele, "lockTimeout"));
        settings.setSetting("compass.transaction.lockPollInterval", this.getElementAttribute(ele, "lockPollInterval"));
        settings.setSetting("compass.transaction.disableAutoJoinSession", this.getElementAttribute(ele, "disableAutoJoinSession"));
        List child = DomUtils.getChildElementsByTagName(ele, "jtaSettings", true);
        if (child.size() == 1) {
            Element jtaSettingsEle = (Element)child.get(0);
            settings.setSetting("compass.transaction.userTransactionName", this.getElementAttribute(jtaSettingsEle, "userTransactionName"));
            settings.setSetting("compass.transaction.cacheUserTransaction", this.getElementAttribute(jtaSettingsEle, "cacheUserTransaction"));
            settings.setSetting("compass.transaction.managerLookup", this.getElementAttribute(jtaSettingsEle, "managerLookup"));
            settings.setSetting("compass.transaction.managerLookup", this.getElementAttribute(jtaSettingsEle, "managerLookupClass"));
        }
        if ((child = DomUtils.getChildElementsByTagName(ele, "readCommittedSettings", true)).size() == 1) {
            Element readCommittedSettingsEle = (Element)child.get(0);
            settings.setSetting("compass.transaction.readcommitted.translog.connection", this.getElementAttribute(readCommittedSettingsEle, "transLog"));
            settings.setSetting("compass.transaction.readcommitted.translog.optimize", this.getElementAttribute(readCommittedSettingsEle, "optimizeTransLog"));
        }
    }

    public void bindConnection(Element ele, CompassConfiguration config) {
        Element driverManagerEle;
        String url;
        String path;
        Element connEle;
        CompassSettings settings = config.getSettings();
        List child = DomUtils.getChildElementsByTagName(ele, "directoryWrapperProvider", true);
        for (Element dwEle : child) {
            SettingsHolder settingsHolder = this.processSettings(dwEle);
            settingsHolder.names.add("type");
            settingsHolder.values.add(this.getElementAttribute(dwEle, "type"));
            settings.setGroupSettings("compass.engine.store.wrapper", this.getElementAttribute(dwEle, "name"), settingsHolder.names(), settingsHolder.values());
        }
        child = DomUtils.getChildElementsByTagName(ele, "localCache", true);
        for (Element localCacheEle : child) {
            String subIndex = localCacheEle.getAttribute("subIndex");
            String connection = localCacheEle.getAttribute("connection");
            settings.setGroupSettings("compass.engine.localCache", subIndex, new String[]{"connection"}, new String[]{connection});
        }
        child = DomUtils.getChildElementsByTagName(ele, "lockFactory", true);
        if (child.size() == 1) {
            Element lockFactoryEle = (Element)child.get(0);
            settings.setSetting("compass.engine.store.lockFactory.type", this.getElementAttribute(lockFactoryEle, "type"));
            settings.setSetting("compass.engine.store.lockFactory.path", this.getElementAttribute(lockFactoryEle, "path"));
        }
        if ((child = DomUtils.getChildElementsByTagName(ele, "file", true)).size() == 1) {
            connEle = (Element)child.get(0);
            path = this.getElementAttribute(connEle, "path");
            if (!path.startsWith("file://")) {
                path = "file://" + path;
            }
            settings.setSetting("compass.engine.connection", path);
            return;
        }
        child = DomUtils.getChildElementsByTagName(ele, "mmap", true);
        if (child.size() == 1) {
            connEle = (Element)child.get(0);
            path = this.getElementAttribute(connEle, "path");
            if (!path.startsWith("mmap://")) {
                path = "mmap://" + path;
            }
            settings.setSetting("compass.engine.connection", path);
            return;
        }
        child = DomUtils.getChildElementsByTagName(ele, "ram", true);
        if (child.size() == 1) {
            connEle = (Element)child.get(0);
            path = this.getElementAttribute(connEle, "path");
            if (!path.startsWith("ram://")) {
                path = "ram://" + path;
            }
            settings.setSetting("compass.engine.connection", path);
            return;
        }
        child = DomUtils.getChildElementsByTagName(ele, "space", true);
        if (child.size() == 1) {
            connEle = (Element)child.get(0);
            url = this.getElementAttribute(connEle, "url");
            String indexName = this.getElementAttribute(connEle, "indexName");
            settings.setSetting("compass.engine.connection", "space://" + indexName + ":" + url);
            settings.setSetting("compass.engine.store.space.bucketSize", this.getElementAttribute(connEle, "bucketSize"));
            settings.setSetting("compass.engine.store.space.flushRate", this.getElementAttribute(connEle, "flushRate"));
            return;
        }
        child = DomUtils.getChildElementsByTagName(ele, "tc", true);
        if (child.size() == 1) {
            connEle = (Element)child.get(0);
            settings.setSetting("compass.engine.store.tc.bufferSize", this.getElementAttribute(connEle, "bufferSize"));
            settings.setSetting("compass.engine.store.tc.flushRate", this.getElementAttribute(connEle, "flushRate"));
            return;
        }
        child = DomUtils.getChildElementsByTagName(ele, "coherence", true);
        if (child.size() == 1) {
            connEle = (Element)child.get(0);
            String indexName = this.getElementAttribute(connEle, "indexName");
            String cacheName = this.getElementAttribute(connEle, "cacheName");
            String type = this.getElementAttribute(connEle, "type", "invocable");
            if ("invocable".equals(type)) {
                settings.setSetting("compass.engine.connection", "coherence://" + indexName + ":" + cacheName);
            } else {
                settings.setSetting("compass.engine.connection", "coherence-dg://" + indexName + ":" + cacheName);
            }
            settings.setSetting("compass.engine.store.coherence.bucketSize", this.getElementAttribute(connEle, "bucketSize"));
            settings.setSetting("compass.engine.store.coherence.flushRate", this.getElementAttribute(connEle, "flushRate"));
            return;
        }
        child = DomUtils.getChildElementsByTagName(ele, "custom", true);
        if (child.size() == 1) {
            connEle = (Element)child.get(0);
            url = this.getElementAttribute(connEle, "url");
            settings.setSetting("compass.engine.connection", url);
            return;
        }
        child = DomUtils.getChildElementsByTagName(ele, "jdbc", true);
        connEle = (Element)child.get(0);
        settings.setSetting("compass.engine.store.jdbc.managed", this.getElementAttribute(connEle, "managed", "false"));
        settings.setSetting("compass.engine.store.jdbc.disableSchemaOperations", this.getElementAttribute(connEle, "disableSchemaOperations", "false"));
        settings.setSetting("compass.engine.store.jdbc.dialect", this.getElementAttribute(connEle, "dialect"));
        settings.setSetting("compass.engine.store.jdbc.dialect", this.getElementAttribute(connEle, "dialectClass"));
        settings.setSetting("compass.engine.store.jdbc.deleteMarkDeletedDelta", this.getElementAttribute(connEle, "deleteMarkDeletedDelta"));
        settings.setSetting("compass.engine.store.jdbc.lockType", this.getElementAttribute(connEle, "lock"));
        settings.setSetting("compass.engine.store.jdbc.lockType", this.getElementAttribute(connEle, "lockClass"));
        child = DomUtils.getChildElementsByTagName(connEle, "fileEntries", true);
        if (child.size() == 1) {
            Element fileEntriesEle = (Element)child.get(0);
            child = DomUtils.getChildElementsByTagName(fileEntriesEle, "fileEntry", true);
            for (Element fileEntryEle : child) {
                SettingsHolder settingsHolder = this.processSettings(fileEntryEle);
                child = DomUtils.getChildElementsByTagName(fileEntryEle, "indexInput", true);
                if (child.size() == 1) {
                    Element indexInputEle = (Element)child.get(0);
                    settingsHolder.names.add("indexInput.type");
                    settingsHolder.values.add(this.getElementAttribute(indexInputEle, "type"));
                    settingsHolder.names.add("indexInput.type");
                    settingsHolder.values.add(this.getElementAttribute(indexInputEle, "typeClass"));
                    settingsHolder.names.add("indexInput.bufferSize");
                    settingsHolder.values.add(this.getElementAttribute(indexInputEle, "bufferSize"));
                }
                if ((child = DomUtils.getChildElementsByTagName(fileEntryEle, "indexOutput", true)).size() == 1) {
                    Element indexOutputEle = (Element)child.get(0);
                    settingsHolder.names.add("indexOutput.type");
                    settingsHolder.values.add(this.getElementAttribute(indexOutputEle, "type"));
                    settingsHolder.names.add("indexOutput.type");
                    settingsHolder.values.add(this.getElementAttribute(indexOutputEle, "typeClass"));
                    settingsHolder.names.add("indexOutput.bufferSize");
                    settingsHolder.values.add(this.getElementAttribute(indexOutputEle, "bufferSize"));
                    settingsHolder.names.add("indexOutput.threshold");
                    settingsHolder.values.add(this.getElementAttribute(indexOutputEle, "threshold"));
                }
                settings.setGroupSettings("compass.engine.store.jdbc.fe", this.getElementAttribute(fileEntryEle, "name"), settingsHolder.names(), settingsHolder.values());
            }
        }
        if ((child = DomUtils.getChildElementsByTagName(connEle, "ddl", true)).size() == 1) {
            Element ddlEle = (Element)child.get(0);
            if ((child = DomUtils.getChildElementsByTagName(ddlEle, "nameColumn", true)).size() == 1) {
                Element nameColumnEle = (Element)child.get(0);
                settings.setSetting("compass.engine.store.jdbc.ddl.name.name", this.getElementAttribute(nameColumnEle, "name"));
                settings.setSetting("compass.engine.store.jdbc.ddl.name.length", this.getElementAttribute(nameColumnEle, "length"));
            }
            if ((child = DomUtils.getChildElementsByTagName(ddlEle, "valueColumn", true)).size() == 1) {
                Element valueColumnEle = (Element)child.get(0);
                settings.setSetting("compass.engine.store.jdbc.ddl.value.name", this.getElementAttribute(valueColumnEle, "name"));
                settings.setSetting("compass.engine.store.jdbc.ddl.value.length", this.getElementAttribute(valueColumnEle, "length"));
            }
            if ((child = DomUtils.getChildElementsByTagName(ddlEle, "sizeColumn", true)).size() == 1) {
                Element sizeColumnEle = (Element)child.get(0);
                settings.setSetting("compass.engine.store.jdbc.ddl.size.name", this.getElementAttribute(sizeColumnEle, "name"));
            }
            if ((child = DomUtils.getChildElementsByTagName(ddlEle, "lastModifiedColumn", true)).size() == 1) {
                Element lastModifiedEle = (Element)child.get(0);
                settings.setSetting("compass.engine.store.jdbc.ddl.lastModified.name", this.getElementAttribute(lastModifiedEle, "name"));
            }
            if ((child = DomUtils.getChildElementsByTagName(ddlEle, "deletedColumn", true)).size() == 1) {
                Element deletedEle = (Element)child.get(0);
                settings.setSetting("compass.engine.store.jdbc.ddl.deleted.name", this.getElementAttribute(deletedEle, "name"));
            }
        }
        child = DomUtils.getChildElementsByTagName(connEle, "dataSourceProvider", true);
        Element dataSourceProviderEle = (Element)child.get(0);
        if ((child = DomUtils.getChildElementsByTagName(dataSourceProviderEle, "driverManager", true)).size() == 1) {
            driverManagerEle = (Element)child.get(0);
            settings.setSetting("compass.engine.store.jdbc.connection.provider.class", "org.compass.core.lucene.engine.store.jdbc.DriverManagerDataSourceProvider");
            settings.setSetting("compass.engine.connection", "jdbc://" + this.getElementAttribute(driverManagerEle, "url"));
            settings.setSetting("compass.engine.store.jdbc.connection.username", this.getElementAttribute(driverManagerEle, "username"));
            settings.setSetting("compass.engine.store.jdbc.connection.password", this.getElementAttribute(driverManagerEle, "password"));
            settings.setSetting("compass.engine.store.jdbc.connection.driverClass", this.getElementAttribute(driverManagerEle, "driverClass"));
            settings.setSetting("compass.engine.store.jdbc.connection.autoCommit", this.getElementAttribute(driverManagerEle, "autoCommit", "false"));
        }
        if ((child = DomUtils.getChildElementsByTagName(dataSourceProviderEle, "c3p0", true)).size() == 1) {
            driverManagerEle = (Element)child.get(0);
            settings.setSetting("compass.engine.store.jdbc.connection.provider.class", "org.compass.core.lucene.engine.store.jdbc.C3P0DataSourceProvider");
            settings.setSetting("compass.engine.connection", "jdbc://" + this.getElementAttribute(driverManagerEle, "url"));
            settings.setSetting("compass.engine.store.jdbc.connection.username", this.getElementAttribute(driverManagerEle, "username"));
            settings.setSetting("compass.engine.store.jdbc.connection.password", this.getElementAttribute(driverManagerEle, "password"));
            settings.setSetting("compass.engine.store.jdbc.connection.driverClass", this.getElementAttribute(driverManagerEle, "driverClass"));
            settings.setSetting("compass.engine.store.jdbc.connection.autoCommit", this.getElementAttribute(driverManagerEle, "autoCommit", "false"));
        }
        if ((child = DomUtils.getChildElementsByTagName(dataSourceProviderEle, "jndi", true)).size() == 1) {
            Element jndiEle = (Element)child.get(0);
            settings.setSetting("compass.engine.store.jdbc.connection.provider.class", "org.compass.core.lucene.engine.store.jdbc.JndiDataSourceProvider");
            settings.setSetting("compass.engine.connection", "jdbc://" + this.getElementAttribute(jndiEle, "lookup"));
            settings.setSetting("compass.engine.store.jdbc.connection.username", this.getElementAttribute(jndiEle, "username"));
            settings.setSetting("compass.engine.store.jdbc.connection.password", this.getElementAttribute(jndiEle, "password"));
            settings.setSetting("compass.engine.store.jdbc.connection.autoCommit", this.getElementAttribute(jndiEle, "autoCommit", "false"));
        }
        if ((child = DomUtils.getChildElementsByTagName(dataSourceProviderEle, "dbcp", true)).size() == 1) {
            Element dbcpEle = (Element)child.get(0);
            settings.setSetting("compass.engine.store.jdbc.connection.provider.class", "org.compass.core.lucene.engine.store.jdbc.DbcpDataSourceProvider");
            settings.setSetting("compass.engine.connection", "jdbc://" + this.getElementAttribute(dbcpEle, "url"));
            settings.setSetting("compass.engine.store.jdbc.connection.username", this.getElementAttribute(dbcpEle, "username"));
            settings.setSetting("compass.engine.store.jdbc.connection.password", this.getElementAttribute(dbcpEle, "password"));
            settings.setSetting("compass.engine.store.jdbc.connection.driverClass", this.getElementAttribute(dbcpEle, "driverClass"));
            settings.setSetting("compass.engine.store.jdbc.connection.autoCommit", this.getElementAttribute(dbcpEle, "autoCommit", "false"));
            settings.setSetting("compass.engine.store.jdbc.connection.provider.dbcp.defaultTransactionIsolation", this.getElementAttribute(dbcpEle, "defaultTransacitonIsolation"));
            settings.setSetting("compass.engine.store.jdbc.connection.provider.dbcp.initialSize", this.getElementAttribute(dbcpEle, "initialSize"));
            settings.setSetting("compass.engine.store.jdbc.connection.provider.dbcp.maxActive", this.getElementAttribute(dbcpEle, "maxActive"));
            settings.setSetting("compass.engine.store.jdbc.connection.provider.dbcp.maxIdle", this.getElementAttribute(dbcpEle, "maxIdle"));
            settings.setSetting("compass.engine.store.jdbc.connection.provider.dbcp.minIdle", this.getElementAttribute(dbcpEle, "minIdle"));
            settings.setSetting("compass.engine.store.jdbc.connection.provider.dbcp.maxWait", this.getElementAttribute(dbcpEle, "maxWait"));
            settings.setSetting("compass.engine.store.jdbc.connection.provider.dbcp.maxOpenPreparedStatements", this.getElementAttribute(dbcpEle, "maxOpenPreparedStatements"));
            settings.setSetting("compass.engine.store.jdbc.connection.provider.dbcp.poolPreparedStatements", this.getElementAttribute(dbcpEle, "poolPreparedStatements"));
        }
        if ((child = DomUtils.getChildElementsByTagName(dataSourceProviderEle, "external", true)).size() == 1) {
            Element externalEle = (Element)child.get(0);
            settings.setSetting("compass.engine.store.jdbc.connection.provider.class", "org.compass.core.lucene.engine.store.jdbc.ExternalDataSourceProvider");
            settings.setSetting("compass.engine.connection", "jdbc://");
            settings.setSetting("compass.engine.store.jdbc.connection.username", this.getElementAttribute(externalEle, "username"));
            settings.setSetting("compass.engine.store.jdbc.connection.password", this.getElementAttribute(externalEle, "password"));
            settings.setSetting("compass.engine.store.jdbc.connection.autoCommit", this.getElementAttribute(externalEle, "autoCommit", "false"));
        }
    }

    public void bindJndi(Element ele, CompassConfiguration config) {
        CompassSettings settings = config.getSettings();
        settings.setSetting("compass.jndi.enable", this.getElementAttribute(ele, "register", "false"));
        settings.setSetting("compass.jndi.class", this.getElementAttribute(ele, "class"));
        settings.setSetting("compass.jndi.url", this.getElementAttribute(ele, "url"));
        List environments = DomUtils.getChildElementsByTagName(ele, "environment", true);
        if (environments.size() == 1) {
            Element environment = (Element)environments.get(0);
            List properties = DomUtils.getChildElementsByTagName(environment, "property", true);
            for (Element property : properties) {
                String propertyName = "compass.jndi." + this.getElementAttribute(property, "name");
                String propertyValue = this.getElementAttribute(property, "value");
                settings.setSetting(propertyName, propertyValue);
            }
        }
    }

    public void bindSettings(Element ele, CompassConfiguration config) {
        CompassSettings settings = config.getSettings();
        List domSettings = DomUtils.getChildElementsByTagName(ele, "setting", true);
        for (Element eleSetting : domSettings) {
            settings.setSetting(this.getElementAttribute(eleSetting, "name"), this.getElementAttribute(eleSetting, "value"));
        }
    }

    public void bindMappings(Element ele, CompassConfiguration config) throws Exception {
        NodeList nl = ele.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!(node instanceof Element)) continue;
            Element mappingEle = (Element)node;
            String nodeName = mappingEle.getLocalName();
            if ("resource".equals(nodeName)) {
                config.addResource(this.getElementAttribute(mappingEle, "location"));
                continue;
            }
            if ("class".equals(nodeName)) {
                config.addClass(ClassUtils.forName(this.getElementAttribute(mappingEle, "name"), config.getClassLoader()));
                continue;
            }
            if ("jar".equals(nodeName)) {
                config.addJar(new File(this.getElementAttribute(mappingEle, "path")));
                continue;
            }
            if ("file".equals(nodeName)) {
                config.addFile(new File(this.getElementAttribute(mappingEle, "path")));
                continue;
            }
            if ("dir".equals(nodeName)) {
                config.addDirectory(new File(this.getElementAttribute(mappingEle, "path")));
                continue;
            }
            if ("package".equals(nodeName)) {
                config.addPackage(this.getElementAttribute(mappingEle, "name"));
                continue;
            }
            if (!"scan".equals(nodeName)) continue;
            config.addScan(this.getElementAttribute(mappingEle, "basePackage"), this.getElementAttribute(mappingEle, "pattern"));
        }
    }

    private SettingsHolder processSettings(Element ele) {
        SettingsHolder settingsHolder = new SettingsHolder();
        List settings = DomUtils.getChildElementsByTagName(ele, "setting", true);
        for (Element settingEle : settings) {
            settingsHolder.names.add(this.getElementAttribute(settingEle, "name"));
            settingsHolder.values.add(this.getElementAttribute(settingEle, "value"));
        }
        return settingsHolder;
    }

    protected EntityResolver doGetEntityResolver() {
        return new EntityResolver(){
            private static final String URL = "http://www.compass-project.org/schema/";

            public InputSource resolveEntity(String publicId, String systemId) {
                if (systemId != null && systemId.startsWith("http://www.opensymphony.com/compass/schema/")) {
                    throw new IllegalArgumentException("Using old format for schema, please use the url [http://www.compass-project.org/schema/]");
                }
                if (systemId != null && systemId.startsWith(URL)) {
                    String location = "/org/compass/core/" + systemId.substring(URL.length());
                    InputStream is = this.getClass().getResourceAsStream(location);
                    if (is == null) {
                        throw new ConfigurationException("Schema system id [" + systemId + "] not found at [" + location + "], " + "please check it has the correct location. Have you included compass in your class path?");
                    }
                    InputSource source = new InputSource(is);
                    source.setPublicId(publicId);
                    source.setSystemId(systemId);
                    return source;
                }
                throw new ConfigurationException("Schema system id [" + systemId + "] not found, please check it has the " + "correct location");
            }
        };
    }

    protected DocumentBuilderFactory createDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = super.createDocumentBuilderFactory();
        factory.setNamespaceAware(true);
        try {
            factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
        }
        catch (IllegalArgumentException ex) {
            throw new ConfigurationException("Unable to validate using XSD: Your JAXP provider [" + factory + "] does not support XML Schema. " + "Are you running on Java 1.4 or below with Apache Crimson? " + "Upgrade to Apache Xerces (or Java 1.5) for full XSD support.");
        }
        return factory;
    }

    private class SettingsHolder {
        public ArrayList names = new ArrayList();
        public ArrayList values = new ArrayList();

        private SettingsHolder() {
        }

        public String[] names() {
            return this.names.toArray(new String[this.names.size()]);
        }

        public String[] values() {
            return this.values.toArray(new String[this.values.size()]);
        }
    }
}

