/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.util;

import java.net.URL;
import java.util.List;
import java.util.Map;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.xml.namespace.QName;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.wsdl.util.WSDLWrapperBasicImpl;
import org.apache.axis2.wsdl.util.WSDLWrapperImpl;
import org.apache.axis2.wsdl.util.WSDLWrapperReloadImpl;
import org.apache.axis2.wsdl.util.WSDLWrapperSaveImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class WSDLDefinitionWrapper
implements Definition {
    private static final Log log = LogFactory.getLog(WSDLDefinitionWrapper.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private static final String myClassName = "WSDLDefinitionWrapper";
    static final long serialVersionUID = -2788807375814097409L;
    private boolean reduceWSDLMemoryCache = false;
    private int reduceWSDLMemoryType = 0;
    private WSDLWrapperImpl wrapperImpl = null;

    public WSDLDefinitionWrapper(Definition def) {
        if (log.isDebugEnabled()) {
            log.debug("WSDLDefinitionWrapper(Definition) entry");
        }
        this.prepare(def, null);
    }

    public WSDLDefinitionWrapper(Definition def, boolean limitMemory, int memoryType) {
        if (log.isDebugEnabled()) {
            log.debug("WSDLDefinitionWrapper(Definition, boolean) entry");
        }
        this.reduceWSDLMemoryCache = limitMemory;
        this.reduceWSDLMemoryType = memoryType;
        this.prepare(def, null);
    }

    public WSDLDefinitionWrapper(Definition def, AxisConfiguration axisConfig) {
        if (log.isDebugEnabled()) {
            log.debug("WSDLDefinitionWrapper(Definition,AxisConfiguration) entry ");
        }
        this.setupMemoryParms(axisConfig);
        this.prepare(def, null);
    }

    public WSDLDefinitionWrapper(Definition def, URL wURL) {
        if (log.isDebugEnabled()) {
            log.debug("WSDLDefinitionWrapper(Definition,URL) entry");
        }
        this.prepare(def, wURL);
    }

    public WSDLDefinitionWrapper(Definition def, URL wURL, boolean limitInMemory) {
        this.reduceWSDLMemoryCache = limitInMemory;
        if (log.isDebugEnabled()) {
            log.debug("WSDLDefinitionWrapper(Definition,URL,boolean) entry");
        }
        this.prepare(def, wURL);
    }

    public WSDLDefinitionWrapper(Definition def, URL wURL, boolean limitInMemory, int memoryType) {
        this.reduceWSDLMemoryCache = limitInMemory;
        this.reduceWSDLMemoryType = memoryType;
        if (log.isDebugEnabled()) {
            log.debug("WSDLDefinitionWrapper(Definition,URL,boolean) entry");
        }
        this.prepare(def, wURL);
    }

    public WSDLDefinitionWrapper(Definition def, URL wURL, int limitType) {
        this.reduceWSDLMemoryCache = true;
        this.reduceWSDLMemoryType = limitType;
        if (log.isDebugEnabled()) {
            log.debug("WSDLDefinitionWrapper(Definition,URL,int) entry");
        }
        this.prepare(def, wURL);
    }

    public WSDLDefinitionWrapper(Definition def, URL wURL, AxisConfiguration axisCfg) {
        if (log.isDebugEnabled()) {
            log.debug("WSDLDefinitionWrapper(Definition,URL,AxisConfiguration) entry");
        }
        this.setupMemoryParms(axisCfg);
        this.prepare(def, wURL);
    }

    private void setupMemoryParms(AxisConfiguration axisCfg) {
        if (log.isDebugEnabled()) {
            log.debug("setupMemoryParms(AxisConfiguration) entry");
        }
        if (axisCfg != null) {
            String value;
            Parameter param = axisCfg.getParameter("reduceWSDLMemoryCache");
            this.reduceWSDLMemoryCache = param != null && ((String)param.getValue()).equalsIgnoreCase("true");
            param = axisCfg.getParameter("reduceWSDLMemoryType");
            if (param != null && (value = (String)param.getValue()) != null) {
                Integer i = new Integer(value);
                this.reduceWSDLMemoryType = i;
            }
            if (log.isDebugEnabled()) {
                log.debug("reduceWSDLMemoryCache:" + this.reduceWSDLMemoryCache + ", reduceWSDLMemoryType:" + this.reduceWSDLMemoryType);
            }
        } else if (log.isDebugEnabled()) {
            log.debug("AxisConfiguration is null.  This is unexpected");
        }
    }

    private void prepare(Definition def, URL wURL) {
        if (this.reduceWSDLMemoryCache) {
            if (this.reduceWSDLMemoryType == 2) {
                if (WSDLWrapperReloadImpl.isReloadable(def, wURL)) {
                    this.wrapperImpl = new WSDLWrapperReloadImpl(def, wURL);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("WSDLDefinitionWrapper could not create a reloadable WSDL wrapper object.");
                    }
                    this.wrapperImpl = new WSDLWrapperBasicImpl(def, wURL);
                }
            } else {
                this.wrapperImpl = new WSDLWrapperSaveImpl(def, wURL);
            }
        } else {
            this.wrapperImpl = new WSDLWrapperBasicImpl(def, wURL);
        }
        this.wrapperImpl.releaseResources();
    }

    public Definition getUnwrappedDefinition() {
        return this.wrapperImpl.getUnwrappedDefinition();
    }

    public int getMemoryLimitType() {
        return this.reduceWSDLMemoryType;
    }

    @Override
    public void setDocumentBaseURI(String d) {
        this.wrapperImpl.setDocumentBaseURI(d);
    }

    @Override
    public String getDocumentBaseURI() {
        return this.wrapperImpl.getDocumentBaseURI();
    }

    @Override
    public void setQName(QName n) {
        this.wrapperImpl.setQName(n);
    }

    @Override
    public QName getQName() {
        return this.wrapperImpl.getQName();
    }

    @Override
    public void setTargetNamespace(String t) {
        this.wrapperImpl.setTargetNamespace(t);
    }

    @Override
    public String getTargetNamespace() {
        return this.wrapperImpl.getTargetNamespace();
    }

    @Override
    public void addNamespace(String prefix, String namespaceURI) {
        this.wrapperImpl.addNamespace(prefix, namespaceURI);
    }

    @Override
    public String removeNamespace(String prefix) {
        return this.wrapperImpl.removeNamespace(prefix);
    }

    @Override
    public String getNamespace(String prefix) {
        return this.wrapperImpl.getNamespace(prefix);
    }

    @Override
    public String getPrefix(String namespaceURI) {
        return this.wrapperImpl.getPrefix(namespaceURI);
    }

    @Override
    public Map getNamespaces() {
        return this.wrapperImpl.getNamespaces();
    }

    @Override
    public List getNativeAttributeNames() {
        return this.wrapperImpl.getNativeAttributeNames();
    }

    @Override
    public void setTypes(Types types) {
        this.wrapperImpl.setTypes(types);
    }

    @Override
    public Types getTypes() {
        return this.wrapperImpl.getTypes();
    }

    @Override
    public void addImport(Import importDef) {
        this.wrapperImpl.addImport(importDef);
    }

    @Override
    public Import removeImport(Import importDef) {
        return this.wrapperImpl.removeImport(importDef);
    }

    @Override
    public List getImports(String namespaceURI) {
        return this.wrapperImpl.getImports(namespaceURI);
    }

    @Override
    public Map getImports() {
        return this.wrapperImpl.getImports();
    }

    @Override
    public void addMessage(Message message) {
        this.wrapperImpl.addMessage(message);
    }

    @Override
    public Message getMessage(QName name) {
        return this.wrapperImpl.getMessage(name);
    }

    @Override
    public Message removeMessage(QName name) {
        return this.wrapperImpl.removeMessage(name);
    }

    @Override
    public Map getMessages() {
        return this.wrapperImpl.getMessages();
    }

    @Override
    public void addBinding(Binding binding) {
        this.wrapperImpl.addBinding(binding);
    }

    @Override
    public Binding getBinding(QName name) {
        return this.wrapperImpl.getBinding(name);
    }

    @Override
    public Binding removeBinding(QName name) {
        return this.wrapperImpl.removeBinding(name);
    }

    @Override
    public Map getBindings() {
        return this.wrapperImpl.getBindings();
    }

    @Override
    public Map getAllBindings() {
        return this.wrapperImpl.getAllBindings();
    }

    @Override
    public void addPortType(PortType portType) {
        this.wrapperImpl.addPortType(portType);
    }

    @Override
    public PortType getPortType(QName name) {
        return this.wrapperImpl.getPortType(name);
    }

    @Override
    public PortType removePortType(QName name) {
        return this.wrapperImpl.removePortType(name);
    }

    @Override
    public Map getPortTypes() {
        return this.wrapperImpl.getPortTypes();
    }

    @Override
    public Map getAllPortTypes() {
        return this.wrapperImpl.getAllPortTypes();
    }

    @Override
    public void addService(Service service) {
        this.wrapperImpl.addService(service);
    }

    @Override
    public Service getService(QName name) {
        return this.wrapperImpl.getService(name);
    }

    @Override
    public Service removeService(QName name) {
        return this.wrapperImpl.removeService(name);
    }

    @Override
    public Map getServices() {
        return this.wrapperImpl.getServices();
    }

    @Override
    public Map getAllServices() {
        return this.wrapperImpl.getAllServices();
    }

    @Override
    public void setDocumentationElement(Element docEl) {
        this.wrapperImpl.setDocumentationElement(docEl);
    }

    @Override
    public Element getDocumentationElement() {
        return this.wrapperImpl.getDocumentationElement();
    }

    @Override
    public void addExtensibilityElement(ExtensibilityElement extElement) {
        this.wrapperImpl.addExtensibilityElement(extElement);
    }

    @Override
    public List getExtensibilityElements() {
        return this.wrapperImpl.getExtensibilityElements();
    }

    @Override
    public Binding createBinding() {
        return this.wrapperImpl.createBinding();
    }

    @Override
    public BindingFault createBindingFault() {
        return this.wrapperImpl.createBindingFault();
    }

    @Override
    public BindingInput createBindingInput() {
        return this.wrapperImpl.createBindingInput();
    }

    @Override
    public BindingOperation createBindingOperation() {
        return this.wrapperImpl.createBindingOperation();
    }

    @Override
    public BindingOutput createBindingOutput() {
        return this.wrapperImpl.createBindingOutput();
    }

    @Override
    public Fault createFault() {
        return this.wrapperImpl.createFault();
    }

    @Override
    public Import createImport() {
        return this.wrapperImpl.createImport();
    }

    @Override
    public Input createInput() {
        return this.wrapperImpl.createInput();
    }

    @Override
    public Message createMessage() {
        return this.wrapperImpl.createMessage();
    }

    @Override
    public Operation createOperation() {
        return this.wrapperImpl.createOperation();
    }

    @Override
    public Output createOutput() {
        return this.wrapperImpl.createOutput();
    }

    @Override
    public Part createPart() {
        return this.wrapperImpl.createPart();
    }

    @Override
    public Port createPort() {
        return this.wrapperImpl.createPort();
    }

    @Override
    public PortType createPortType() {
        return this.wrapperImpl.createPortType();
    }

    @Override
    public Service createService() {
        return this.wrapperImpl.createService();
    }

    @Override
    public Types createTypes() {
        return this.wrapperImpl.createTypes();
    }

    @Override
    public void setExtensionRegistry(ExtensionRegistry extReg) {
        this.wrapperImpl.setExtensionRegistry(extReg);
    }

    @Override
    public ExtensionRegistry getExtensionRegistry() {
        return this.wrapperImpl.getExtensionRegistry();
    }

    public String toString() {
        return this.wrapperImpl.toString();
    }

    @Override
    public ExtensibilityElement removeExtensibilityElement(ExtensibilityElement extElement) {
        return this.wrapperImpl.removeExtensibilityElement(extElement);
    }

    @Override
    public Object getExtensionAttribute(QName name) {
        return this.wrapperImpl.getExtensionAttribute(name);
    }

    @Override
    public Map getExtensionAttributes() {
        return this.wrapperImpl.getExtensionAttributes();
    }

    @Override
    public void setExtensionAttribute(QName name, Object value) {
        this.wrapperImpl.setExtensionAttribute(name, value);
    }
}

