/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.transport.http.server;

import org.apache.axis2.transport.http.server.ConnectionListenerFailureHandler;
import org.apache.axis2.transport.http.server.IOProcessor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultConnectionListenerFailureHandler
implements ConnectionListenerFailureHandler {
    private static final Log LOG = LogFactory.getLog(DefaultConnectionListenerFailureHandler.class);
    protected int retryDelay;
    protected int successInterval;
    protected int maxRetries;
    private long lastFailure;
    private long lastFirstFailure;
    private int numRetries;

    public DefaultConnectionListenerFailureHandler() {
        this(1000, 60000, 10);
    }

    public DefaultConnectionListenerFailureHandler(int retryDelay, int successInterval, int maxRetries) {
        this.retryDelay = retryDelay;
        this.successInterval = successInterval;
        this.maxRetries = maxRetries;
        this.lastFirstFailure = Long.MIN_VALUE;
        this.lastFailure = Long.MIN_VALUE;
        this.numRetries = 0;
    }

    @Override
    public boolean failed(IOProcessor connectionListener, Throwable cause) {
        long now = System.currentTimeMillis();
        if (now > this.lastFailure + (long)this.successInterval) {
            this.numRetries = 0;
            this.lastFirstFailure = now;
        }
        this.lastFailure = now;
        if (this.numRetries >= this.maxRetries) {
            this.notifyAbnormalTermination(connectionListener, "Terminating connection listener " + connectionListener + " after " + this.numRetries + "retries in " + (now - this.lastFirstFailure) / 1000L + " seconds.", cause);
            return false;
        }
        ++this.numRetries;
        if (LOG.isWarnEnabled()) {
            LOG.warn("Attempt number " + this.numRetries + " of " + this.maxRetries + " to reestalish connection listener " + connectionListener + " due to failure ", cause);
        }
        return true;
    }

    @Override
    public void notifyAbnormalTermination(IOProcessor connectionListener, String message, Throwable cause) {
        LOG.error(message, cause);
    }
}

