/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.utils.dbcreator;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DatabaseCreator {
    private static Log log = LogFactory.getLog(DatabaseCreator.class);
    private DataSource dataSource;
    private String delimiter = ";";
    private Connection conn = null;
    private Statement statement;

    public DatabaseCreator(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void createRegistryDatabase() throws Exception {
        try {
            this.conn = this.dataSource.getConnection();
            this.conn.setAutoCommit(false);
            this.statement = this.conn.createStatement();
            this.executeSQLScript();
            this.conn.commit();
            if (log.isTraceEnabled()) {
                log.trace((Object)"Registry tables are created successfully.");
            }
        }
        catch (SQLException e) {
            String msg = "Failed to create database tables for registry resource store. " + e.getMessage();
            log.fatal((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        finally {
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (SQLException e) {
                log.error((Object)"Failed to close database connection.", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDatabaseStructureCreated(String checkSQL) {
        try {
            if (log.isTraceEnabled()) {
                log.trace((Object)"Running a query to test the database tables existence.");
            }
            this.conn = this.dataSource.getConnection();
            try {
                this.statement = this.conn.createStatement();
                ResultSet rs = this.statement.executeQuery(checkSQL);
                if (rs != null) {
                    rs.close();
                }
            }
            finally {
                try {
                    if (this.statement != null) {
                        this.statement.close();
                    }
                }
                finally {
                    if (this.conn != null) {
                        this.conn.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSQL(String sql) throws Exception {
        block20: {
            if ("".equals(sql.trim())) {
                return;
            }
            ResultSet resultSet = null;
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("SQL : " + sql));
                }
                int updateCount = 0;
                int updateCountTotal = 0;
                boolean ret = this.statement.execute(sql);
                updateCount = this.statement.getUpdateCount();
                resultSet = this.statement.getResultSet();
                do {
                    if (!ret && updateCount != -1) {
                        updateCountTotal += updateCount;
                    }
                    if (!(ret = this.statement.getMoreResults())) continue;
                    updateCount = this.statement.getUpdateCount();
                    resultSet = this.statement.getResultSet();
                } while (ret);
                if (log.isDebugEnabled()) {
                    log.debug((Object)(sql + " : " + updateCountTotal + " rows affected"));
                }
                for (SQLWarning warning = this.conn.getWarnings(); warning != null; warning = warning.getNextWarning()) {
                    log.debug((Object)(warning + " sql warning"));
                }
                this.conn.clearWarnings();
            }
            catch (SQLException e) {
                if (e.getSQLState().equals("X0Y32") || e.getSQLState().equals("42710")) {
                    if (log.isDebugEnabled()) {
                        log.info((Object)"Table Already Exists. Hence, skipping table creation");
                    }
                    break block20;
                }
                throw new Exception("Error occurred while executing : " + sql, e);
            }
            finally {
                if (resultSet != null) {
                    try {
                        resultSet.close();
                    }
                    catch (SQLException e) {
                        log.error((Object)"Error occurred while closing result set.", (Throwable)e);
                    }
                }
            }
        }
    }

    public static String getDatabaseType(Connection conn) throws Exception {
        String type = null;
        try {
            if (conn != null && !conn.isClosed()) {
                DatabaseMetaData metaData = conn.getMetaData();
                String databaseProductName = metaData.getDatabaseProductName();
                type = DatabaseCreator.getDatabaseType(databaseProductName);
            }
        }
        catch (SQLException e) {
            String msg = "Failed to create registry database." + e.getMessage();
            log.fatal((Object)msg, (Throwable)e);
            throw new Exception(msg, e);
        }
        return type;
    }

    public static String getDatabaseType(String dbUrl) throws Exception {
        String type;
        block12: {
            type = null;
            try {
                if (dbUrl == null) break block12;
                if (dbUrl.matches("(?i).*hsql.*")) {
                    type = "hsql";
                    break block12;
                }
                if (dbUrl.matches("(?i).*derby.*")) {
                    type = "derby";
                    break block12;
                }
                if (dbUrl.matches("(?i).*mysql.*")) {
                    type = "mysql";
                    break block12;
                }
                if (dbUrl.matches("(?i).*oracle.*")) {
                    type = "oracle";
                    break block12;
                }
                if (dbUrl.matches("(?i).*microsoft.*")) {
                    type = "mssql";
                    break block12;
                }
                if (dbUrl.matches("(?i).*h2.*")) {
                    type = "h2";
                    break block12;
                }
                if (dbUrl.matches("(?i).*db2.*")) {
                    type = "db2";
                    break block12;
                }
                if (dbUrl.matches("(?i).*postgresql.*")) {
                    type = "postgresql";
                    break block12;
                }
                if (dbUrl.matches("(?i).*openedge.*")) {
                    type = "openedge";
                    break block12;
                }
                if (dbUrl.matches("(?i).*informix.*")) {
                    type = "informix";
                    break block12;
                }
                String msg = "Unsupported database: " + dbUrl + ". Database will not be created automatically by the WSO2 Registry. " + "Please create the database using appropriate database scripts for " + "the database.";
                throw new Exception(msg);
            }
            catch (SQLException e) {
                String msg = "Failed to create registry database." + e.getMessage();
                log.fatal((Object)msg, (Throwable)e);
                throw new Exception(msg, e);
            }
        }
        return type;
    }

    private void executeSQLScript() throws Exception {
        String databaseType = DatabaseCreator.getDatabaseType(this.conn);
        boolean keepFormat = false;
        if ("oracle".equals(databaseType)) {
            this.delimiter = "/";
        } else if ("db2".equals(databaseType)) {
            this.delimiter = "/";
        } else if ("openedge".equals(databaseType)) {
            this.delimiter = "/";
            keepFormat = true;
        }
        String dbscriptName = this.getDbScriptLocation(databaseType);
        StringBuffer sql = new StringBuffer();
        BufferedReader reader = null;
        try {
            String line;
            FileInputStream is = new FileInputStream(dbscriptName);
            reader = new BufferedReader(new InputStreamReader(is));
            while ((line = reader.readLine()) != null) {
                String token;
                StringTokenizer st;
                line = line.trim();
                if (!keepFormat && (line.startsWith("//") || line.startsWith("--") || (st = new StringTokenizer(line)).hasMoreTokens() && "REM".equalsIgnoreCase(token = st.nextToken()))) continue;
                sql.append(keepFormat ? "\n" : " ").append(line);
                if (!keepFormat && line.indexOf("--") >= 0) {
                    sql.append("\n");
                }
                if (!DatabaseCreator.checkStringBufferEndsWith(sql, this.delimiter)) continue;
                this.executeSQL(sql.substring(0, sql.length() - this.delimiter.length()));
                sql.replace(0, sql.length(), "");
            }
            if (sql.length() > 0) {
                this.executeSQL(sql.toString());
            }
        }
        catch (IOException e) {
            log.error((Object)"Error occurred while executing SQL script for creating registry database", (Throwable)e);
            throw new Exception("Error occurred while executing SQL script for creating registry database", e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    protected String getDbScriptLocation(String databaseType) {
        String scriptName = databaseType + ".sql";
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loading database script from :" + scriptName));
        }
        String carbonHome = System.getProperty("carbon.home");
        return carbonHome + "/dbscripts/" + scriptName;
    }

    public static boolean checkStringBufferEndsWith(StringBuffer buffer, String suffix) {
        if (suffix.length() > buffer.length()) {
            return false;
        }
        int bufferIndex = buffer.length() - 1;
        for (int endIndex = suffix.length() - 1; endIndex >= 0; --endIndex) {
            if (buffer.charAt(bufferIndex) != suffix.charAt(endIndex)) {
                return false;
            }
            --bufferIndex;
        }
        return true;
    }
}

