/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.haproxy.extension;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.haproxy.extension.HAProxyContext;
import org.apache.stratos.haproxy.extension.Main;
import org.apache.stratos.load.balancer.common.domain.Cluster;
import org.apache.stratos.load.balancer.common.domain.Member;
import org.apache.stratos.load.balancer.common.domain.Port;
import org.apache.stratos.load.balancer.common.domain.Service;
import org.apache.stratos.load.balancer.common.domain.Topology;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class HAProxyConfigWriter {
    private static final Log log = LogFactory.getLog(Main.class);
    private static final String NEW_LINE = System.getProperty("line.separator");
    private String templatePath;
    private String templateName;
    private String confFilePath;
    private String statsSocketFilePath;

    public HAProxyConfigWriter(String templatePath, String templateName, String confFilePath, String statsSocketFilePath) {
        this.templatePath = templatePath;
        this.templateName = templateName;
        this.confFilePath = confFilePath;
        this.statsSocketFilePath = statsSocketFilePath;
    }

    public boolean write(Topology topology) {
        StringBuilder globalParameters = new StringBuilder();
        globalParameters.append("stats socket ");
        globalParameters.append(this.statsSocketFilePath);
        StringBuilder frontendCollection = new StringBuilder();
        StringBuilder backendCollection = new StringBuilder();
        for (Service service : topology.getServices()) {
            for (Cluster cluster : service.getClusters()) {
                this.createConfig(service, cluster, frontendCollection, backendCollection);
            }
        }
        VelocityEngine ve = new VelocityEngine();
        ve.setProperty("file.resource.loader.path", (Object)this.templatePath);
        ve.init();
        Template t = ve.getTemplate(this.templateName);
        VelocityContext context = new VelocityContext();
        context.put("global_parameters", (Object)globalParameters.toString());
        context.put("frontend_collection", (Object)frontendCollection.toString());
        context.put("backend_collection", (Object)backendCollection.toString());
        StringWriter stringWriter = new StringWriter();
        t.merge((Context)context, (Writer)stringWriter);
        String configuration = stringWriter.toString();
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(this.confFilePath));
            writer.write(configuration);
            writer.close();
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Configuration written to file: %s", this.confFilePath));
            }
            return true;
        }
        catch (IOException e) {
            if (log.isErrorEnabled()) {
                log.error((Object)String.format("Could not write configuration file: %s", this.confFilePath));
            }
            throw new RuntimeException(e);
        }
    }

    private void createConfig(Service service, Cluster cluster, StringBuilder frontendCollection, StringBuilder backendCollection) {
        if (service.getPorts() == null || service.getPorts().size() == 0) {
            throw new RuntimeException(String.format("No ports found in service: %s", service.getServiceName()));
        }
        for (Port port : service.getPorts()) {
            String protocol = port.getProtocol();
            String frontendId = protocol + "_" + port.getValue() + "_frontend";
            frontendCollection.append("frontend ").append(frontendId).append(NEW_LINE);
            frontendCollection.append("\tbind ").append(HAProxyContext.getInstance().getHAProxyPrivateIp()).append(":").append(port.getProxy()).append(NEW_LINE);
            frontendCollection.append("\tmode ").append(protocol).append(NEW_LINE);
            for (String hostname : cluster.getHostNames()) {
                String backendId = hostname + "_" + protocol + "_" + port.getValue() + "_backend";
                frontendCollection.append("\tacl ").append("is_").append(hostname).append(" hdr_beg(host) -i ").append(hostname).append(NEW_LINE);
                frontendCollection.append("\tuse_backend ").append(backendId).append(" if is_").append(hostname).append(NEW_LINE);
                backendCollection.append("backend ").append(backendId).append(NEW_LINE);
                backendCollection.append("\tmode ").append(protocol).append(NEW_LINE);
                for (Member member : cluster.getMembers()) {
                    backendCollection.append("\tserver ").append(member.getMemberId()).append(" ").append(member.getHostName()).append(":").append(port.getValue()).append(NEW_LINE);
                }
                backendCollection.append(NEW_LINE);
            }
        }
    }
}

