/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.util;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.wso2.andes.util.InetNetwork;

public class NetMatcher {
    private ArrayList networks;

    public void initInetNetworks(Collection nets) {
        this.networks = new ArrayList();
        Iterator iter = nets.iterator();
        while (iter.hasNext()) {
            try {
                InetNetwork net = InetNetwork.getFromString((String)iter.next());
                if (this.networks.contains(net)) continue;
                this.networks.add(net);
            }
            catch (UnknownHostException uhe) {
                this.log("Cannot resolve address: " + uhe.getMessage());
            }
        }
        this.networks.trimToSize();
    }

    public void initInetNetworks(String[] nets) {
        this.networks = new ArrayList();
        for (int i = 0; i < nets.length; ++i) {
            try {
                InetNetwork net = InetNetwork.getFromString(nets[i]);
                if (this.networks.contains(net)) continue;
                this.networks.add(net);
                continue;
            }
            catch (UnknownHostException uhe) {
                this.log("Cannot resolve address: " + uhe.getMessage());
            }
        }
        this.networks.trimToSize();
    }

    public boolean matchInetNetwork(String hostIP) {
        InetAddress ip = null;
        try {
            ip = InetAddress.getByName(hostIP);
        }
        catch (UnknownHostException uhe) {
            this.log("Cannot resolve address for " + hostIP + ": " + uhe.getMessage());
        }
        boolean sameNet = false;
        if (ip != null) {
            Iterator iter = this.networks.iterator();
            while (!sameNet && iter.hasNext()) {
                InetNetwork network = (InetNetwork)iter.next();
                sameNet = network.contains(ip);
            }
        }
        return sameNet;
    }

    public boolean matchInetNetwork(InetAddress ip) {
        boolean sameNet = false;
        Iterator iter = this.networks.iterator();
        while (!sameNet && iter.hasNext()) {
            InetNetwork network = (InetNetwork)iter.next();
            sameNet = network.contains(ip);
        }
        return sameNet;
    }

    public NetMatcher() {
    }

    public NetMatcher(String[] nets) {
        this.initInetNetworks(nets);
    }

    public NetMatcher(Collection nets) {
        this.initInetNetworks(nets);
    }

    public String toString() {
        return this.networks.toString();
    }

    protected void log(String s) {
    }
}

