/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.transport;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.wso2.andes.transport.Range;
import org.wso2.andes.util.Serial;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RangeSet
implements Iterable<Range> {
    private LinkedList<Range> ranges = new LinkedList();

    public int size() {
        return this.ranges.size();
    }

    @Override
    public Iterator<Range> iterator() {
        return this.ranges.iterator();
    }

    public Range getFirst() {
        return this.ranges.getFirst();
    }

    public Range getLast() {
        return this.ranges.getLast();
    }

    public boolean includes(Range range) {
        for (Range r : this) {
            if (!r.includes(range)) continue;
            return true;
        }
        return false;
    }

    public boolean includes(int n) {
        for (Range r : this) {
            if (!r.includes(n)) continue;
            return true;
        }
        return false;
    }

    public void add(Range range) {
        ListIterator<Range> it = this.ranges.listIterator();
        while (it.hasNext()) {
            Range next = (Range)it.next();
            if (range.touches(next)) {
                it.remove();
                range = range.span(next);
                continue;
            }
            if (!Serial.lt(range.getUpper(), next.getLower())) continue;
            it.previous();
            it.add(range);
            return;
        }
        it.add(range);
    }

    public void add(int lower, int upper) {
        this.add(new Range(lower, upper));
    }

    public void add(int value) {
        this.add(value, value);
    }

    public void clear() {
        this.ranges.clear();
    }

    public RangeSet copy() {
        RangeSet copy = new RangeSet();
        copy.ranges.addAll(this.ranges);
        return copy;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("{");
        boolean first = true;
        for (Range range : this.ranges) {
            if (first) {
                first = false;
            } else {
                str.append(", ");
            }
            str.append(range);
        }
        str.append("}");
        return str.toString();
    }
}

