/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.andes.client.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.wso2.andes.client.message.UnprocessedMessage;
import org.wso2.andes.framing.AMQShortString;
import org.wso2.andes.framing.BasicDeliverBody;
import org.wso2.andes.framing.ContentBody;
import org.wso2.andes.framing.ContentHeaderBody;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnprocessedMessage_0_8
extends UnprocessedMessage {
    private long _bytesReceived = 0L;
    private AMQShortString _exchange;
    private AMQShortString _routingKey;
    private final long _deliveryId;
    protected boolean _redelivered;
    private BasicDeliverBody _deliverBody;
    private ContentHeaderBody _contentHeader;
    private List<ContentBody> _bodies;

    public UnprocessedMessage_0_8(long deliveryId, int consumerTag, AMQShortString exchange, AMQShortString routingKey, boolean redelivered) {
        super(consumerTag);
        this._exchange = exchange;
        this._routingKey = routingKey;
        this._redelivered = redelivered;
        this._deliveryId = deliveryId;
    }

    public AMQShortString getExchange() {
        return this._exchange;
    }

    public AMQShortString getRoutingKey() {
        return this._routingKey;
    }

    @Override
    public long getDeliveryTag() {
        return this._deliveryId;
    }

    public boolean isRedelivered() {
        return this._redelivered;
    }

    public void receiveBody(ContentBody body) {
        if (body.payload != null) {
            long payloadSize = body.payload.remaining();
            if (this._bodies == null) {
                if (payloadSize == this.getContentHeader().bodySize) {
                    this._bodies = Collections.singletonList(body);
                } else {
                    this._bodies = new ArrayList<ContentBody>();
                    this._bodies.add(body);
                }
            } else {
                this._bodies.add(body);
            }
            this._bytesReceived += payloadSize;
        }
    }

    public void setMethodBody(BasicDeliverBody deliverBody) {
        this._deliverBody = deliverBody;
    }

    public void setContentHeader(ContentHeaderBody contentHeader) {
        this._contentHeader = contentHeader;
    }

    public boolean isAllBodyDataReceived() {
        return this._bytesReceived == this.getContentHeader().bodySize;
    }

    public BasicDeliverBody getDeliverBody() {
        return this._deliverBody;
    }

    public ContentHeaderBody getContentHeader() {
        return this._contentHeader;
    }

    public List<ContentBody> getBodies() {
        return this._bodies;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this._contentHeader != null) {
            buf.append("ContentHeader " + this._contentHeader);
        }
        if (this._deliverBody != null) {
            buf.append("Delivery tag " + this._deliverBody.getDeliveryTag());
            buf.append("Consumer tag " + this._deliverBody.getConsumerTag());
            buf.append("Deliver Body " + this._deliverBody);
        }
        return buf.toString();
    }
}

