/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.carbon.core.internal;

import java.io.File;
import java.lang.management.ManagementPermission;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.wso2.carbon.core.internal.CarbonCoreDataHolder;

public class CarbonCoreActivator
implements BundleActivator {
    private static final Log log = LogFactory.getLog(CarbonCoreActivator.class);
    private CarbonCoreDataHolder dataHolder = CarbonCoreDataHolder.getInstance();

    public void start(BundleContext context) throws Exception {
        SecurityManager secMan = System.getSecurityManager();
        if (secMan != null) {
            secMan.checkPermission(new ManagementPermission("control"));
        }
        this.dataHolder.setBundleContext(context);
        log.info((Object)"Starting WSO2 Carbon...");
        log.info((Object)("Operating System : " + System.getProperty("os.name") + " " + System.getProperty("os.version") + ", " + System.getProperty("os.arch")));
        log.info((Object)("Java Home        : " + System.getProperty("java.home")));
        log.info((Object)("Java Version     : " + System.getProperty("java.version")));
        log.info((Object)("Java VM          : " + System.getProperty("java.vm.name") + " " + System.getProperty("java.vm.version") + "," + System.getProperty("java.vendor")));
        String carbonHome = System.getProperty("carbon.home");
        if (carbonHome.equals(".")) {
            carbonHome = new File(".").getAbsolutePath();
        }
        log.info((Object)("Carbon Home      : " + carbonHome));
        log.info((Object)("Java Temp Dir    : " + System.getProperty("java.io.tmpdir")));
        log.info((Object)("User             : " + System.getProperty("user.name") + ", " + System.getProperty("user.language") + "-" + System.getProperty("user.country") + ", " + System.getProperty("user.timezone")));
    }

    public void stop(BundleContext context) throws Exception {
        this.dataHolder.setBundleContext(null);
    }
}

