/*
 * Decompiled with CFR 0.152.
 */
package org.apache.stratos.load.balancer.common.statistics.notifier;

import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.stratos.load.balancer.common.statistics.LoadBalancerStatisticsReader;
import org.apache.stratos.load.balancer.common.statistics.publisher.WSO2CEPInFlightRequestPublisher;
import org.apache.stratos.messaging.domain.topology.Cluster;
import org.apache.stratos.messaging.domain.topology.Service;
import org.apache.stratos.messaging.message.receiver.topology.TopologyManager;

public class LoadBalancerStatisticsNotifier
implements Runnable {
    private static final Log log = LogFactory.getLog(LoadBalancerStatisticsNotifier.class);
    private final LoadBalancerStatisticsReader statsReader;
    private final WSO2CEPInFlightRequestPublisher inFlightRequestPublisher;
    private long statsPublisherInterval = 15000L;
    private String networkPartitionId;
    private boolean terminated;

    public LoadBalancerStatisticsNotifier(LoadBalancerStatisticsReader statsReader) {
        this.statsReader = statsReader;
        this.inFlightRequestPublisher = new WSO2CEPInFlightRequestPublisher();
        String interval = System.getProperty("stats.notifier.interval");
        if (interval != null) {
            this.statsPublisherInterval = Long.getLong(interval);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("stats.notifier.interval: %dms", this.statsPublisherInterval));
        }
        this.networkPartitionId = System.getProperty("network.partition.id");
        if (StringUtils.isBlank((CharSequence)this.networkPartitionId)) {
            throw new RuntimeException("network.partition.id system property was not found.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.terminated) {
            try {
                try {
                    Thread.sleep(this.statsPublisherInterval);
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Publishing load balancer statistics");
                }
                if (this.inFlightRequestPublisher.isEnabled()) {
                    try {
                        TopologyManager.acquireReadLock();
                        for (Service service : TopologyManager.getTopology().getServices()) {
                            for (Cluster cluster : service.getClusters()) {
                                if (cluster.isLbCluster()) continue;
                                int requestCount = this.statsReader.getInFlightRequestCount(cluster.getClusterId());
                                this.inFlightRequestPublisher.publish(cluster.getClusterId(), this.networkPartitionId, requestCount);
                                if (!log.isDebugEnabled()) continue;
                                log.debug((Object)String.format("In-flight request count published to cep: [cluster-id] %s [network-partition] %s [value] %d", cluster.getClusterId(), this.networkPartitionId, requestCount));
                            }
                        }
                        continue;
                    }
                    finally {
                        TopologyManager.releaseReadLock();
                        continue;
                    }
                }
                if (!log.isWarnEnabled()) continue;
                log.warn((Object)"In-flight request count publisher is disabled");
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)"Could not publish load balancer statistics", (Throwable)e);
            }
        }
    }

    public void terminate() {
        this.terminated = true;
    }
}

