/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.jaxws.common.config;

import java.lang.annotation.Annotation;
import java.util.Set;
import javax.wsdl.Definition;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.xml.namespace.QName;
import javax.xml.ws.spi.WebServiceFeatureAnnotation;
import org.apache.axis2.jaxws.common.config.WSDLExtensionValidator;
import org.apache.axis2.jaxws.common.config.WSDLValidatorElement;
import org.apache.axis2.jaxws.description.EndpointDescription;
import org.apache.axis2.jaxws.description.EndpointDescriptionJava;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddressingWSDLExtensionValidator
implements WSDLExtensionValidator {
    private static final Log log = LogFactory.getLog(AddressingWSDLExtensionValidator.class);
    private static final boolean debug = log.isDebugEnabled();

    @Override
    public void validate(Set<WSDLValidatorElement> extensionSet, Definition wsdlDefinition, EndpointDescription endpointDesc) {
        if (debug) {
            log.debug((Object)"Looking for WSDL extension elements to validate");
        }
        if (extensionSet.isEmpty()) {
            if (debug) {
                log.debug((Object)"No WSDL extension elements found to validate");
            }
            return;
        }
        if (debug) {
            log.debug((Object)"Processing WSDL extension elements");
        }
        for (WSDLValidatorElement elementToValidate : extensionSet) {
            EndpointDescriptionJava edj;
            Annotation anno;
            ExtensibilityElement ee;
            QName name;
            if (elementToValidate.getState() != WSDLValidatorElement.State.NOT_RECOGNIZED || (name = (ee = elementToValidate.getExtensionElement()) != null ? ee.getElementType() : null) == null || !name.equals(new QName("http://www.w3.org/2006/05/addressing/wsdl", "UsingAddressing"))) continue;
            if (debug) {
                log.debug((Object)"Found WSDL extension element {http://www.w3.org/2006/05/addressing/wsdl,UsingAddressing} -- validating");
            }
            if (this.getFeatureFromAnnotation(anno = (edj = (EndpointDescriptionJava)((Object)endpointDesc)).getAnnoFeature("http://www.w3.org/2005/08/addressing/module")) == null) {
                if (debug) {
                    log.debug((Object)"Enabling addressing annotation was not found, so this extension element is not supported");
                }
                elementToValidate.setState(WSDLValidatorElement.State.NOT_SUPPORTED);
                continue;
            }
            if (debug) {
                log.debug((Object)"The matching addressing annotation was found, so this extension element is supported");
            }
            elementToValidate.setState(WSDLValidatorElement.State.SUPPORTED);
        }
    }

    private WebServiceFeatureAnnotation getFeatureFromAnnotation(Annotation a) {
        return a.annotationType().getAnnotation(WebServiceFeatureAnnotation.class);
    }
}

